/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.interpreter.filters;

import com.alibaba.fastsql.interpreter.Filter;
import com.alibaba.fastsql.interpreter.filters.FieldValueProvider;
import com.alibaba.fastsql.interpreter.filters.ListOp;
import java.util.Arrays;

public class ListIntFilter
implements Filter {
    private final int[] values;
    private ListOp operator;
    protected final FieldValueProvider fieldValueProvider;

    public ListIntFilter(FieldValueProvider fieldValueProvider, ListOp operator, int[] values) {
        this.fieldValueProvider = fieldValueProvider;
        this.operator = operator;
        this.values = values;
        Arrays.sort(values);
    }

    public Object getFieldValue(Object object) throws Exception {
        return this.fieldValueProvider.getFieldValue(object);
    }

    @Override
    public boolean test(Object o) throws Exception {
        Object fieldValue = this.getFieldValue(o);
        if (fieldValue instanceof Integer || fieldValue instanceof Short || fieldValue instanceof Byte) {
            int intVal = ((Number)fieldValue).intValue();
            switch (this.operator) {
                case IN: {
                    return Arrays.binarySearch(this.values, intVal) >= 0;
                }
                case NOT_IN: {
                    return Arrays.binarySearch(this.values, intVal) < 0;
                }
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }
}

