/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLObjectImpl;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.dialect.mysql.ast.MySqlObject;
import com.alibaba.fastsql.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.HashMap;

public final class SQLLimit
extends SQLObjectImpl {
    private SQLExpr rowCount;
    private SQLExpr offset;

    public SQLLimit() {
    }

    public SQLLimit(int rowCount) {
        this.setRowCount(new SQLIntegerExpr(rowCount));
    }

    public SQLLimit(SQLExpr rowCount) {
        this.setRowCount(rowCount);
    }

    public SQLLimit(SQLExpr offset, SQLExpr rowCount) {
        this.setOffset(offset);
        this.setRowCount(rowCount);
    }

    public SQLExpr getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(SQLExpr rowCount) {
        if (rowCount != null) {
            rowCount.setParent(this);
        }
        this.rowCount = rowCount;
    }

    public void setRowCount(int rowCount) {
        this.setRowCount(new SQLIntegerExpr(rowCount));
    }

    public SQLExpr getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.setOffset(new SQLIntegerExpr(offset));
    }

    public void setOffset(SQLExpr offset) {
        if (offset != null) {
            offset.setParent(this);
        }
        this.offset = offset;
    }

    public void merge(SQLLimit limit) {
        if (limit == null) {
            return;
        }
        if (limit.offset != null && this.offset == null) {
            this.offset = limit.offset.clone();
        }
        if (limit.rowCount != null && this.rowCount == null) {
            this.rowCount = limit.rowCount.clone();
        }
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.offset);
            this.acceptChild(visitor, this.rowCount);
        }
        visitor.endVisit(this);
    }

    @Override
    public void output(StringBuffer buf) {
        DbType dbType = null;
        if (this.parent instanceof MySqlObject) {
            dbType = DbType.mysql;
        }
        SQLASTOutputVisitor visitor = SQLUtils.createOutputVisitor(buf, dbType);
        visitor.visit(this);
    }

    @Override
    public SQLLimit clone() {
        SQLLimit x = new SQLLimit();
        if (this.offset != null) {
            x.setOffset(this.offset.clone());
        }
        if (this.rowCount != null) {
            x.setRowCount(this.rowCount.clone());
        }
        if (this.attributes != null) {
            x.attributes = (HashMap)((HashMap)this.attributes).clone();
        }
        return x;
    }
}

