/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast;

import com.alibaba.fastsql.sql.ast.SQLCommentHint;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.dialect.mysql.parser.MySqlExprParser;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;
import java.util.ArrayList;
import java.util.List;

public class TDDLHint
extends SQLCommentHint {
    private List<Function> functions = new ArrayList<Function>();

    public List<Function> getFunctions() {
        return this.functions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TDDLHint(String text) {
        super(text);
        MySqlExprParser hintParser = new MySqlExprParser(text, SQLParserFeature.TDDLHint);
        Lexer lexer = hintParser.getLexer();
        if (lexer.token() == Token.PLUS || lexer.token() == Token.BANG) {
            lexer.nextToken();
        }
        if (!lexer.identifierEquals(FnvHash.Constants.TDDL)) {
            return;
        }
        lexer.nextToken();
        if (lexer.token() != Token.COLON) {
            return;
        }
        lexer.nextToken();
        while (true) {
            Function function;
            Argument argument;
            Function function2;
            SQLExpr value;
            String name = lexer.stringVal();
            long hash = lexer.hash_lower();
            if (lexer.identifierEquals(FnvHash.Constants.NODE)) {
                lexer.nextToken();
                if (lexer.token() == Token.IN) {
                    lexer.nextToken();
                    name = "NODE_IN";
                } else if (lexer.token() == Token.EQ) {
                    lexer.nextToken();
                    name = "NODE_IN";
                    value = hintParser.primary();
                    function2 = new Function(name);
                    argument = new Argument(null, value);
                    function2.getArguments().add(argument);
                    this.functions.add(function2);
                    if (lexer.token() != Token.EOF) continue;
                    return;
                }
            } else if (hash == FnvHash.Constants.SCAN) {
                lexer.nextToken();
                if (lexer.token() == Token.EQ) {
                    lexer.nextToken();
                    value = hintParser.primary();
                    function2 = new Function(name);
                    argument = new Argument(null, value);
                    function2.getArguments().add(argument);
                    this.functions.add(function2);
                    if (lexer.token() != Token.EOF) continue;
                    return;
                }
                if (lexer.token() == Token.EOF) {
                    function = new Function(name);
                    this.functions.add(function);
                    return;
                }
            } else if (hash == FnvHash.Constants.SQL_DELAY_CUTOFF || hash == FnvHash.Constants.SOCKET_TIMEOUT || hash == FnvHash.Constants.FORBID_EXECUTE_DML_ALL) {
                lexer.nextToken();
                if (lexer.token() == Token.EQ) {
                    lexer.nextToken();
                    value = hintParser.primary();
                    function2 = new Function(name);
                    argument = new Argument(null, value);
                    function2.getArguments().add(argument);
                    this.functions.add(function2);
                    if (lexer.token() != Token.EOF) continue;
                    return;
                }
            } else {
                lexer.nextToken();
            }
            if (lexer.token() == Token.DOT) {
                lexer.nextToken();
                if (!lexer.identifierEquals("partition_key")) return;
                String table = name;
                lexer.nextToken();
                hintParser.accept(Token.EQ);
                SQLExpr value2 = hintParser.primary();
                Function function3 = new Function("PARTITIONS");
                this.functions.add(function3);
                function3.getArguments().add(new Argument(new SQLPropertyExpr(name, "partition_key"), value2));
                while (lexer.token() == Token.AND) {
                    lexer.nextToken();
                    SQLExpr key = hintParser.primary();
                    hintParser.accept(Token.EQ);
                    value2 = hintParser.primary();
                    function3.getArguments().add(new Argument(key, value2));
                }
                if (lexer.token() == Token.EOF) {
                    return;
                }
            }
            function = new Function(name);
            this.functions.add(function);
            if (hash == FnvHash.Constants.MASTER && lexer.token() == Token.BAR) {
                lexer.nextToken();
                continue;
            }
            if (hash == FnvHash.Constants.SLAVE) {
                if (lexer.token() == Token.EOF) return;
                if (lexer.token() == Token.AND) {
                    lexer.nextToken();
                    continue;
                }
            }
            hintParser.accept(Token.LPAREN);
            if (lexer.token() != Token.RPAREN) {
                while (true) {
                    Lexer.SavePoint mark = lexer.mark();
                    SQLExpr value3 = null;
                    String keyVal = lexer.stringVal();
                    long keyHash = lexer.hash_lower();
                    lexer.nextToken();
                    SQLIdentifierExpr key = new SQLIdentifierExpr(keyVal, keyHash);
                    if (lexer.token() == Token.EQ) {
                        hintParser.accept(Token.EQ);
                        if (lexer.token() == Token.LITERAL_ALIAS) {
                            String stringVal = lexer.stringVal();
                            stringVal = stringVal.substring(1, stringVal.length() - 1);
                            value3 = new SQLCharExpr(stringVal);
                            value3 = hintParser.exprRest(value3);
                            lexer.nextToken();
                        } else {
                            value3 = hintParser.expr();
                        }
                    }
                    if (value3 == null) {
                        lexer.reset(mark);
                        key = null;
                        value3 = hintParser.expr();
                    }
                    Argument argument2 = new Argument(key, value3);
                    function.getArguments().add(argument2);
                    if (lexer.token() == Token.COMMA) {
                        lexer.nextToken();
                        continue;
                    }
                    if (lexer.token() == Token.RPAREN) break;
                }
                lexer.nextToken();
            } else {
                lexer.nextToken();
            }
            if (hash == FnvHash.Constants.MASTER && lexer.token() == Token.BAR) {
                lexer.nextToken();
            }
            if (lexer.token() == Token.EOF) return;
        }
    }

    public static class Argument {
        private final SQLExpr name;
        private final SQLExpr value;

        public Argument(SQLExpr name, SQLExpr value) {
            this.name = name;
            this.value = value;
        }

        public SQLExpr getName() {
            return this.name;
        }

        public SQLExpr getValue() {
            return this.value;
        }
    }

    public static class Function {
        private final String name;
        private final List<Argument> arguments = new ArrayList<Argument>();

        public Function(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<Argument> getArguments() {
            return this.arguments;
        }
    }
}

