/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.expr;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.ast.SQLReplaceable;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class SQLBinaryOpExprGroup
extends SQLExprImpl
implements SQLReplaceable {
    private final SQLBinaryOperator operator;
    private final List<SQLExpr> items = new ArrayList<SQLExpr>();
    private DbType dbType;

    public SQLBinaryOpExprGroup(SQLBinaryOperator operator) {
        this.operator = operator;
    }

    public SQLBinaryOpExprGroup(SQLBinaryOperator operator, DbType dbType) {
        this.operator = operator;
        this.dbType = dbType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLBinaryOpExprGroup that = (SQLBinaryOpExprGroup)o;
        if (this.operator != that.operator) {
            return false;
        }
        return this.items.equals(that.items);
    }

    @Override
    public int hashCode() {
        int result = this.operator != null ? this.operator.hashCode() : 0;
        result = 31 * result + this.items.hashCode();
        return result;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.items);
        }
        visitor.endVisit(this);
    }

    @Override
    public SQLExpr clone() {
        SQLBinaryOpExprGroup x = new SQLBinaryOpExprGroup(this.operator);
        for (SQLExpr item : this.items) {
            SQLExpr item2 = item.clone();
            item2.setParent(this);
            x.items.add(item2);
        }
        return x;
    }

    public List getChildren() {
        return this.items;
    }

    public void add(SQLExpr item) {
        if (item instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)item;
            if (binaryOpExpr.getOperator() == this.operator) {
                this.add(binaryOpExpr.getLeft());
                this.add(binaryOpExpr.getRight());
                return;
            }
        } else if (item instanceof SQLBinaryOpExprGroup) {
            SQLBinaryOpExprGroup group = (SQLBinaryOpExprGroup)item;
            if (group.operator == this.operator) {
                for (SQLExpr sqlExpr : group.getItems()) {
                    this.add(sqlExpr);
                }
                return;
            }
        }
        if (item != null) {
            item.setParent(this);
        }
        this.items.add(item);
    }

    public List<SQLExpr> getItems() {
        return this.items;
    }

    public SQLBinaryOperator getOperator() {
        return this.operator;
    }

    @Override
    public String toString() {
        return SQLUtils.toSQLString(this, this.dbType);
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        boolean replaced = false;
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) != expr) continue;
            if (target == null) {
                this.items.remove(i);
            } else {
                target.setParent(this);
                this.items.set(i, target);
            }
            replaced = true;
        }
        if (this.items.size() == 1 && replaced) {
            SQLUtils.replaceInParent(this, this.items.get(0));
        }
        return replaced;
    }

    public void optimize() {
        int i;
        ArrayList<Integer> dupIndexList = null;
        LinkedHashSet<SQLExpr> itemSet = new LinkedHashSet<SQLExpr>();
        for (i = 0; i < this.items.size(); ++i) {
            if (itemSet.add(this.items.get(i))) continue;
            if (dupIndexList == null) {
                dupIndexList = new ArrayList<Integer>();
            }
            dupIndexList.add(i);
        }
        if (dupIndexList != null) {
            for (i = dupIndexList.size() - 1; i >= 0; --i) {
                int index = (Integer)dupIndexList.get(i);
                this.items.remove(index);
            }
        }
    }
}

