/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.expr;

import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLDataTypeImpl;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLValuableExpr;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public final class SQLBooleanExpr
extends SQLExprImpl
implements SQLExpr,
SQLLiteralExpr,
SQLValuableExpr {
    public static final SQLDataType DEFAULT_DATA_TYPE = new SQLDataTypeImpl("BOOLEAN");
    private boolean value;

    public SQLBooleanExpr() {
    }

    public SQLBooleanExpr(boolean value) {
        this.value = value;
    }

    public boolean getBooleanValue() {
        return this.value;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public void output(StringBuffer buf) {
        buf.append(this.value ? "TRUE" : "FALSE");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLBooleanExpr other = (SQLBooleanExpr)obj;
        return this.value == other.value;
    }

    @Override
    public SQLDataType computeDataType() {
        return DEFAULT_DATA_TYPE;
    }

    @Override
    public SQLBooleanExpr clone() {
        return new SQLBooleanExpr(this.value);
    }

    public List getChildren() {
        return Collections.emptyList();
    }

    public static enum Type {
        ON_OFF;

    }
}

