/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.expr;

import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.ast.SQLObjectWithDataType;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.Arrays;
import java.util.List;

public class SQLCastExpr
extends SQLExprImpl
implements SQLObjectWithDataType {
    protected SQLExpr expr;
    protected SQLDataType dataType;

    public SQLCastExpr() {
    }

    public SQLCastExpr(SQLExpr expr, SQLDataType dataType) {
        this.setExpr(expr);
        this.setDataType(dataType);
    }

    public SQLExpr getExpr() {
        return this.expr;
    }

    public void setExpr(SQLExpr expr) {
        if (expr != null) {
            expr.setParent(this);
        }
        this.expr = expr;
    }

    @Override
    public SQLDataType getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(SQLDataType dataType) {
        if (dataType != null) {
            dataType.setParent(this);
        }
        this.dataType = dataType;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.expr);
            this.acceptChild(visitor, this.dataType);
        }
        visitor.endVisit(this);
    }

    public List getChildren() {
        return Arrays.asList(this.expr, this.dataType);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLCastExpr other = (SQLCastExpr)obj;
        if (this.dataType == null ? other.dataType != null : !this.dataType.equals(other.dataType)) {
            return false;
        }
        return !(this.expr == null ? other.expr != null : !this.expr.equals(other.expr));
    }

    @Override
    public SQLDataType computeDataType() {
        return this.dataType;
    }

    @Override
    public SQLCastExpr clone() {
        SQLCastExpr x = new SQLCastExpr();
        if (this.expr != null) {
            x.setExpr(this.expr.clone());
        }
        if (this.dataType != null) {
            x.setDataType(this.dataType.clone());
        }
        return x;
    }
}

