/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.expr;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLDataTypeImpl;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLValuableExpr;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class SQLDateExpr
extends SQLExprImpl
implements SQLLiteralExpr,
SQLValuableExpr {
    public static final SQLDataType DEFAULT_DATA_TYPE = new SQLDataTypeImpl("date");
    private SQLExpr literal;
    public static long supportDbTypes = DbType.of(DbType.mysql, DbType.oracle, DbType.presto, DbType.postgresql, DbType.ads);

    public SQLDateExpr() {
    }

    public SQLDateExpr(String literal) {
        this.setLiteral(literal);
    }

    public SQLExpr getLiteral() {
        return this.literal;
    }

    public void setLiteral(String literal) {
        this.setLiteral(new SQLCharExpr(literal));
    }

    public void setLiteral(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.literal = x;
    }

    @Override
    public String getValue() {
        if (this.literal instanceof SQLCharExpr) {
            return ((SQLCharExpr)this.literal).getText();
        }
        return null;
    }

    public Date getDate() {
        if (this.literal instanceof SQLCharExpr) {
            String chars = ((SQLCharExpr)this.literal).getText();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            try {
                return format.parse(chars);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean addDay(int delta) {
        if (this.literal == null) {
            return false;
        }
        if (this.literal instanceof SQLCharExpr) {
            String chars = ((SQLCharExpr)this.literal).getText();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date date = format.parse(chars);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.add(5, delta);
                String result_chars = format.format(calendar.getTime());
                this.setLiteral(result_chars);
                return true;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.literal == null ? 0 : this.literal.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLDateExpr other = (SQLDateExpr)obj;
        return !(this.literal == null ? other.literal != null : !this.literal.equals(other.literal));
    }

    @Override
    public SQLDateExpr clone() {
        SQLDateExpr x = new SQLDateExpr();
        if (this.literal != null) {
            x.setLiteral(this.literal.clone());
        }
        return x;
    }

    @Override
    public List<SQLObject> getChildren() {
        return Collections.emptyList();
    }

    public static boolean isSupport(DbType dbType) {
        return (dbType.mask & supportDbTypes) != 0L;
    }
}

