/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.expr;

import com.alibaba.fastsql.FastsqlException;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLDataTypeImpl;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLValuableExpr;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;

public class SQLIntegerExpr
extends SQLNumericLiteralExpr
implements SQLValuableExpr {
    public static final SQLDataType DEFAULT_DATA_TYPE = new SQLDataTypeImpl("bigint");
    private Number number;

    public SQLIntegerExpr(Number number) {
        this.number = number;
    }

    public SQLIntegerExpr() {
    }

    @Override
    public Number getNumber() {
        return this.number;
    }

    @Override
    public void setNumber(Number number) {
        this.number = number;
    }

    @Override
    public void output(StringBuffer buf) {
        buf.append(this.number);
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.number == null ? 0 : this.number.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLIntegerExpr other = (SQLIntegerExpr)obj;
        return !(this.number == null ? other.number != null : !this.number.equals(other.number));
    }

    @Override
    public Object getValue() {
        return this.number;
    }

    @Override
    public SQLIntegerExpr clone() {
        return new SQLIntegerExpr(this.number);
    }

    @Override
    public SQLDataType computeDataType() {
        return DEFAULT_DATA_TYPE;
    }

    public void decrement() {
        if (this.number instanceof Integer) {
            this.number = Integer.valueOf(this.number.intValue()) - 1;
        } else if (this.number instanceof Long) {
            this.number = Long.valueOf(this.number.longValue()) - 1L;
        } else {
            throw new FastsqlException("decrement not support.");
        }
    }

    public static boolean isZero(SQLExpr expr) {
        if (expr instanceof SQLIntegerExpr) {
            Number number = ((SQLIntegerExpr)expr).getNumber();
            return number != null && number.intValue() == 0;
        }
        return false;
    }

    public static SQLIntegerExpr substract(SQLIntegerExpr a, SQLIntegerExpr b) {
        int val = a.number.intValue() - b.number.intValue();
        return new SQLIntegerExpr(val);
    }

    public static SQLIntegerExpr least(SQLIntegerExpr a, SQLIntegerExpr b) {
        if (a == null) {
            return b;
        }
        if (a.number.intValue() <= b.number.intValue()) {
            return a;
        }
        return b;
    }

    public static SQLIntegerExpr greatst(SQLIntegerExpr a, SQLIntegerExpr b) {
        if (a.number.intValue() >= b.number.intValue()) {
            return a;
        }
        return b;
    }
}

