/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.expr;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.ast.expr.SQLIntervalUnit;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class SQLIntervalExpr
extends SQLExprImpl {
    private SQLExpr value;
    private SQLIntervalUnit unit;

    public SQLIntervalExpr() {
    }

    public SQLIntervalExpr(SQLExpr value, SQLIntervalUnit unit) {
        this.setValue(value);
        this.unit = unit;
    }

    @Override
    public SQLIntervalExpr clone() {
        SQLIntervalExpr x = new SQLIntervalExpr();
        if (this.value != null) {
            x.setValue(this.value.clone());
        }
        x.unit = this.unit;
        return x;
    }

    public SQLExpr getValue() {
        return this.value;
    }

    public void setValue(SQLExpr value) {
        this.value = value;
    }

    public SQLIntervalUnit getUnit() {
        return this.unit;
    }

    public void setUnit(SQLIntervalUnit unit) {
        this.unit = unit;
    }

    @Override
    public void output(StringBuffer buf) {
        buf.append("INTERVAL ");
        this.value.output(buf);
        if (this.unit != null) {
            buf.append(' ');
            buf.append(this.unit.name());
        }
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.value);
        }
        visitor.endVisit(this);
    }

    public List getChildren() {
        return Collections.singletonList(this.value);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLIntervalExpr other = (SQLIntervalExpr)obj;
        if (this.unit != other.unit) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

