/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.expr;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLMatchAgainstExpr
extends SQLExprImpl {
    private List<SQLExpr> columns = new ArrayList<SQLExpr>();
    private SQLExpr against;
    private SearchModifier searchModifier;

    @Override
    public SQLMatchAgainstExpr clone() {
        SQLMatchAgainstExpr x = new SQLMatchAgainstExpr();
        for (SQLExpr column : this.columns) {
            SQLExpr column2 = column.clone();
            column2.setParent(x);
            x.columns.add(column2);
        }
        if (this.against != null) {
            x.setAgainst(this.against.clone());
        }
        x.searchModifier = this.searchModifier;
        return x;
    }

    public List<SQLExpr> getColumns() {
        return this.columns;
    }

    public void setColumns(List<SQLExpr> columns) {
        this.columns = columns;
    }

    public SQLExpr getAgainst() {
        return this.against;
    }

    public void setAgainst(SQLExpr against) {
        if (against != null) {
            against.setParent(this);
        }
        this.against = against;
    }

    public SearchModifier getSearchModifier() {
        return this.searchModifier;
    }

    public void setSearchModifier(SearchModifier searchModifier) {
        this.searchModifier = searchModifier;
    }

    @Override
    protected void accept0(SQLASTVisitor v) {
        if (v.visit(this)) {
            this.acceptChild(v, this.columns);
            this.acceptChild(v, this.against);
        }
        v.endVisit(this);
    }

    public List getChildren() {
        ArrayList<SQLExpr> children = new ArrayList<SQLExpr>();
        children.addAll(this.columns);
        children.add(this.against);
        return children;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.against == null ? 0 : this.against.hashCode());
        result = 31 * result + (this.columns == null ? 0 : this.columns.hashCode());
        result = 31 * result + (this.searchModifier == null ? 0 : this.searchModifier.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLMatchAgainstExpr other = (SQLMatchAgainstExpr)obj;
        if (this.against == null ? other.against != null : !this.against.equals(other.against)) {
            return false;
        }
        if (this.columns == null ? other.columns != null : !this.columns.equals(other.columns)) {
            return false;
        }
        return this.searchModifier == other.searchModifier;
    }

    public static enum SearchModifier {
        IN_BOOLEAN_MODE("IN BOOLEAN MODE"),
        IN_NATURAL_LANGUAGE_MODE("IN NATURAL LANGUAGE MODE"),
        IN_NATURAL_LANGUAGE_MODE_WITH_QUERY_EXPANSION("IN NATURAL LANGUAGE MODE WITH QUERY EXPANSION"),
        WITH_QUERY_EXPANSION("WITH QUERY EXPANSION");

        public final String name;
        public final String name_lcase;

        private SearchModifier() {
            this(null);
        }

        private SearchModifier(String name) {
            this.name = name;
            this.name_lcase = name.toLowerCase();
        }
    }
}

