/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.expr;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.ast.SQLReplaceable;
import com.alibaba.fastsql.sql.ast.expr.SQLDateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import com.alibaba.fastsql.util.FnvHash;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SQLMethodInvokeExpr
extends SQLExprImpl
implements SQLReplaceable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String methodName;
    protected long methodNameHashCode64;
    protected SQLExpr owner;
    protected final List<SQLExpr> arguments = new ArrayList<SQLExpr>();
    private SQLExpr from;
    private SQLExpr using;
    private SQLExpr _for;
    private String trimOption;
    private transient SQLDataType resolvedReturnDataType;

    public SQLMethodInvokeExpr() {
    }

    public SQLMethodInvokeExpr(String methodName) {
        this.methodName = methodName;
    }

    public SQLMethodInvokeExpr(String methodName, long methodNameHashCode64) {
        this.methodName = methodName;
        this.methodNameHashCode64 = methodNameHashCode64;
    }

    public SQLMethodInvokeExpr(String methodName, SQLExpr owner) {
        this.methodName = methodName;
        this.setOwner(owner);
    }

    public SQLMethodInvokeExpr(String methodName, SQLExpr owner, SQLExpr ... params) {
        this.methodName = methodName;
        this.setOwner(owner);
        for (SQLExpr param : params) {
            this.addArgument(param);
        }
    }

    public long methodNameHashCode64() {
        if (this.methodNameHashCode64 == 0L && this.methodName != null) {
            this.methodNameHashCode64 = FnvHash.hashCode64(this.methodName);
        }
        return this.methodNameHashCode64;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
        this.methodNameHashCode64 = 0L;
    }

    public List<SQLExpr> getParameters() {
        return this.arguments;
    }

    public List<SQLExpr> getArguments() {
        return this.arguments;
    }

    public void addParameter(SQLExpr param) {
        if (param != null) {
            param.setParent(this);
        }
        this.arguments.add(param);
    }

    public void addArgument(SQLExpr arg) {
        if (arg != null) {
            arg.setParent(this);
        }
        this.arguments.add(arg);
    }

    public SQLExpr getOwner() {
        return this.owner;
    }

    public void setOwner(SQLExpr owner) {
        if (owner != null) {
            owner.setParent(this);
        }
        this.owner = owner;
    }

    public SQLExpr getFrom() {
        return this.from;
    }

    public void setFrom(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.from = x;
    }

    @Override
    public void output(StringBuffer buf) {
        if (this.owner != null) {
            this.owner.output(buf);
            buf.append(".");
        }
        buf.append(this.methodName);
        buf.append("(");
        int size = this.arguments.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            this.arguments.get(i).output(buf);
        }
        buf.append(")");
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.owner);
            this.acceptChild(visitor, this.arguments);
            this.acceptChild(visitor, this.from);
            this.acceptChild(visitor, this.using);
            this.acceptChild(visitor, this._for);
        }
        visitor.endVisit(this);
    }

    public List getChildren() {
        if (this.owner == null) {
            return this.arguments;
        }
        ArrayList<SQLExpr> children = new ArrayList<SQLExpr>();
        children.add(this.owner);
        children.addAll(this.arguments);
        return children;
    }

    protected void accept0(OracleASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.owner);
            this.acceptChild((SQLASTVisitor)visitor, this.arguments);
            this.acceptChild((SQLASTVisitor)visitor, this.from);
            this.acceptChild((SQLASTVisitor)visitor, this.using);
            this.acceptChild((SQLASTVisitor)visitor, this._for);
        }
        visitor.endVisit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLMethodInvokeExpr that = (SQLMethodInvokeExpr)o;
        if (this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null) {
            return false;
        }
        if (this.owner != null ? !this.owner.equals(that.owner) : that.owner != null) {
            return false;
        }
        if (this.arguments != null ? !this.arguments.equals(that.arguments) : that.arguments != null) {
            return false;
        }
        return this.from != null ? this.from.equals(that.from) : that.from == null;
    }

    @Override
    public int hashCode() {
        int result = this.methodName != null ? this.methodName.hashCode() : 0;
        result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
        result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        return result;
    }

    @Override
    public SQLMethodInvokeExpr clone() {
        SQLMethodInvokeExpr x = new SQLMethodInvokeExpr();
        x.methodName = this.methodName;
        if (this.owner != null) {
            x.setOwner(this.owner.clone());
        }
        for (SQLExpr arg : this.arguments) {
            x.addArgument(arg.clone());
        }
        if (this.from != null) {
            x.setFrom(this.from.clone());
        }
        if (this.using != null) {
            x.setUsing(this.using.clone());
        }
        if (this.trimOption != null) {
            x.setTrimOption(this.trimOption);
        }
        return x;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (target == null) {
            return false;
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (this.arguments.get(i) != expr) continue;
            this.arguments.set(i, target);
            target.setParent(this);
            return true;
        }
        if (this.from == expr) {
            this.setFrom(target);
            return true;
        }
        if (this.using == expr) {
            this.setUsing(target);
            return true;
        }
        if (this._for == expr) {
            this.setFor(target);
            return true;
        }
        return false;
    }

    public boolean match(String owner, String function) {
        if (function == null) {
            return false;
        }
        if (!SQLUtils.nameEquals(function, this.methodName)) {
            return false;
        }
        if (owner == null && this.owner == null) {
            return true;
        }
        if (owner == null || this.owner == null) {
            return false;
        }
        if (this.owner instanceof SQLIdentifierExpr) {
            return SQLUtils.nameEquals(((SQLIdentifierExpr)this.owner).name, owner);
        }
        return false;
    }

    @Override
    public SQLDataType computeDataType() {
        if (SQLUtils.nameEquals("to_date", this.methodName) || SQLUtils.nameEquals("add_months", this.methodName)) {
            return SQLDateExpr.DEFAULT_DATA_TYPE;
        }
        if (this.arguments.size() == 1) {
            if (SQLUtils.nameEquals("trunc", this.methodName)) {
                return this.arguments.get(0).computeDataType();
            }
        } else if (this.arguments.size() == 2) {
            SQLExpr param0 = this.arguments.get(0);
            SQLExpr param1 = this.arguments.get(1);
            if (SQLUtils.nameEquals("nvl", this.methodName) || SQLUtils.nameEquals("ifnull", this.methodName)) {
                SQLDataType dataType = param0.computeDataType();
                if (dataType != null) {
                    return dataType;
                }
                return param1.computeDataType();
            }
        }
        return null;
    }

    public SQLExpr getUsing() {
        return this.using;
    }

    public void setUsing(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.using = x;
    }

    public SQLExpr getFor() {
        return this._for;
    }

    public void setFor(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this._for = x;
    }

    public String getTrimOption() {
        return this.trimOption;
    }

    public void setTrimOption(String trimOption) {
        this.trimOption = trimOption;
    }

    public SQLDataType getResolvedReturnDataType() {
        return this.resolvedReturnDataType;
    }

    public void setResolvedReturnDataType(SQLDataType resolvedReturnDataType) {
        this.resolvedReturnDataType = resolvedReturnDataType;
    }
}

