/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.expr;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.SQLReplaceable;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateProcedureStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import com.alibaba.fastsql.util.FnvHash;
import java.util.Collections;
import java.util.List;

public final class SQLPropertyExpr
extends SQLExprImpl
implements SQLName,
SQLReplaceable {
    private SQLExpr owner;
    private String name;
    protected long nameHashCod64;
    protected long hashCode64;
    protected SQLColumnDefinition resolvedColumn;
    protected SQLObject resolvedOwnerObject;

    public SQLPropertyExpr(String owner, String name) {
        this(new SQLIdentifierExpr(owner), name);
    }

    public SQLPropertyExpr(SQLExpr owner, String name) {
        this.setOwner(owner);
        this.name = name;
    }

    public SQLPropertyExpr(SQLExpr owner, String name, long nameHashCod64) {
        this.setOwner(owner);
        this.name = name;
        this.nameHashCod64 = nameHashCod64;
    }

    public SQLPropertyExpr() {
    }

    @Override
    public String getSimpleName() {
        return this.name;
    }

    public SQLExpr getOwner() {
        return this.owner;
    }

    public String getOwnernName() {
        if (this.owner instanceof SQLName) {
            return ((SQLName)this.owner).toString();
        }
        return null;
    }

    public void setOwner(SQLExpr owner) {
        if (owner != null) {
            owner.setParent(this);
        }
        if (this.parent instanceof SQLPropertyExpr) {
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)this.parent;
            propertyExpr.computeHashCode64();
        }
        this.owner = owner;
        this.hashCode64 = 0L;
    }

    protected void computeHashCode64() {
        long hash;
        if (this.owner instanceof SQLName) {
            hash = ((SQLName)this.owner).hashCode64();
            hash ^= 0x2EL;
            hash *= 1099511628211L;
        } else if (this.owner == null) {
            hash = -3750763034362895579L;
        } else {
            hash = FnvHash.fnv1a_64_lower(this.owner.toString());
            hash ^= 0x2EL;
            hash *= 1099511628211L;
        }
        this.hashCode64 = hash = FnvHash.hashCode64(hash, this.name);
    }

    public void setOwner(String owner) {
        this.setOwner(new SQLIdentifierExpr(owner));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.hashCode64 = 0L;
        this.nameHashCod64 = 0L;
        if (this.parent instanceof SQLPropertyExpr) {
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)this.parent;
            propertyExpr.computeHashCode64();
        }
    }

    @Override
    public void output(StringBuffer buf) {
        this.owner.output(buf);
        buf.append(".");
        buf.append(this.name);
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.owner);
        }
        visitor.endVisit(this);
    }

    public List getChildren() {
        return Collections.singletonList(this.owner);
    }

    @Override
    public int hashCode() {
        long hash = this.hashCode64();
        return (int)(hash ^ hash >>> 32);
    }

    @Override
    public long hashCode64() {
        if (this.hashCode64 == 0L) {
            this.computeHashCode64();
        }
        return this.hashCode64;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SQLPropertyExpr)) {
            return false;
        }
        SQLPropertyExpr other = (SQLPropertyExpr)obj;
        if (this.nameHashCode64() != other.nameHashCode64()) {
            return false;
        }
        return !(this.owner == null ? other.owner != null : !this.owner.equals(other.owner));
    }

    @Override
    public SQLPropertyExpr clone() {
        SQLExpr owner_x = null;
        if (this.owner != null) {
            owner_x = this.owner.clone();
        }
        SQLPropertyExpr x = new SQLPropertyExpr(owner_x, this.name, this.nameHashCod64);
        x.hashCode64 = this.hashCode64;
        x.resolvedColumn = this.resolvedColumn;
        x.resolvedOwnerObject = this.resolvedOwnerObject;
        return x;
    }

    public boolean matchOwner(String alias) {
        if (this.owner instanceof SQLIdentifierExpr) {
            return ((SQLIdentifierExpr)this.owner).getName().equalsIgnoreCase(alias);
        }
        return false;
    }

    @Override
    public long nameHashCode64() {
        if (this.nameHashCod64 == 0L && this.name != null) {
            this.nameHashCod64 = FnvHash.hashCode64(this.name);
        }
        return this.nameHashCod64;
    }

    public String normalizedName() {
        String ownerName = this.owner instanceof SQLIdentifierExpr ? ((SQLIdentifierExpr)this.owner).normalizedName() : (this.owner instanceof SQLPropertyExpr ? ((SQLPropertyExpr)this.owner).normalizedName() : this.owner.toString());
        return ownerName + '.' + SQLUtils.normalize(this.name);
    }

    public SQLColumnDefinition getResolvedColumn() {
        return this.resolvedColumn;
    }

    public void setResolvedColumn(SQLColumnDefinition resolvedColumn) {
        this.resolvedColumn = resolvedColumn;
    }

    public SQLTableSource getResolvedTableSource() {
        if (this.resolvedOwnerObject instanceof SQLTableSource) {
            return (SQLTableSource)this.resolvedOwnerObject;
        }
        return null;
    }

    public void setResolvedTableSource(SQLTableSource resolvedTableSource) {
        this.resolvedOwnerObject = resolvedTableSource;
    }

    public void setResolvedProcedure(SQLCreateProcedureStatement stmt) {
        this.resolvedOwnerObject = stmt;
    }

    public void setResolvedOwnerObject(SQLObject resolvedOwnerObject) {
        this.resolvedOwnerObject = resolvedOwnerObject;
    }

    public SQLCreateProcedureStatement getResolvedProcudure() {
        if (this.resolvedOwnerObject instanceof SQLCreateProcedureStatement) {
            return (SQLCreateProcedureStatement)this.resolvedOwnerObject;
        }
        return null;
    }

    public SQLObject getResolvedOwnerObject() {
        return this.resolvedOwnerObject;
    }

    @Override
    public SQLDataType computeDataType() {
        if (this.resolvedColumn != null) {
            return this.resolvedColumn.getDataType();
        }
        if (this.resolvedOwnerObject != null && this.resolvedOwnerObject instanceof SQLSubqueryTableSource) {
            SQLSelect select = ((SQLSubqueryTableSource)this.resolvedOwnerObject).getSelect();
            SQLSelectQueryBlock queryBlock = select.getFirstQueryBlock();
            if (queryBlock == null) {
                return null;
            }
            SQLSelectItem selectItem = queryBlock.findSelectItem(this.nameHashCode64());
            if (selectItem != null) {
                return selectItem.computeDataType();
            }
        }
        return null;
    }

    public boolean nameEquals(String name) {
        return SQLUtils.nameEquals(this.name, name);
    }

    public SQLPropertyExpr simplify() {
        String normalizedName = SQLUtils.normalize(this.name);
        SQLExpr normalizedOwner = this.owner;
        if (normalizedOwner instanceof SQLIdentifierExpr) {
            normalizedOwner = ((SQLIdentifierExpr)normalizedOwner).simplify();
        }
        if (normalizedName != this.name || normalizedOwner != this.owner) {
            return new SQLPropertyExpr(normalizedOwner, normalizedName, this.hashCode64);
        }
        return this;
    }

    @Override
    public String toString() {
        if (this.owner == null) {
            return this.name;
        }
        return this.owner.toString() + '.' + this.name;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (expr == this.owner) {
            this.setOwner(target);
            return true;
        }
        return false;
    }
}

