/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.expr;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLDataTypeImpl;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.ast.expr.SQLValuableExpr;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class SQLTimestampExpr
extends SQLExprImpl
implements SQLValuableExpr {
    public static final SQLDataType DEFAULT_DATA_TYPE = new SQLDataTypeImpl("datetime");
    protected String literal;
    protected String timeZone;
    protected boolean withTimeZone = false;

    public SQLTimestampExpr() {
    }

    public SQLTimestampExpr(String literal) {
        this.literal = literal;
    }

    @Override
    public SQLTimestampExpr clone() {
        SQLTimestampExpr x = new SQLTimestampExpr();
        x.literal = this.literal;
        x.timeZone = this.timeZone;
        x.withTimeZone = this.withTimeZone;
        return x;
    }

    @Override
    public String getValue() {
        return this.literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public void setLiteral(String literal) {
        this.literal = literal;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public boolean isWithTimeZone() {
        return this.withTimeZone;
    }

    public void setWithTimeZone(boolean withTimeZone) {
        this.withTimeZone = withTimeZone;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.literal == null ? 0 : this.literal.hashCode());
        result = 31 * result + (this.timeZone == null ? 0 : this.timeZone.hashCode());
        result = 31 * result + (this.withTimeZone ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLTimestampExpr other = (SQLTimestampExpr)obj;
        if (this.literal == null ? other.literal != null : !this.literal.equals(other.literal)) {
            return false;
        }
        if (this.timeZone == null ? other.timeZone != null : !this.timeZone.equals(other.timeZone)) {
            return false;
        }
        return this.withTimeZone == other.withTimeZone;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public String toString() {
        return SQLUtils.toSQLString(this, null);
    }

    @Override
    public SQLDataType computeDataType() {
        return DEFAULT_DATA_TYPE;
    }

    public List getChildren() {
        return Collections.emptyList();
    }
}

