/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.statement;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.SQLStatementImpl;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SQLCreateIndexStatement
extends SQLStatementImpl
implements SQLCreateStatement {
    private SQLName name;
    private SQLTableSource table;
    private List<SQLSelectOrderByItem> items = new ArrayList<SQLSelectOrderByItem>();
    private String type;
    private String using;
    private SQLExpr comment;
    private boolean concurrently;
    protected Map<String, SQLObject> options = new LinkedHashMap<String, SQLObject>();
    protected SQLName tablespace;

    public SQLCreateIndexStatement() {
    }

    public SQLCreateIndexStatement(DbType dbType) {
        super(dbType);
    }

    public SQLTableSource getTable() {
        return this.table;
    }

    public void setTable(SQLName table) {
        this.setTable(new SQLExprTableSource(table));
    }

    public void setTable(SQLTableSource table) {
        this.table = table;
    }

    public String getTableName() {
        if (this.table instanceof SQLExprTableSource) {
            SQLExpr expr = ((SQLExprTableSource)this.table).getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                return ((SQLIdentifierExpr)expr).getName();
            }
            if (expr instanceof SQLPropertyExpr) {
                return ((SQLPropertyExpr)expr).getName();
            }
        }
        return null;
    }

    public List<SQLSelectOrderByItem> getItems() {
        return this.items;
    }

    public void addItem(SQLSelectOrderByItem item) {
        if (item != null) {
            item.setParent(this);
        }
        this.items.add(item);
    }

    public SQLName getName() {
        return this.name;
    }

    public void setName(SQLName name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUsing() {
        return this.using;
    }

    public void setUsing(String using) {
        this.using = using;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.name);
            this.acceptChild(visitor, this.table);
            this.acceptChild(visitor, this.items);
        }
        visitor.endVisit(this);
    }

    @Override
    public List<SQLObject> getChildren() {
        ArrayList<SQLObject> children = new ArrayList<SQLObject>();
        if (this.name != null) {
            children.add(this.name);
        }
        if (this.table != null) {
            children.add(this.table);
        }
        children.addAll(this.items);
        return children;
    }

    public String getSchema() {
        SQLExpr expr;
        SQLName name = null;
        if (this.table instanceof SQLExprTableSource && (expr = ((SQLExprTableSource)this.table).getExpr()) instanceof SQLName) {
            name = (SQLName)expr;
        }
        if (name == null) {
            return null;
        }
        if (name instanceof SQLPropertyExpr) {
            return ((SQLPropertyExpr)name).getOwnernName();
        }
        return null;
    }

    @Override
    public SQLCreateIndexStatement clone() {
        SQLCreateIndexStatement x = new SQLCreateIndexStatement();
        if (this.name != null) {
            x.setName(this.name.clone());
        }
        if (this.table != null) {
            x.setTable(this.table.clone());
        }
        for (SQLSelectOrderByItem item : this.items) {
            SQLSelectOrderByItem item2 = item.clone();
            item2.setParent(x);
            x.items.add(item2);
        }
        x.type = this.type;
        x.using = this.using;
        if (this.comment != null) {
            x.setComment(this.comment.clone());
        }
        return x;
    }

    public SQLExpr getComment() {
        return this.comment;
    }

    public void setComment(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.comment = x;
    }

    public SQLName getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(SQLName x) {
        if (x != null) {
            x.setParent(this);
        }
        this.tablespace = x;
    }

    public boolean isConcurrently() {
        return this.concurrently;
    }

    public void setConcurrently(boolean concurrently) {
        this.concurrently = concurrently;
    }

    public Map<String, SQLObject> getOptions() {
        return this.options;
    }
}

