/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.statement;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLCommentHint;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLLimit;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObjectImpl;
import com.alibaba.fastsql.sql.ast.SQLOrderBy;
import com.alibaba.fastsql.sql.ast.SQLReplaceable;
import com.alibaba.fastsql.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExprGroup;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import com.alibaba.fastsql.util.FnvHash;
import java.util.ArrayList;
import java.util.List;

public class SQLSelectQueryBlock
extends SQLObjectImpl
implements SQLSelectQuery,
SQLReplaceable {
    private boolean bracket = false;
    protected int distionOption;
    protected final List<SQLSelectItem> selectList = new ArrayList<SQLSelectItem>();
    protected SQLTableSource from;
    protected SQLExprTableSource into;
    protected SQLExpr where;
    protected SQLExpr startWith;
    protected SQLExpr connectBy;
    protected boolean prior = false;
    protected boolean noCycle = false;
    protected SQLOrderBy orderBySiblings;
    protected SQLSelectGroupByClause groupBy;
    protected SQLOrderBy orderBy;
    protected boolean parenthesized = false;
    protected boolean forUpdate = false;
    protected boolean noWait = false;
    protected SQLExpr waitTime;
    protected SQLLimit limit;
    protected List<SQLExpr> forUpdateOf;
    protected List<SQLExpr> distributeBy;
    protected List<SQLSelectOrderByItem> sortBy;
    protected String cachedSelectList;
    protected long cachedSelectListHash;
    protected DbType dbType;
    protected List<SQLCommentHint> hints;

    public SQLSelectQueryBlock() {
    }

    public SQLSelectQueryBlock(DbType dbType) {
        this.dbType = dbType;
    }

    public SQLExprTableSource getInto() {
        return this.into;
    }

    public void setInto(SQLExpr into) {
        this.setInto(new SQLExprTableSource(into));
    }

    public void setInto(SQLExprTableSource into) {
        if (into != null) {
            into.setParent(this);
        }
        this.into = into;
    }

    public SQLSelectGroupByClause getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(SQLSelectGroupByClause groupBy) {
        if (groupBy != null) {
            groupBy.setParent(this);
        }
        this.groupBy = groupBy;
    }

    public SQLExpr getWhere() {
        return this.where;
    }

    public void setWhere(SQLExpr where) {
        if (where != null) {
            where.setParent(this);
        }
        this.where = where;
    }

    public void addWhere(SQLExpr condition) {
        if (condition == null) {
            return;
        }
        this.where = this.where == null ? condition : SQLBinaryOpExpr.and(this.where, condition);
    }

    public void whereOr(SQLExpr condition) {
        if (condition == null) {
            return;
        }
        if (this.where == null) {
            this.where = condition;
        } else if (SQLBinaryOpExpr.isOr(this.where) || SQLBinaryOpExpr.isOr(condition)) {
            SQLBinaryOpExprGroup group = new SQLBinaryOpExprGroup(SQLBinaryOperator.BooleanOr, this.dbType);
            group.add(this.where);
            group.add(condition);
            this.where = group;
        } else {
            this.where = SQLBinaryOpExpr.or(this.where, condition);
        }
    }

    public void addHaving(SQLExpr condition) {
        if (condition == null) {
            return;
        }
        if (this.groupBy == null) {
            this.groupBy = new SQLSelectGroupByClause();
        }
        this.groupBy.addHaving(condition);
    }

    public SQLOrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(SQLOrderBy orderBy) {
        if (orderBy != null) {
            orderBy.setParent(this);
        }
        this.orderBy = orderBy;
    }

    public void addOrderBy(SQLOrderBy orderBy) {
        if (this.orderBy == null) {
            this.setOrderBy(orderBy);
        } else {
            if (orderBy == null) {
                return;
            }
            for (SQLSelectOrderByItem item : orderBy.getItems()) {
                this.orderBy.addItem(item.clone());
            }
        }
    }

    public SQLOrderBy getOrderBySiblings() {
        return this.orderBySiblings;
    }

    public void setOrderBySiblings(SQLOrderBy orderBySiblings) {
        if (orderBySiblings != null) {
            orderBySiblings.setParent(this);
        }
        this.orderBySiblings = orderBySiblings;
    }

    public int getDistionOption() {
        return this.distionOption;
    }

    public void setDistionOption(int distionOption) {
        this.distionOption = distionOption;
    }

    public List<SQLSelectItem> getSelectList() {
        return this.selectList;
    }

    public void addSelectItem(SQLSelectItem item) {
        this.selectList.add(item);
        item.setParent(this);
    }

    public void addSelectItem(SQLExpr expr) {
        this.addSelectItem(new SQLSelectItem(expr));
    }

    public void addSelectItem(SQLExpr expr, String alias) {
        this.addSelectItem(new SQLSelectItem(expr, alias));
    }

    public SQLTableSource getFrom() {
        return this.from;
    }

    public void setFrom(SQLTableSource from) {
        if (from != null) {
            from.setParent(this);
        }
        this.from = from;
    }

    public void setFrom(SQLSelectQueryBlock queryBlock, String alias) {
        if (queryBlock == null) {
            this.from = null;
            return;
        }
        this.setFrom(new SQLSelect(queryBlock), alias);
    }

    public void setFrom(SQLSelect select, String alias) {
        if (select == null) {
            this.from = null;
            return;
        }
        SQLSubqueryTableSource from = new SQLSubqueryTableSource(select);
        from.setAlias(alias);
        this.setFrom(from);
    }

    public void setFrom(String tableName, String alias) {
        SQLExprTableSource from = tableName == null || tableName.length() == 0 ? null : new SQLExprTableSource(new SQLIdentifierExpr(tableName), alias);
        this.setFrom(from);
    }

    public boolean isParenthesized() {
        return this.parenthesized;
    }

    public void setParenthesized(boolean parenthesized) {
        this.parenthesized = parenthesized;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public void setForUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
    }

    public boolean isNoWait() {
        return this.noWait;
    }

    public void setNoWait(boolean noWait) {
        this.noWait = noWait;
    }

    public SQLExpr getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(SQLExpr waitTime) {
        if (waitTime != null) {
            waitTime.setParent(this);
        }
        this.waitTime = waitTime;
    }

    public SQLLimit getLimit() {
        return this.limit;
    }

    public void setLimit(SQLLimit limit) {
        if (limit != null) {
            limit.setParent(this);
        }
        this.limit = limit;
    }

    public void mergeLimit(SQLLimit limit) {
        if (this.limit == null) {
            this.limit = limit.clone();
            return;
        }
        this.limit.merge(limit);
    }

    public SQLExpr getFirst() {
        if (this.limit == null) {
            return null;
        }
        return this.limit.getRowCount();
    }

    public void setFirst(SQLExpr first) {
        if (this.limit == null) {
            this.limit = new SQLLimit();
        }
        this.limit.setRowCount(first);
    }

    public SQLExpr getOffset() {
        if (this.limit == null) {
            return null;
        }
        return this.limit.getOffset();
    }

    public void setOffset(SQLExpr offset) {
        if (this.limit == null) {
            this.limit = new SQLLimit();
        }
        this.limit.setOffset(offset);
    }

    public boolean isPrior() {
        return this.prior;
    }

    public void setPrior(boolean prior) {
        this.prior = prior;
    }

    public SQLExpr getStartWith() {
        return this.startWith;
    }

    public void setStartWith(SQLExpr startWith) {
        if (startWith != null) {
            startWith.setParent(this);
        }
        this.startWith = startWith;
    }

    public SQLExpr getConnectBy() {
        return this.connectBy;
    }

    public void setConnectBy(SQLExpr connectBy) {
        if (connectBy != null) {
            connectBy.setParent(this);
        }
        this.connectBy = connectBy;
    }

    public boolean isNoCycle() {
        return this.noCycle;
    }

    public void setNoCycle(boolean noCycle) {
        this.noCycle = noCycle;
    }

    public List<SQLExpr> getDistributeBy() {
        return this.distributeBy;
    }

    public List<SQLSelectOrderByItem> getSortBy() {
        return this.sortBy;
    }

    public void addSortBy(SQLSelectOrderByItem item) {
        if (this.sortBy == null) {
            this.sortBy = new ArrayList<SQLSelectOrderByItem>();
        }
        if (item != null) {
            item.setParent(this);
        }
        this.sortBy.add(item);
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.selectList);
            this.acceptChild(visitor, this.from);
            this.acceptChild(visitor, this.into);
            this.acceptChild(visitor, this.where);
            this.acceptChild(visitor, this.startWith);
            this.acceptChild(visitor, this.connectBy);
            this.acceptChild(visitor, this.groupBy);
            this.acceptChild(visitor, this.orderBy);
            this.acceptChild(visitor, this.waitTime);
            this.acceptChild(visitor, this.limit);
        }
        visitor.endVisit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLSelectQueryBlock that = (SQLSelectQueryBlock)o;
        if (this.bracket != that.bracket) {
            return false;
        }
        if (this.distionOption != that.distionOption) {
            return false;
        }
        if (this.prior != that.prior) {
            return false;
        }
        if (this.noCycle != that.noCycle) {
            return false;
        }
        if (this.parenthesized != that.parenthesized) {
            return false;
        }
        if (this.forUpdate != that.forUpdate) {
            return false;
        }
        if (this.noWait != that.noWait) {
            return false;
        }
        if (this.cachedSelectListHash != that.cachedSelectListHash) {
            return false;
        }
        if (this.selectList != null ? !this.selectList.equals(that.selectList) : that.selectList != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.into != null ? !this.into.equals(that.into) : that.into != null) {
            return false;
        }
        if (this.where != null ? !this.where.equals(that.where) : that.where != null) {
            return false;
        }
        if (this.startWith != null ? !this.startWith.equals(that.startWith) : that.startWith != null) {
            return false;
        }
        if (this.connectBy != null ? !this.connectBy.equals(that.connectBy) : that.connectBy != null) {
            return false;
        }
        if (this.orderBySiblings != null ? !this.orderBySiblings.equals(that.orderBySiblings) : that.orderBySiblings != null) {
            return false;
        }
        if (this.groupBy != null ? !this.groupBy.equals(that.groupBy) : that.groupBy != null) {
            return false;
        }
        if (this.orderBy != null ? !this.orderBy.equals(that.orderBy) : that.orderBy != null) {
            return false;
        }
        if (this.waitTime != null ? !this.waitTime.equals(that.waitTime) : that.waitTime != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) {
            return false;
        }
        if (this.forUpdateOf != null ? !this.forUpdateOf.equals(that.forUpdateOf) : that.forUpdateOf != null) {
            return false;
        }
        if (this.distributeBy != null ? !this.distributeBy.equals(that.distributeBy) : that.distributeBy != null) {
            return false;
        }
        if (this.sortBy != null ? !this.sortBy.equals(that.sortBy) : that.sortBy != null) {
            return false;
        }
        if (this.cachedSelectList != null ? !this.cachedSelectList.equals(that.cachedSelectList) : that.cachedSelectList != null) {
            return false;
        }
        return this.dbType == that.dbType;
    }

    public int hashCode() {
        int result = this.bracket ? 1 : 0;
        result = 31 * result + this.distionOption;
        result = 31 * result + (this.selectList != null ? this.selectList.hashCode() : 0);
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        result = 31 * result + (this.into != null ? this.into.hashCode() : 0);
        result = 31 * result + (this.where != null ? this.where.hashCode() : 0);
        result = 31 * result + (this.startWith != null ? this.startWith.hashCode() : 0);
        result = 31 * result + (this.connectBy != null ? this.connectBy.hashCode() : 0);
        result = 31 * result + (this.prior ? 1 : 0);
        result = 31 * result + (this.noCycle ? 1 : 0);
        result = 31 * result + (this.orderBySiblings != null ? this.orderBySiblings.hashCode() : 0);
        result = 31 * result + (this.groupBy != null ? this.groupBy.hashCode() : 0);
        result = 31 * result + (this.orderBy != null ? this.orderBy.hashCode() : 0);
        result = 31 * result + (this.parenthesized ? 1 : 0);
        result = 31 * result + (this.forUpdate ? 1 : 0);
        result = 31 * result + (this.noWait ? 1 : 0);
        result = 31 * result + (this.waitTime != null ? this.waitTime.hashCode() : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.forUpdateOf != null ? this.forUpdateOf.hashCode() : 0);
        result = 31 * result + (this.distributeBy != null ? this.distributeBy.hashCode() : 0);
        result = 31 * result + (this.sortBy != null ? this.sortBy.hashCode() : 0);
        result = 31 * result + (this.cachedSelectList != null ? this.cachedSelectList.hashCode() : 0);
        result = 31 * result + (int)(this.cachedSelectListHash ^ this.cachedSelectListHash >>> 32);
        result = 31 * result + (this.dbType != null ? this.dbType.hashCode() : 0);
        return result;
    }

    public boolean equalsForMergeJoin(SQLSelectQueryBlock that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.into != null || this.limit != null || this.groupBy != null) {
            return false;
        }
        if (this.bracket != that.bracket) {
            return false;
        }
        if (this.distionOption != that.distionOption) {
            return false;
        }
        if (this.prior != that.prior) {
            return false;
        }
        if (this.noCycle != that.noCycle) {
            return false;
        }
        if (this.parenthesized != that.parenthesized) {
            return false;
        }
        if (this.forUpdate != that.forUpdate) {
            return false;
        }
        if (this.noWait != that.noWait) {
            return false;
        }
        if (this.cachedSelectListHash != that.cachedSelectListHash) {
            return false;
        }
        if (this.selectList != null ? !this.selectList.equals(that.selectList) : that.selectList != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.into != null ? !this.into.equals(that.into) : that.into != null) {
            return false;
        }
        if (this.startWith != null ? !this.startWith.equals(that.startWith) : that.startWith != null) {
            return false;
        }
        if (this.connectBy != null ? !this.connectBy.equals(that.connectBy) : that.connectBy != null) {
            return false;
        }
        if (this.orderBySiblings != null ? !this.orderBySiblings.equals(that.orderBySiblings) : that.orderBySiblings != null) {
            return false;
        }
        if (this.groupBy != null ? !this.groupBy.equals(that.groupBy) : that.groupBy != null) {
            return false;
        }
        if (this.orderBy != null ? !this.orderBy.equals(that.orderBy) : that.orderBy != null) {
            return false;
        }
        if (this.waitTime != null ? !this.waitTime.equals(that.waitTime) : that.waitTime != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) {
            return false;
        }
        if (this.forUpdateOf != null ? !this.forUpdateOf.equals(that.forUpdateOf) : that.forUpdateOf != null) {
            return false;
        }
        if (this.distributeBy != null ? !this.distributeBy.equals(that.distributeBy) : that.distributeBy != null) {
            return false;
        }
        if (this.sortBy != null ? !this.sortBy.equals(that.sortBy) : that.sortBy != null) {
            return false;
        }
        if (this.cachedSelectList != null ? !this.cachedSelectList.equals(that.cachedSelectList) : that.cachedSelectList != null) {
            return false;
        }
        return this.dbType == that.dbType;
    }

    @Override
    public SQLSelectQueryBlock clone() {
        SQLSelectQueryBlock x = new SQLSelectQueryBlock(this.dbType);
        this.cloneTo(x);
        return x;
    }

    public List<SQLExpr> getForUpdateOf() {
        if (this.forUpdateOf == null) {
            this.forUpdateOf = new ArrayList<SQLExpr>(1);
        }
        return this.forUpdateOf;
    }

    public int getForUpdateOfSize() {
        if (this.forUpdateOf == null) {
            return 0;
        }
        return this.forUpdateOf.size();
    }

    public void cloneSelectListTo(SQLSelectQueryBlock x) {
        x.distionOption = this.distionOption;
        for (SQLSelectItem item : this.selectList) {
            SQLSelectItem item2 = item.clone();
            item2.setParent(x);
            x.selectList.add(item2);
        }
    }

    public void cloneTo(SQLSelectQueryBlock x) {
        x.distionOption = this.distionOption;
        if (x.selectList.size() > 0) {
            x.selectList.clear();
        }
        if (this.hints != null) {
            for (SQLCommentHint hint : this.hints) {
                SQLCommentHint hint1 = hint.clone();
                hint1.setParent(x);
                x.getHints().add(hint1);
            }
        }
        for (SQLSelectItem item : this.selectList) {
            x.addSelectItem(item.clone());
        }
        if (this.from != null) {
            x.setFrom(this.from.clone());
        }
        if (this.into != null) {
            x.setInto(this.into.clone());
        }
        if (this.where != null) {
            x.setWhere(this.where.clone());
        }
        if (this.startWith != null) {
            x.setStartWith(this.startWith.clone());
        }
        if (this.connectBy != null) {
            x.setConnectBy(this.connectBy.clone());
        }
        x.prior = this.prior;
        x.noCycle = this.noCycle;
        if (this.orderBySiblings != null) {
            x.setOrderBySiblings(this.orderBySiblings.clone());
        }
        if (this.groupBy != null) {
            x.setGroupBy(this.groupBy.clone());
        }
        if (this.orderBy != null) {
            x.setOrderBy(this.orderBy.clone());
        }
        x.parenthesized = this.parenthesized;
        x.forUpdate = this.forUpdate;
        x.noWait = this.noWait;
        if (this.waitTime != null) {
            x.setWaitTime(this.waitTime.clone());
        }
        if (this.limit != null) {
            x.setLimit(this.limit.clone());
        }
    }

    @Override
    public boolean isBracket() {
        return this.bracket;
    }

    @Override
    public void setBracket(boolean bracket) {
        this.bracket = bracket;
    }

    public SQLTableSource findTableSource(String alias) {
        if (this.from == null) {
            return null;
        }
        return this.from.findTableSource(alias);
    }

    public SQLTableSource findTableSourceWithColumn(String column) {
        if (this.from == null) {
            return null;
        }
        return this.from.findTableSourceWithColumn(column);
    }

    public SQLTableSource findTableSourceWithColumn(long columnHash) {
        SQLSelectItem selectItem;
        if (this.from == null) {
            return null;
        }
        SQLTableSource tableSource = this.from.findTableSourceWithColumn(columnHash);
        if (tableSource == null && this.from instanceof SQLExprTableSource && (selectItem = this.findSelectItem(columnHash)) != null && selectItem.getExpr() instanceof SQLName && ((SQLName)selectItem.getExpr()).nameHashCode64() == columnHash) {
            tableSource = this.from;
        }
        return tableSource;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (this.where == expr) {
            this.setWhere(target);
            return true;
        }
        return false;
    }

    public SQLSelectItem findSelectItem(String ident) {
        if (ident == null) {
            return null;
        }
        long hash = FnvHash.hashCode64(ident);
        return this.findSelectItem(hash);
    }

    public SQLSelectItem findSelectItem(long identHash) {
        for (SQLSelectItem item : this.selectList) {
            if (!item.match(identHash)) continue;
            return item;
        }
        return null;
    }

    public boolean selectItemHasAllColumn() {
        return this.selectItemHasAllColumn(true);
    }

    public boolean selectItemHasAllColumn(boolean recursive) {
        for (SQLSelectItem item : this.selectList) {
            SQLSelect subSelect;
            SQLSelectQueryBlock queryBlock;
            SQLExpr expr = item.getExpr();
            boolean allColumn = expr instanceof SQLAllColumnExpr || expr instanceof SQLPropertyExpr && ((SQLPropertyExpr)expr).getName().equals("*");
            if (!allColumn) continue;
            if (recursive && this.from instanceof SQLSubqueryTableSource && (queryBlock = (subSelect = ((SQLSubqueryTableSource)this.from).select).getQueryBlock()) != null) {
                return queryBlock.selectItemHasAllColumn();
            }
            return true;
        }
        return false;
    }

    public SQLSelectItem findAllColumnSelectItem() {
        SQLSelectItem allColumnItem = null;
        for (SQLSelectItem item : this.selectList) {
            boolean allColumn;
            SQLExpr expr = item.getExpr();
            boolean bl = allColumn = expr instanceof SQLAllColumnExpr || expr instanceof SQLPropertyExpr && ((SQLPropertyExpr)expr).getName().equals("*");
            if (allColumnItem != null) {
                return null;
            }
            allColumnItem = item;
        }
        return allColumnItem;
    }

    public SQLColumnDefinition findColumn(String columnName) {
        if (this.from == null) {
            return null;
        }
        long hash = FnvHash.hashCode64(columnName);
        return this.from.findColumn(hash);
    }

    public void addCondition(String conditionSql) {
        if (conditionSql == null || conditionSql.length() == 0) {
            return;
        }
        SQLExpr condition = SQLUtils.toSQLExpr(conditionSql, this.dbType);
        this.addCondition(condition);
    }

    public void addCondition(SQLExpr expr) {
        if (expr == null) {
            return;
        }
        this.setWhere(SQLBinaryOpExpr.and(this.where, expr));
    }

    public boolean removeCondition(String conditionSql) {
        if (conditionSql == null || conditionSql.length() == 0) {
            return false;
        }
        SQLExpr condition = SQLUtils.toSQLExpr(conditionSql, this.dbType);
        return this.removeCondition(condition);
    }

    public boolean removeCondition(SQLExpr condition) {
        SQLBinaryOpExpr binaryOpWhere;
        SQLBinaryOperator operator;
        if (condition == null) {
            return false;
        }
        if (this.where instanceof SQLBinaryOpExprGroup) {
            SQLBinaryOpExprGroup group = (SQLBinaryOpExprGroup)this.where;
            int removedCount = 0;
            List<SQLExpr> items = group.getItems();
            for (int i = items.size() - 1; i >= 0; --i) {
                if (!items.get(i).equals(condition)) continue;
                items.remove(i);
                ++removedCount;
            }
            if (items.size() == 0) {
                this.where = null;
            }
            return removedCount > 0;
        }
        if (this.where instanceof SQLBinaryOpExpr && ((operator = (binaryOpWhere = (SQLBinaryOpExpr)this.where).getOperator()) == SQLBinaryOperator.BooleanAnd || operator == SQLBinaryOperator.BooleanOr)) {
            List<SQLExpr> items = SQLBinaryOpExpr.split(binaryOpWhere);
            int removedCount = 0;
            for (int i = items.size() - 1; i >= 0; --i) {
                SQLExpr item = items.get(i);
                if (!item.equals(condition) || !SQLUtils.replaceInParent(item, null)) continue;
                ++removedCount;
            }
            return removedCount > 0;
        }
        if (condition.equals(this.where)) {
            this.where = null;
            return true;
        }
        return false;
    }

    public void limit(int rowCount, int offset) {
        SQLLimit limit = new SQLLimit();
        limit.setRowCount(new SQLIntegerExpr(rowCount));
        if (offset > 0) {
            limit.setOffset(new SQLIntegerExpr(offset));
        }
        this.setLimit(limit);
    }

    public String getCachedSelectList() {
        return this.cachedSelectList;
    }

    public void setCachedSelectList(String cachedSelectList, long cachedSelectListHash) {
        this.cachedSelectList = cachedSelectList;
        this.cachedSelectListHash = cachedSelectListHash;
    }

    public long getCachedSelectListHash() {
        return this.cachedSelectListHash;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    public List<SQLCommentHint> getHintsDirect() {
        return this.hints;
    }

    public List<SQLCommentHint> getHints() {
        if (this.hints == null) {
            this.hints = new ArrayList<SQLCommentHint>(2);
        }
        return this.hints;
    }

    public void setHints(List<SQLCommentHint> hints) {
        this.hints = hints;
    }

    public int getHintsSize() {
        if (this.hints == null) {
            return 0;
        }
        return this.hints.size();
    }
}

