/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.statement;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObjectImpl;
import com.alibaba.fastsql.sql.ast.SQLReplaceable;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;

public class SQLUpdateSetItem
extends SQLObjectImpl
implements SQLReplaceable {
    private SQLExpr column;
    private SQLExpr value;

    public SQLExpr getColumn() {
        return this.column;
    }

    public void setColumn(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.column = x;
    }

    public SQLExpr getValue() {
        return this.value;
    }

    public void setValue(SQLExpr value) {
        if (value != null) {
            value.setParent(this);
        }
        this.value = value;
    }

    @Override
    public void output(StringBuffer buf) {
        this.column.output(buf);
        buf.append(" = ");
        this.value.output(buf);
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.column);
            this.acceptChild(visitor, this.value);
        }
        visitor.endVisit(this);
    }

    public boolean columnMatch(String column) {
        if (this.column instanceof SQLIdentifierExpr) {
            return ((SQLIdentifierExpr)this.column).nameEquals(column);
        }
        if (this.column instanceof SQLPropertyExpr) {
            ((SQLPropertyExpr)this.column).nameEquals(column);
        }
        return false;
    }

    public boolean columnMatch(long columnHash) {
        if (this.column instanceof SQLName) {
            return ((SQLName)this.column).nameHashCode64() == columnHash;
        }
        return false;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (expr == this.column) {
            this.column = target;
            return true;
        }
        if (expr == this.value) {
            this.value = target;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLUpdateSetItem that = (SQLUpdateSetItem)o;
        if (this.column != null ? !this.column.equals(that.column) : that.column != null) {
            return false;
        }
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        int result = this.column != null ? this.column.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

