/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.statement;

import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObjectImpl;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSourceImpl;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLWithSubqueryClause
extends SQLObjectImpl {
    private Boolean recursive;
    private final List<Entry> entries = new ArrayList<Entry>();

    @Override
    public SQLWithSubqueryClause clone() {
        SQLWithSubqueryClause x = new SQLWithSubqueryClause();
        x.recursive = this.recursive;
        for (Entry entry : this.entries) {
            Entry entry2 = entry.clone();
            entry2.setParent(x);
            x.entries.add(entry2);
        }
        return x;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void addEntry(Entry entrie) {
        if (entrie != null) {
            entrie.setParent(this);
        }
        this.entries.add(entrie);
    }

    public Boolean getRecursive() {
        return this.recursive;
    }

    public void setRecursive(Boolean recursive) {
        this.recursive = recursive;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.entries);
        }
        visitor.endVisit(this);
    }

    public Entry findEntry(long alias_hash) {
        if (alias_hash == 0L) {
            return null;
        }
        for (Entry entry : this.entries) {
            if (entry.aliasHashCode64() != alias_hash) continue;
            return entry;
        }
        return null;
    }

    public static class Entry
    extends SQLTableSourceImpl {
        protected final List<SQLName> columns = new ArrayList<SQLName>();
        protected SQLSelect subQuery;
        protected SQLStatement returningStatement;

        public void cloneTo(Entry x) {
            for (SQLName column : this.columns) {
                SQLName column2 = column.clone();
                column2.setParent(x);
                x.columns.add(column2);
            }
            if (this.subQuery != null) {
                x.setSubQuery(this.subQuery.clone());
            }
            if (this.returningStatement != null) {
                this.setReturningStatement(this.returningStatement.clone());
            }
        }

        @Override
        public Entry clone() {
            Entry x = new Entry();
            this.cloneTo(x);
            return x;
        }

        @Override
        protected void accept0(SQLASTVisitor visitor) {
            if (visitor.visit(this)) {
                this.acceptChild(visitor, this.columns);
                this.acceptChild(visitor, this.subQuery);
                this.acceptChild(visitor, this.returningStatement);
            }
            visitor.endVisit(this);
        }

        public SQLSelect getSubQuery() {
            return this.subQuery;
        }

        public void setSubQuery(SQLSelect subQuery) {
            if (subQuery != null) {
                subQuery.setParent(this);
            }
            this.subQuery = subQuery;
        }

        public SQLStatement getReturningStatement() {
            return this.returningStatement;
        }

        public void setReturningStatement(SQLStatement returningStatement) {
            if (returningStatement != null) {
                returningStatement.setParent(this);
            }
            this.returningStatement = returningStatement;
        }

        public List<SQLName> getColumns() {
            return this.columns;
        }

        @Override
        public SQLTableSource findTableSourceWithColumn(long columnNameHash) {
            SQLSelectQueryBlock queryBlock;
            for (SQLName column : this.columns) {
                if (column.nameHashCode64() != columnNameHash) continue;
                return this;
            }
            if (this.subQuery != null && (queryBlock = this.subQuery.getFirstQueryBlock()) != null && queryBlock.findSelectItem(columnNameHash) != null) {
                return this;
            }
            return null;
        }
    }
}

