/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.ads.visitor;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLShowColumnsStatement;
import com.alibaba.fastsql.sql.dialect.ads.visitor.AdsVisitor;
import com.alibaba.fastsql.sql.dialect.mysql.ast.MySqlPrimaryKey;
import com.alibaba.fastsql.sql.dialect.mysql.ast.statement.MySqlCreateTableStatement;
import com.alibaba.fastsql.sql.visitor.SQLASTOutputVisitor;
import java.util.Map;

public class AdsOutputVisitor
extends SQLASTOutputVisitor
implements AdsVisitor {
    public AdsOutputVisitor(Appendable appender) {
        super(appender);
    }

    public AdsOutputVisitor(Appendable appender, DbType dbType) {
        super(appender, dbType);
    }

    public AdsOutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
    }

    @Override
    public boolean visit(SQLCreateTableStatement x) {
        this.printCreateTable(x, true);
        Map<String, SQLObject> options = x.getTableOptions();
        if (options.size() > 0) {
            this.println();
            this.print0(this.ucase ? "OPTIONS (" : "options (");
            int i = 0;
            for (Map.Entry<String, SQLObject> option : x.getTableOptions().entrySet()) {
                if (i > 0) {
                    this.print0(", ");
                }
                String key = option.getKey();
                this.print0(key);
                this.print0(" = ");
                option.getValue().accept(this);
                ++i;
            }
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddColumn x) {
        this.print0(this.ucase ? "ADD COLUMN " : "add column ");
        this.printAndAccept(x.getColumns(), ", ");
        return false;
    }

    @Override
    public boolean visit(SQLShowColumnsStatement x) {
        this.print0(this.ucase ? "SHOW COLUMNS" : "show columns");
        if (x.getTable() != null) {
            this.print0(this.ucase ? " IN " : " in ");
            x.getTable().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlPrimaryKey x) {
    }

    @Override
    public void endVisit(MySqlCreateTableStatement x) {
    }
}

