/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.h2.parser;

import com.alibaba.fastsql.sql.dialect.h2.parser.H2Lexer;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.SQLExprParser;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.util.FnvHash;
import java.util.Arrays;

public class H2ExprParser
extends SQLExprParser {
    private static final String[] AGGREGATE_FUNCTIONS;
    private static final long[] AGGREGATE_FUNCTIONS_CODES;

    public H2ExprParser(String sql) {
        this(new H2Lexer(sql));
        this.lexer.nextToken();
    }

    public H2ExprParser(String sql, SQLParserFeature ... features) {
        this(new H2Lexer(sql, features));
        this.lexer.nextToken();
    }

    public H2ExprParser(Lexer lexer) {
        super(lexer);
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;
    }

    static {
        String[] strings = new String[]{"AVG", "COUNT", "MAX", "MIN", "STDDEV", "SUM", "ROW_NUMBER", "ROWNUMBER"};
        AGGREGATE_FUNCTIONS_CODES = FnvHash.fnv1a_64_lower(strings, true);
        AGGREGATE_FUNCTIONS = new String[AGGREGATE_FUNCTIONS_CODES.length];
        for (String str : strings) {
            long hash = FnvHash.fnv1a_64_lower(str);
            int index = Arrays.binarySearch(AGGREGATE_FUNCTIONS_CODES, hash);
            H2ExprParser.AGGREGATE_FUNCTIONS[index] = str;
        }
    }
}

