/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.hive.parser;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLShowTablesStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLShowViewsStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveInsert;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveMultiInsertStatement;
import com.alibaba.fastsql.sql.dialect.hive.parser.HiveCreateTableParser;
import com.alibaba.fastsql.sql.dialect.hive.parser.HiveExprParser;
import com.alibaba.fastsql.sql.dialect.hive.parser.HiveSelectParser;
import com.alibaba.fastsql.sql.dialect.hive.stmt.HiveCreateFunctionStatement;
import com.alibaba.fastsql.sql.dialect.hive.stmt.HiveLoadDataStatement;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLCreateTableParser;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.SQLStatementParser;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;
import java.util.List;

public class HiveStatementParser
extends SQLStatementParser {
    public HiveStatementParser(String sql) {
        super(new HiveExprParser(sql));
        this.dbType = DbType.hive;
    }

    public HiveStatementParser(String sql, SQLParserFeature ... features) {
        super(new HiveExprParser(sql, features));
        this.dbType = DbType.hive;
    }

    public HiveStatementParser(Lexer lexer) {
        super(new HiveExprParser(lexer));
        this.dbType = DbType.hive;
    }

    @Override
    public HiveSelectParser createSQLSelectParser() {
        return new HiveSelectParser(this.exprParser, this.selectListCache);
    }

    @Override
    public SQLCreateTableParser getSQLCreateTableParser() {
        return new HiveCreateTableParser(this.exprParser);
    }

    @Override
    public SQLStatement parseInsert() {
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            HiveMultiInsertStatement stmt = new HiveMultiInsertStatement();
            if (this.lexer.token() == Token.IDENTIFIER) {
                SQLName tableName = this.exprParser.name();
                SQLExprTableSource from = new SQLExprTableSource(tableName);
                stmt.setFrom(from);
                if (this.lexer.token() == Token.IDENTIFIER) {
                    from.setAlias(this.lexer.stringVal());
                    this.lexer.nextToken();
                }
            } else {
                this.accept(Token.LPAREN);
                HiveSelectParser selectParser = this.createSQLSelectParser();
                SQLSelect select = selectParser.select();
                this.accept(Token.RPAREN);
                String alias = this.lexer.stringVal();
                this.accept(Token.IDENTIFIER);
                SQLSubqueryTableSource from = new SQLSubqueryTableSource(select, alias);
                stmt.setFrom(from);
            }
            do {
                HiveInsert insert = this.parseHiveInsert();
                stmt.addItem(insert);
            } while (this.lexer.token() == Token.INSERT);
            return stmt;
        }
        return this.parseHiveInsertStmt();
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        if (this.lexer.token() == Token.FROM) {
            SQLStatement stmt = this.parseInsert();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LOAD)) {
            this.lexer.nextToken();
            this.acceptIdentifier("DATA");
            HiveLoadDataStatement stmt = new HiveLoadDataStatement();
            if (this.lexer.identifierEquals(FnvHash.Constants.LOCAL)) {
                this.lexer.nextToken();
                stmt.setLocal(true);
            }
            this.acceptIdentifier("INPATH");
            SQLExpr inpath = this.exprParser.expr();
            stmt.setInpath(inpath);
            if (this.lexer.token() == Token.OVERWRITE) {
                this.lexer.nextToken();
                stmt.setOverwrite(true);
            }
            this.accept(Token.INTO);
            this.accept(Token.TABLE);
            SQLExpr table = this.exprParser.expr();
            stmt.setInto(table);
            if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                this.exprParser.exprList(stmt.getPartition(), stmt);
                this.accept(Token.RPAREN);
            }
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SHOW)) {
            Lexer.SavePoint savePoint = this.lexer.mark();
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.VIEWS)) {
                this.lexer.nextToken();
                SQLShowViewsStatement stmt = new SQLShowViewsStatement();
                if (this.lexer.token() == Token.IN) {
                    this.lexer.nextToken();
                    SQLName db = this.exprParser.name();
                    stmt.setDatabase(db);
                }
                if (this.lexer.token() == Token.LIKE) {
                    this.lexer.nextToken();
                    SQLExpr pattern = this.exprParser.expr();
                    stmt.setLike(pattern);
                }
                statementList.add(stmt);
                return true;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.TABLES)) {
                this.lexer.reset(savePoint);
                SQLShowTablesStatement stmt = this.parseShowTables();
                statementList.add(stmt);
                return true;
            }
            throw new ParserException("TODO " + this.lexer.info());
        }
        return false;
    }

    @Override
    public SQLCreateTableStatement parseCreateTable() {
        HiveCreateTableParser parser = new HiveCreateTableParser(this.exprParser);
        return parser.parseCreateTable();
    }

    @Override
    public SQLStatement parseCreateFunction() {
        this.accept(Token.CREATE);
        this.accept(Token.FUNCTION);
        HiveCreateFunctionStatement stmt = new HiveCreateFunctionStatement();
        stmt.setDbType(this.dbType);
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            SQLExpr className = this.exprParser.expr();
            stmt.setClassName(className);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LOCATION)) {
            this.lexer.nextToken();
            SQLExpr location = this.exprParser.primary();
            stmt.setLocationn(location);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SYMBOL)) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            SQLExpr symbol = this.exprParser.primary();
            stmt.setSymbol(symbol);
        }
        return stmt;
    }
}

