/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.hive.visitor;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableExchangePartition;
import com.alibaba.fastsql.sql.ast.statement.SQLAssignItem;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLExternalRecordFormat;
import com.alibaba.fastsql.sql.ast.statement.SQLInsertStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLMergeStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveInsert;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveInsertStatement;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveMultiInsertStatement;
import com.alibaba.fastsql.sql.dialect.hive.stmt.HiveCreateFunctionStatement;
import com.alibaba.fastsql.sql.dialect.hive.stmt.HiveCreateTableStatement;
import com.alibaba.fastsql.sql.dialect.hive.stmt.HiveLoadDataStatement;
import com.alibaba.fastsql.sql.dialect.hive.visitor.HiveASTVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTOutputVisitor;
import java.util.List;
import java.util.Map;

public class HiveOutputVisitor
extends SQLASTOutputVisitor
implements HiveASTVisitor {
    public HiveOutputVisitor(Appendable appender) {
        super(appender, DbType.hive);
    }

    public HiveOutputVisitor(Appendable appender, DbType dbType) {
        super(appender, dbType);
    }

    public HiveOutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
        this.dbType = DbType.hive;
    }

    @Override
    public boolean visit(HiveCreateTableStatement x) {
        this.printCreateTable(x, true);
        return false;
    }

    protected void printCreateTable(HiveCreateTableStatement x, boolean printSelect) {
        SQLExprTableSource like;
        Map<String, SQLObject> tableOptions;
        SQLExpr location;
        SQLName storedAs;
        int buckets;
        List<SQLSelectOrderByItem> sortedBy;
        Map<String, SQLObject> serdeProperties;
        SQLExternalRecordFormat format;
        List<SQLExpr> skewedBy;
        List<SQLName> clusteredBy;
        int partitionSize;
        SQLExpr comment;
        this.print0(this.ucase ? "CREATE " : "create ");
        SQLCreateTableStatement.Type tableType = x.getType();
        if (SQLCreateTableStatement.Type.GLOBAL_TEMPORARY.equals((Object)tableType)) {
            this.print0(this.ucase ? "GLOBAL TEMPORARY " : "global temporary ");
        } else if (SQLCreateTableStatement.Type.LOCAL_TEMPORARY.equals((Object)tableType)) {
            this.print0(this.ucase ? "LOCAL TEMPORARY " : "local temporary ");
        }
        this.print0(this.ucase ? "TABLE " : "table ");
        if (x.isIfNotExiists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        this.printTableSourceExpr(x.getName());
        this.printTableElements(x.getTableElementList());
        SQLExprTableSource inherits = x.getInherits();
        if (inherits != null) {
            this.print0(this.ucase ? " INHERITS (" : " inherits (");
            inherits.accept(this);
            this.print(')');
        }
        if ((comment = x.getComment()) != null) {
            this.println();
            this.print0(this.ucase ? "COMMENT " : "comment ");
            comment.accept(this);
        }
        if ((partitionSize = x.getPartitionColumns().size()) > 0) {
            this.println();
            this.print0(this.ucase ? "PARTITIONED BY (" : "partitioned by (");
            ++this.indentCount;
            this.println();
            for (int i = 0; i < partitionSize; ++i) {
                SQLColumnDefinition column = x.getPartitionColumns().get(i);
                column.accept(this);
                if (i != partitionSize - 1) {
                    this.print(',');
                }
                if (this.isPrettyFormat() && column.hasAfterComment()) {
                    this.print(' ');
                    this.printlnComment(column.getAfterCommentsDirect());
                }
                if (i == partitionSize - 1) continue;
                this.println();
            }
            --this.indentCount;
            this.println();
            this.print(')');
        }
        if ((clusteredBy = x.getClusteredBy()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "CLUSTERED BY (" : "clustered by (");
            this.printAndAccept(clusteredBy, ",");
            this.print(')');
        }
        if ((skewedBy = x.getSkewedBy()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "SKEWED BY (" : "skewed by (");
            this.printAndAccept(skewedBy, ",");
            this.print(')');
            List<SQLExpr> skewedByOn = x.getSkewedByOn();
            if (skewedByOn.size() > 0) {
                this.print0(this.ucase ? " ON (" : " on (");
                this.printAndAccept(skewedByOn, ",");
                this.print(')');
            }
        }
        if ((format = x.getRowFormat()) != null) {
            this.println();
            this.print0(this.ucase ? "ROW FORMAT DELIMITED " : "row format delimited ");
            this.visit(format);
        }
        if ((serdeProperties = x.getSerdeProperties()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "SERDEPROPERTIES (" : "serdeproperties (");
            int i = 0;
            for (Map.Entry<String, SQLObject> option : serdeProperties.entrySet()) {
                this.print0(option.getKey());
                this.print0(" = ");
                option.getValue().accept(this);
                ++i;
            }
            this.print(')');
        }
        if ((sortedBy = x.getSortedBy()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "SORTED BY (" : "sorted by (");
            this.printAndAccept(sortedBy, ", ");
            this.print(')');
        }
        if ((buckets = x.getBuckets()) > 0) {
            this.println();
            this.print0(this.ucase ? "INTO " : "into ");
            this.print(buckets);
            this.print0(this.ucase ? " BUCKETS" : " buckets");
        }
        if ((storedAs = x.getStoredAs()) != null) {
            this.println();
            this.print0(this.ucase ? "STORED AS " : "stored as ");
            this.printExpr(storedAs);
        }
        if ((location = x.getLocation()) != null) {
            this.println();
            this.print0(this.ucase ? "LOCATION " : "location ");
            this.printExpr(location);
        }
        if ((tableOptions = x.getTableOptions()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "TBLPROPERTIES (" : "tblproperties (");
            int i = 0;
            for (Map.Entry<String, SQLObject> option : tableOptions.entrySet()) {
                this.print0(option.getKey());
                this.print0(" = ");
                option.getValue().accept(this);
                ++i;
            }
            this.print(')');
        }
        SQLSelect select = x.getSelect();
        if (printSelect && select != null) {
            this.println();
            this.print0(this.ucase ? "AS" : "as");
            this.println();
            this.visit(select);
        }
        if ((like = x.getLike()) != null) {
            this.println();
            this.print0(this.ucase ? "LIKE " : "like ");
            like.accept(this);
        }
    }

    @Override
    public void endVisit(HiveCreateTableStatement x) {
    }

    @Override
    public boolean visit(HiveInsert x) {
        if (x.hasBeforeComment()) {
            this.printlnComments(x.getBeforeCommentsDirect());
        }
        if (x.isOverwrite()) {
            this.print0(this.ucase ? "INSERT OVERWRITE TABLE " : "insert overwrite table ");
        } else {
            this.print0(this.ucase ? "INSERT INTO TABLE " : "insert into table ");
        }
        x.getTableSource().accept(this);
        int partitions = x.getPartitions().size();
        if (partitions > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            for (int i = 0; i < partitions; ++i) {
                if (i != 0) {
                    this.print0(", ");
                }
                SQLAssignItem assign = x.getPartitions().get(i);
                assign.getTarget().accept(this);
                if (assign.getValue() == null) continue;
                this.print('=');
                assign.getValue().accept(this);
            }
            this.print(')');
        }
        this.println();
        SQLSelect select = x.getQuery();
        List<SQLInsertStatement.ValuesClause> valuesList = x.getValuesList();
        if (select != null) {
            select.accept(this);
        } else if (!valuesList.isEmpty()) {
            this.print0(this.ucase ? "VALUES " : "values ");
            this.printAndAccept(valuesList, ", ");
        }
        return false;
    }

    @Override
    public void endVisit(HiveInsert x) {
    }

    @Override
    public boolean visit(SQLExternalRecordFormat x) {
        SQLExpr serde;
        SQLExpr nullDefinedAs;
        SQLExpr linesTerminatedBy;
        SQLExpr mapKeysTerminatedBy;
        SQLExpr collectionItemsTerminatedBy;
        SQLExpr escapedBy;
        SQLExpr terminatedBy;
        ++this.indentCount;
        if (x.getDelimitedBy() != null) {
            this.println();
            this.print0(this.ucase ? "LINES TERMINATED BY " : "lines terminated by ");
            x.getDelimitedBy().accept(this);
        }
        if ((terminatedBy = x.getTerminatedBy()) != null) {
            this.println();
            this.print0(this.ucase ? "FIELDS TERMINATED BY " : "fields terminated by ");
            terminatedBy.accept(this);
        }
        if ((escapedBy = x.getEscapedBy()) != null) {
            this.println();
            this.print0(this.ucase ? "ESCAPED BY " : "escaped by ");
            escapedBy.accept(this);
        }
        if ((collectionItemsTerminatedBy = x.getCollectionItemsTerminatedBy()) != null) {
            this.println();
            this.print0(this.ucase ? "COLLECTION ITEMS TERMINATED BY " : "collection items terminated by ");
            collectionItemsTerminatedBy.accept(this);
        }
        if ((mapKeysTerminatedBy = x.getMapKeysTerminatedBy()) != null) {
            this.println();
            this.print0(this.ucase ? "MAP KEYS TERMINATED BY " : "map keys terminated by ");
            mapKeysTerminatedBy.accept(this);
        }
        if ((linesTerminatedBy = x.getLinesTerminatedBy()) != null) {
            this.println();
            this.print0(this.ucase ? "LINES TERMINATED BY " : "lines terminated by ");
            linesTerminatedBy.accept(this);
        }
        if ((nullDefinedAs = x.getNullDefinedAs()) != null) {
            this.println();
            this.print0(this.ucase ? "NULL DEFINED AS " : "null defined as ");
            nullDefinedAs.accept(this);
        }
        if ((serde = x.getSerde()) != null) {
            this.println();
            this.print0(this.ucase ? "SERDE " : "serde ");
            serde.accept(this);
        }
        --this.indentCount;
        return false;
    }

    @Override
    public void endVisit(HiveMultiInsertStatement x) {
    }

    @Override
    public boolean visit(HiveMultiInsertStatement x) {
        SQLTableSource from = x.getFrom();
        if (x.getFrom() != null) {
            if (from instanceof SQLSubqueryTableSource) {
                SQLSelect select = ((SQLSubqueryTableSource)from).getSelect();
                this.print0(this.ucase ? "FROM (" : "from (");
                ++this.indentCount;
                this.println();
                select.accept(this);
                --this.indentCount;
                this.println();
                this.print0(") ");
                this.print0(x.getFrom().getAlias());
            } else {
                this.print0(this.ucase ? "FROM " : "from ");
                from.accept(this);
            }
            this.println();
        }
        for (int i = 0; i < x.getItems().size(); ++i) {
            HiveInsert insert = x.getItems().get(i);
            if (i != 0) {
                this.println();
            }
            insert.accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(HiveInsertStatement x) {
    }

    @Override
    public boolean visit(HiveInsertStatement x) {
        if (x.hasBeforeComment()) {
            this.printlnComments(x.getBeforeCommentsDirect());
        }
        if (x.isOverwrite()) {
            this.print0(this.ucase ? "INSERT OVERWRITE TABLE " : "insert overwrite table ");
        } else {
            this.print0(this.ucase ? "INSERT INTO TABLE " : "insert into table ");
        }
        x.getTableSource().accept(this);
        int partitions = x.getPartitions().size();
        if (partitions > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            for (int i = 0; i < partitions; ++i) {
                if (i != 0) {
                    this.print0(", ");
                }
                SQLAssignItem assign = x.getPartitions().get(i);
                assign.getTarget().accept(this);
                if (assign.getValue() == null) continue;
                this.print('=');
                assign.getValue().accept(this);
            }
            this.print(')');
        }
        this.println();
        SQLSelect select = x.getQuery();
        List<SQLInsertStatement.ValuesClause> valuesList = x.getValuesList();
        if (select != null) {
            select.accept(this);
        } else if (!valuesList.isEmpty()) {
            this.print0(this.ucase ? "VALUES " : "values ");
            this.printAndAccept(valuesList, ", ");
        }
        return false;
    }

    @Override
    public boolean visit(SQLMergeStatement.MergeUpdateClause x) {
        this.print0(this.ucase ? "WHEN MATCHED " : "when matched ");
        ++this.indentCount;
        ++this.indentCount;
        SQLExpr where = x.getWhere();
        if (SQLBinaryOpExpr.isAnd(where)) {
            this.println();
        } else {
            this.print(' ');
        }
        this.print0(this.ucase ? "AND " : "and ");
        this.printExpr(x.getWhere());
        --this.indentCount;
        this.println();
        this.print0(this.ucase ? "UPDATE SET " : "update set ");
        this.printAndAccept(x.getItems(), ", ");
        --this.indentCount;
        SQLExpr deleteWhere = x.getDeleteWhere();
        if (deleteWhere != null) {
            this.println();
            this.print0(this.ucase ? "WHEN MATCHED AND " : "when matched and ");
            this.printExpr(deleteWhere);
            this.print0(this.ucase ? " DELETE" : " delete");
        }
        return false;
    }

    @Override
    public boolean visit(HiveCreateFunctionStatement x) {
        SQLExpr symbol;
        this.print0(this.ucase ? "CREATE FUNCTION " : "create function ");
        x.getName().accept(this);
        SQLExpr className = x.getClassName();
        if (className != null) {
            this.print0(this.ucase ? " AS " : " as ");
            className.accept(this);
        }
        ++this.indentCount;
        SQLExpr location = x.getLocationn();
        if (location != null) {
            this.println();
            this.print0(this.ucase ? "LOCATION " : "location ");
            location.accept(this);
        }
        if ((symbol = x.getSymbol()) != null) {
            this.println();
            this.print0(this.ucase ? "SYMBOL = " : "symbol = ");
            symbol.accept(this);
        }
        --this.indentCount;
        return false;
    }

    @Override
    public void endVisit(HiveCreateFunctionStatement x) {
    }

    @Override
    public boolean visit(HiveLoadDataStatement x) {
        this.print0(this.ucase ? "LOAD DATA " : "load data ");
        if (x.isLocal()) {
            this.print0(this.ucase ? "LOCAL " : "local ");
        }
        this.print0(this.ucase ? "INPATH " : "inpath ");
        x.getInpath().accept(this);
        if (x.isOverwrite()) {
            this.print0(this.ucase ? " OVERWRITE INTO " : " overwrite into ");
        } else {
            this.print0(" into ");
        }
        x.getInto().accept(this);
        if (x.getPartition().size() > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            this.printAndAccept(x.getPartition(), ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    public void endVisit(HiveLoadDataStatement x) {
    }

    @Override
    public boolean visit(SQLAlterTableExchangePartition x) {
        this.print0(this.ucase ? "EXCHANGE PARTITION (" : "exchange partition (");
        this.printAndAccept(x.getPartitions(), ", ");
        this.print0(this.ucase ? ") WITH TABLE " : ") with table ");
        x.getTable().accept(this);
        Boolean validation = x.getValidation();
        if (validation != null) {
            if (validation.booleanValue()) {
                this.print0(this.ucase ? " WITH VALIDATION" : " with validation");
            } else {
                this.print0(this.ucase ? " WITHOUT VALIDATION" : " without validation");
            }
        }
        return false;
    }
}

