/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.mysql.ast.statement;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLCommentHint;
import com.alibaba.fastsql.sql.ast.SQLLimit;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLOrderBy;
import com.alibaba.fastsql.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.fastsql.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.fastsql.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MySqlDeleteStatement
extends SQLDeleteStatement {
    private boolean lowPriority = false;
    private boolean quick = false;
    private boolean ignore = false;
    private SQLOrderBy orderBy;
    private SQLLimit limit;
    private boolean forceAllPartitions = false;
    private SQLName forcePartition;
    private List<SQLCommentHint> hints;

    public MySqlDeleteStatement() {
        super(DbType.mysql);
    }

    @Override
    public MySqlDeleteStatement clone() {
        MySqlDeleteStatement x = new MySqlDeleteStatement();
        this.cloneTo(x);
        x.lowPriority = this.lowPriority;
        x.quick = this.quick;
        x.ignore = this.ignore;
        if (this.using != null) {
            x.setUsing(this.using.clone());
        }
        if (this.orderBy != null) {
            x.setOrderBy(this.orderBy.clone());
        }
        if (this.limit != null) {
            x.setLimit(this.limit.clone());
        }
        return x;
    }

    public List<SQLCommentHint> getHints() {
        if (this.hints == null) {
            this.hints = new ArrayList<SQLCommentHint>();
        }
        return this.hints;
    }

    public int getHintsSize() {
        if (this.hints == null) {
            return 0;
        }
        return this.hints.size();
    }

    public boolean isLowPriority() {
        return this.lowPriority;
    }

    public void setLowPriority(boolean lowPriority) {
        this.lowPriority = lowPriority;
    }

    public boolean isQuick() {
        return this.quick;
    }

    public void setQuick(boolean quick) {
        this.quick = quick;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public SQLOrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(SQLOrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public SQLLimit getLimit() {
        return this.limit;
    }

    public void setLimit(SQLLimit limit) {
        if (limit != null) {
            limit.setParent(this);
        }
        this.limit = limit;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (!(visitor instanceof MySqlASTVisitor)) {
            throw new IllegalArgumentException("not support visitor type : " + visitor.getClass().getName());
        }
        this.accept0((MySqlASTVisitor)visitor);
    }

    @Override
    public void output(StringBuffer buf) {
        new MySqlOutputVisitor(buf).visit(this);
    }

    protected void accept0(MySqlASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.getTableSource());
            this.acceptChild((SQLASTVisitor)visitor, this.getWhere());
            this.acceptChild((SQLASTVisitor)visitor, this.getFrom());
            this.acceptChild((SQLASTVisitor)visitor, this.getUsing());
            this.acceptChild((SQLASTVisitor)visitor, this.orderBy);
            this.acceptChild((SQLASTVisitor)visitor, this.limit);
        }
        visitor.endVisit(this);
    }

    public boolean isForceAllPartitions() {
        return this.forceAllPartitions;
    }

    public void setForceAllPartitions(boolean forceAllPartitions) {
        this.forceAllPartitions = forceAllPartitions;
    }

    public SQLName getForcePartition() {
        return this.forcePartition;
    }

    public void setForcePartition(SQLName x) {
        if (x != null) {
            x.setParent(this);
        }
        this.forcePartition = x;
    }
}

