/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.mysql.ast.statement;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.mysql.ast.MySqlObject;
import com.alibaba.fastsql.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MySqlSelectQueryBlock
extends SQLSelectQueryBlock
implements MySqlObject {
    private boolean hignPriority;
    private boolean straightJoin;
    private boolean smallResult;
    private boolean bigResult;
    private boolean bufferResult;
    private Boolean cache;
    private boolean calcFoundRows;
    private SQLName procedureName;
    private List<SQLExpr> procedureArgumentList;
    private boolean lockInShareMode;
    private SQLName forcePartition;

    public MySqlSelectQueryBlock() {
        this.dbType = DbType.mysql;
    }

    @Override
    public MySqlSelectQueryBlock clone() {
        MySqlSelectQueryBlock x = new MySqlSelectQueryBlock();
        this.cloneTo(x);
        x.hignPriority = this.hignPriority;
        x.straightJoin = this.straightJoin;
        x.smallResult = this.smallResult;
        x.bigResult = this.bigResult;
        x.bufferResult = this.bufferResult;
        x.cache = this.cache;
        x.calcFoundRows = this.calcFoundRows;
        if (this.procedureName != null) {
            x.setProcedureName(this.procedureName.clone());
        }
        if (this.procedureArgumentList != null) {
            for (SQLExpr arg : this.procedureArgumentList) {
                SQLExpr arg_cloned = arg.clone();
                arg_cloned.setParent(this);
                x.procedureArgumentList.add(arg_cloned);
            }
        }
        x.lockInShareMode = this.lockInShareMode;
        return x;
    }

    @Override
    public int getHintsSize() {
        if (this.hints == null) {
            return 0;
        }
        return this.hints.size();
    }

    public boolean isLockInShareMode() {
        return this.lockInShareMode;
    }

    public void setLockInShareMode(boolean lockInShareMode) {
        this.lockInShareMode = lockInShareMode;
    }

    public SQLName getProcedureName() {
        return this.procedureName;
    }

    public void setProcedureName(SQLName procedureName) {
        this.procedureName = procedureName;
    }

    public List<SQLExpr> getProcedureArgumentList() {
        if (this.procedureArgumentList == null) {
            this.procedureArgumentList = new ArrayList<SQLExpr>(2);
        }
        return this.procedureArgumentList;
    }

    public boolean isHignPriority() {
        return this.hignPriority;
    }

    public void setHignPriority(boolean hignPriority) {
        this.hignPriority = hignPriority;
    }

    public boolean isStraightJoin() {
        return this.straightJoin;
    }

    public void setStraightJoin(boolean straightJoin) {
        this.straightJoin = straightJoin;
    }

    public boolean isSmallResult() {
        return this.smallResult;
    }

    public void setSmallResult(boolean smallResult) {
        this.smallResult = smallResult;
    }

    public boolean isBigResult() {
        return this.bigResult;
    }

    public void setBigResult(boolean bigResult) {
        this.bigResult = bigResult;
    }

    public boolean isBufferResult() {
        return this.bufferResult;
    }

    public void setBufferResult(boolean bufferResult) {
        this.bufferResult = bufferResult;
    }

    public Boolean getCache() {
        return this.cache;
    }

    public void setCache(Boolean cache) {
        this.cache = cache;
    }

    public boolean isCalcFoundRows() {
        return this.calcFoundRows;
    }

    public void setCalcFoundRows(boolean calcFoundRows) {
        this.calcFoundRows = calcFoundRows;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MySqlSelectQueryBlock that = (MySqlSelectQueryBlock)o;
        if (this.hignPriority != that.hignPriority) {
            return false;
        }
        if (this.straightJoin != that.straightJoin) {
            return false;
        }
        if (this.smallResult != that.smallResult) {
            return false;
        }
        if (this.bigResult != that.bigResult) {
            return false;
        }
        if (this.bufferResult != that.bufferResult) {
            return false;
        }
        if (this.calcFoundRows != that.calcFoundRows) {
            return false;
        }
        if (this.lockInShareMode != that.lockInShareMode) {
            return false;
        }
        if (this.cache != null ? !this.cache.equals(that.cache) : that.cache != null) {
            return false;
        }
        if (this.procedureName != null ? !this.procedureName.equals(that.procedureName) : that.procedureName != null) {
            return false;
        }
        if (this.procedureArgumentList != null ? !this.procedureArgumentList.equals(that.procedureArgumentList) : that.procedureArgumentList != null) {
            return false;
        }
        if (this.hints != null ? !this.hints.equals(that.hints) : that.hints != null) {
            return false;
        }
        return !(this.forcePartition != null ? !this.forcePartition.equals(that.forcePartition) : that.forcePartition != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.hignPriority ? 1 : 0);
        result = 31 * result + (this.straightJoin ? 1 : 0);
        result = 31 * result + (this.smallResult ? 1 : 0);
        result = 31 * result + (this.bigResult ? 1 : 0);
        result = 31 * result + (this.bufferResult ? 1 : 0);
        result = 31 * result + (this.cache != null ? this.cache.hashCode() : 0);
        result = 31 * result + (this.calcFoundRows ? 1 : 0);
        result = 31 * result + (this.procedureName != null ? this.procedureName.hashCode() : 0);
        result = 31 * result + (this.procedureArgumentList != null ? this.procedureArgumentList.hashCode() : 0);
        result = 31 * result + (this.lockInShareMode ? 1 : 0);
        result = 31 * result + (this.hints != null ? this.hints.hashCode() : 0);
        result = 31 * result + (this.forcePartition != null ? this.forcePartition.hashCode() : 0);
        return result;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor instanceof MySqlASTVisitor) {
            this.accept0((MySqlASTVisitor)visitor);
            return;
        }
        super.accept0(visitor);
    }

    @Override
    public void accept0(MySqlASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.selectList);
            this.acceptChild((SQLASTVisitor)visitor, this.from);
            this.acceptChild((SQLASTVisitor)visitor, this.where);
            this.acceptChild((SQLASTVisitor)visitor, this.groupBy);
            this.acceptChild((SQLASTVisitor)visitor, this.orderBy);
            this.acceptChild((SQLASTVisitor)visitor, this.limit);
            this.acceptChild((SQLASTVisitor)visitor, this.procedureName);
            this.acceptChild((SQLASTVisitor)visitor, this.procedureArgumentList);
            this.acceptChild((SQLASTVisitor)visitor, this.into);
        }
        visitor.endVisit(this);
    }

    public SQLName getForcePartition() {
        return this.forcePartition;
    }

    public void setForcePartition(SQLName x) {
        if (x != null) {
            x.setParent(this);
        }
        this.forcePartition = x;
    }

    @Override
    public String toString() {
        return SQLUtils.toMySqlString(this);
    }
}

