/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.mysql.ast.statement;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.fastsql.sql.ast.statement.SQLTableElement;
import com.alibaba.fastsql.sql.dialect.mysql.ast.MySqlObjectImpl;
import com.alibaba.fastsql.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MySqlTableIndex
extends MySqlObjectImpl
implements SQLTableElement {
    private SQLName name;
    private String indexType;
    private List<SQLSelectOrderByItem> columns = new ArrayList<SQLSelectOrderByItem>();

    public SQLName getName() {
        return this.name;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    public void setName(SQLName name) {
        this.name = name;
    }

    public List<SQLSelectOrderByItem> getColumns() {
        return this.columns;
    }

    public void addColumn(SQLSelectOrderByItem column) {
        if (column != null) {
            column.setParent(this);
        }
        this.columns.add(column);
    }

    @Override
    public void accept0(MySqlASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.name);
            this.acceptChild((SQLASTVisitor)visitor, this.columns);
        }
        visitor.endVisit(this);
    }

    @Override
    public MySqlTableIndex clone() {
        MySqlTableIndex x = new MySqlTableIndex();
        if (this.name != null) {
            x.setName(this.name.clone());
        }
        x.indexType = this.indexType;
        for (SQLSelectOrderByItem column : this.columns) {
            SQLSelectOrderByItem c2 = column.clone();
            c2.setParent(x);
            x.columns.add(c2);
        }
        return x;
    }

    public boolean applyColumnRename(SQLName columnName, SQLName to) {
        for (SQLSelectOrderByItem orderByItem : this.columns) {
            SQLExpr expr = orderByItem.getExpr();
            if (!(expr instanceof SQLName) || !SQLUtils.nameEquals((SQLName)expr, columnName)) continue;
            orderByItem.setExpr(to.clone());
            return true;
        }
        return false;
    }

    public boolean applyDropColumn(SQLName columnName) {
        for (int i = this.columns.size() - 1; i >= 0; --i) {
            SQLExpr expr = this.columns.get(i).getExpr();
            if (expr instanceof SQLName && SQLUtils.nameEquals((SQLName)expr, columnName)) {
                this.columns.remove(i);
                return true;
            }
            if (!(expr instanceof SQLMethodInvokeExpr) || !SQLUtils.nameEquals(((SQLMethodInvokeExpr)expr).getMethodName(), columnName.getSimpleName())) continue;
            this.columns.remove(i);
            return true;
        }
        return false;
    }
}

