/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.mysql.ast.statement;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLLimit;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.fastsql.sql.dialect.mysql.ast.statement.MySqlStatement;
import com.alibaba.fastsql.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;

public class MySqlUpdateStatement
extends SQLUpdateStatement
implements MySqlStatement {
    private SQLLimit limit;
    private boolean lowPriority = false;
    private boolean ignore = false;
    private boolean commitOnSuccess = false;
    private boolean rollBackOnFail = false;
    private boolean queryOnPk = false;
    private SQLExpr targetAffectRow;
    private boolean forceAllPartitions = false;
    private SQLName forcePartition;

    public MySqlUpdateStatement() {
        super(DbType.mysql);
    }

    public SQLLimit getLimit() {
        return this.limit;
    }

    public void setLimit(SQLLimit limit) {
        if (limit != null) {
            limit.setParent(this);
        }
        this.limit = limit;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (!(visitor instanceof MySqlASTVisitor)) {
            throw new IllegalArgumentException("not support visitor type : " + visitor.getClass().getName());
        }
        this.accept0((MySqlASTVisitor)visitor);
    }

    @Override
    public void accept0(MySqlASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.tableSource);
            this.acceptChild((SQLASTVisitor)visitor, this.items);
            this.acceptChild((SQLASTVisitor)visitor, this.where);
            this.acceptChild((SQLASTVisitor)visitor, this.orderBy);
            this.acceptChild((SQLASTVisitor)visitor, this.limit);
        }
        visitor.endVisit(this);
    }

    public boolean isLowPriority() {
        return this.lowPriority;
    }

    public void setLowPriority(boolean lowPriority) {
        this.lowPriority = lowPriority;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public boolean isCommitOnSuccess() {
        return this.commitOnSuccess;
    }

    public void setCommitOnSuccess(boolean commitOnSuccess) {
        this.commitOnSuccess = commitOnSuccess;
    }

    public boolean isRollBackOnFail() {
        return this.rollBackOnFail;
    }

    public void setRollBackOnFail(boolean rollBackOnFail) {
        this.rollBackOnFail = rollBackOnFail;
    }

    public boolean isQueryOnPk() {
        return this.queryOnPk;
    }

    public void setQueryOnPk(boolean queryOnPk) {
        this.queryOnPk = queryOnPk;
    }

    public SQLExpr getTargetAffectRow() {
        return this.targetAffectRow;
    }

    public void setTargetAffectRow(SQLExpr targetAffectRow) {
        if (targetAffectRow != null) {
            targetAffectRow.setParent(this);
        }
        this.targetAffectRow = targetAffectRow;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MySqlUpdateStatement that = (MySqlUpdateStatement)o;
        if (this.lowPriority != that.lowPriority) {
            return false;
        }
        if (this.ignore != that.ignore) {
            return false;
        }
        if (this.commitOnSuccess != that.commitOnSuccess) {
            return false;
        }
        if (this.rollBackOnFail != that.rollBackOnFail) {
            return false;
        }
        if (this.queryOnPk != that.queryOnPk) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) {
            return false;
        }
        return this.targetAffectRow != null ? this.targetAffectRow.equals(that.targetAffectRow) : that.targetAffectRow == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.lowPriority ? 1 : 0);
        result = 31 * result + (this.ignore ? 1 : 0);
        result = 31 * result + (this.commitOnSuccess ? 1 : 0);
        result = 31 * result + (this.rollBackOnFail ? 1 : 0);
        result = 31 * result + (this.queryOnPk ? 1 : 0);
        result = 31 * result + (this.targetAffectRow != null ? this.targetAffectRow.hashCode() : 0);
        return result;
    }

    public SQLName getForcePartition() {
        return this.forcePartition;
    }

    public void setForcePartition(SQLName x) {
        if (x != null) {
            x.setParent(this);
        }
        this.forcePartition = x;
    }

    public boolean isForceAllPartitions() {
        return this.forceAllPartitions;
    }

    public void setForceAllPartitions(boolean forceAllPartitions) {
        this.forceAllPartitions = forceAllPartitions;
    }
}

