/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.mysql.parser;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.fastsql.sql.dialect.mysql.ast.MySqlForceIndexHint;
import com.alibaba.fastsql.sql.dialect.mysql.ast.MySqlIgnoreIndexHint;
import com.alibaba.fastsql.sql.dialect.mysql.ast.MySqlIndexHint;
import com.alibaba.fastsql.sql.dialect.mysql.ast.MySqlIndexHintImpl;
import com.alibaba.fastsql.sql.dialect.mysql.ast.MySqlUseIndexHint;
import com.alibaba.fastsql.sql.dialect.mysql.ast.expr.MySqlOutFileExpr;
import com.alibaba.fastsql.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.fastsql.sql.dialect.mysql.ast.statement.MySqlUpdateTableSource;
import com.alibaba.fastsql.sql.dialect.mysql.parser.MySqlExprParser;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLExprParser;
import com.alibaba.fastsql.sql.parser.SQLSelectListCache;
import com.alibaba.fastsql.sql.parser.SQLSelectParser;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;
import java.util.List;

public class MySqlSelectParser
extends SQLSelectParser {
    protected boolean returningFlag = false;
    protected MySqlUpdateStatement updateStmt;

    public MySqlSelectParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    public MySqlSelectParser(SQLExprParser exprParser, SQLSelectListCache selectListCache) {
        super(exprParser, selectListCache);
    }

    public MySqlSelectParser(String sql) {
        this(new MySqlExprParser(sql));
    }

    @Override
    public void parseFrom(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token() != Token.FROM) {
            for (SQLSelectItem item : queryBlock.getSelectList()) {
                SQLExpr expr = item.getExpr();
                if (!(expr instanceof SQLAggregateExpr)) continue;
                throw new ParserException("syntax error, expect " + (Object)((Object)Token.FROM) + ", actual " + (Object)((Object)this.lexer.token()) + ", " + this.lexer.info());
            }
            return;
        }
        this.lexer.nextTokenIdent();
        if (this.lexer.token() == Token.UPDATE) {
            this.updateStmt = this.parseUpdateStatment();
            List<SQLExpr> returnning = this.updateStmt.getReturning();
            for (SQLSelectItem item : queryBlock.getSelectList()) {
                SQLExpr itemExpr = item.getExpr();
                itemExpr.setParent(this.updateStmt);
                returnning.add(itemExpr);
            }
            this.returningFlag = true;
            return;
        }
        queryBlock.setFrom(this.parseTableSource());
    }

    @Override
    public SQLSelectQuery query(SQLObject parent, boolean acceptUnion) {
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            SQLSelectQuery select = this.query();
            select.setBracket(true);
            this.accept(Token.RPAREN);
            return this.queryRest(select, acceptUnion);
        }
        MySqlSelectQueryBlock queryBlock = new MySqlSelectQueryBlock();
        queryBlock.setParent(parent);
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            queryBlock.addBeforeComment(this.lexer.readAndResetComments());
        }
        if (this.lexer.token() == Token.SELECT && this.selectListCache != null) {
            this.selectListCache.match(this.lexer, queryBlock);
        }
        if (this.lexer.token() == Token.SELECT) {
            this.lexer.nextToken();
            while (this.lexer.token() == Token.HINT) {
                this.exprParser.parseHints(queryBlock.getHints());
            }
            Token token = this.lexer.token();
            if (token == Token.DISTINCT) {
                queryBlock.setDistionOption(2);
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals(FnvHash.Constants.DISTINCTROW)) {
                queryBlock.setDistionOption(4);
                this.lexer.nextToken();
            } else if (token == Token.ALL) {
                queryBlock.setDistionOption(1);
                this.lexer.nextToken();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.HIGH_PRIORITY)) {
                queryBlock.setHignPriority(true);
                this.lexer.nextToken();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.STRAIGHT_JOIN)) {
                queryBlock.setStraightJoin(true);
                this.lexer.nextToken();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.SQL_SMALL_RESULT)) {
                queryBlock.setSmallResult(true);
                this.lexer.nextToken();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.SQL_BIG_RESULT)) {
                queryBlock.setBigResult(true);
                this.lexer.nextToken();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.SQL_BUFFER_RESULT)) {
                queryBlock.setBufferResult(true);
                this.lexer.nextToken();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.SQL_CACHE)) {
                queryBlock.setCache(true);
                this.lexer.nextToken();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.SQL_NO_CACHE)) {
                queryBlock.setCache(false);
                this.lexer.nextToken();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.SQL_CALC_FOUND_ROWS)) {
                queryBlock.setCalcFoundRows(true);
                this.lexer.nextToken();
            }
            this.parseSelectList(queryBlock);
            if (this.lexer.identifierEquals(FnvHash.Constants.FORCE)) {
                this.lexer.nextToken();
                this.accept(Token.PARTITION);
                SQLName partition = this.exprParser.name();
                queryBlock.setForcePartition(partition);
            }
            this.parseInto(queryBlock);
        }
        this.parseFrom(queryBlock);
        this.parseWhere(queryBlock);
        this.parseHierachical(queryBlock);
        this.parseGroupBy(queryBlock);
        queryBlock.setOrderBy(this.exprParser.parseOrderBy());
        if (this.lexer.token() == Token.LIMIT) {
            queryBlock.setLimit(this.exprParser.parseLimit());
        }
        if (this.lexer.token() == Token.PROCEDURE) {
            this.lexer.nextToken();
            throw new ParserException("TODO. " + this.lexer.info());
        }
        this.parseInto(queryBlock);
        if (this.lexer.token() == Token.FOR) {
            this.lexer.nextToken();
            this.accept(Token.UPDATE);
            queryBlock.setForUpdate(true);
            if (this.lexer.identifierEquals(FnvHash.Constants.NO_WAIT) || this.lexer.identifierEquals(FnvHash.Constants.NOWAIT)) {
                this.lexer.nextToken();
                queryBlock.setNoWait(true);
            } else if (this.lexer.identifierEquals(FnvHash.Constants.WAIT)) {
                this.lexer.nextToken();
                SQLExpr waitTime = this.exprParser.primary();
                queryBlock.setWaitTime(waitTime);
            }
        }
        if (this.lexer.token() == Token.LOCK) {
            this.lexer.nextToken();
            this.accept(Token.IN);
            this.acceptIdentifier("SHARE");
            this.acceptIdentifier("MODE");
            queryBlock.setLockInShareMode(true);
        }
        return this.queryRest(queryBlock, acceptUnion);
    }

    @Override
    public SQLTableSource parseTableSource() {
        if (this.lexer.token() == Token.LPAREN) {
            SQLTableSource tableSource;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.SELECT || this.lexer.token() == Token.WITH) {
                SQLSelect select = this.select();
                this.accept(Token.RPAREN);
                SQLSelectQuery query = this.queryRest(select.getQuery(), true);
                if (query instanceof SQLUnionQuery && select.getWithSubQuery() == null) {
                    select.getQuery().setBracket(true);
                    tableSource = new SQLUnionQueryTableSource((SQLUnionQuery)query);
                } else {
                    tableSource = new SQLSubqueryTableSource(select);
                }
            } else if (this.lexer.token() == Token.LPAREN) {
                tableSource = this.parseTableSource();
                this.accept(Token.RPAREN);
            } else {
                tableSource = this.parseTableSource();
                this.accept(Token.RPAREN);
            }
            return this.parseTableSourceRest(tableSource);
        }
        if (this.lexer.token() == Token.UPDATE) {
            MySqlUpdateTableSource tableSource = new MySqlUpdateTableSource(this.parseUpdateStatment());
            return this.parseTableSourceRest(tableSource);
        }
        if (this.lexer.token() == Token.SELECT) {
            throw new ParserException("TODO. " + this.lexer.info());
        }
        SQLExprTableSource tableReference = new SQLExprTableSource();
        this.parseTableSourceQueryTableExpr(tableReference);
        SQLTableSource tableSrc = this.parseTableSourceRest(tableReference);
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            tableSrc.addAfterComment(this.lexer.readAndResetComments());
        }
        return tableSrc;
    }

    protected MySqlUpdateStatement parseUpdateStatment() {
        MySqlUpdateStatement update = new MySqlUpdateStatement();
        this.lexer.nextToken();
        if (this.lexer.identifierEquals(FnvHash.Constants.LOW_PRIORITY)) {
            this.lexer.nextToken();
            update.setLowPriority(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.IGNORE)) {
            this.lexer.nextToken();
            update.setIgnore(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.COMMIT_ON_SUCCESS)) {
            this.lexer.nextToken();
            update.setCommitOnSuccess(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.ROLLBACK_ON_FAIL)) {
            this.lexer.nextToken();
            update.setRollBackOnFail(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.QUEUE_ON_PK)) {
            this.lexer.nextToken();
            update.setQueryOnPk(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TARGET_AFFECT_ROW)) {
            this.lexer.nextToken();
            SQLExpr targetAffectRow = this.exprParser.expr();
            update.setTargetAffectRow(targetAffectRow);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.FORCE)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.ALL) {
                this.lexer.nextToken();
                this.acceptIdentifier("PARTITIONS");
                update.setForceAllPartitions(true);
            } else if (this.lexer.identifierEquals(FnvHash.Constants.PARTITIONS)) {
                this.lexer.nextToken();
                update.setForceAllPartitions(true);
            } else if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                SQLName partition = this.exprParser.name();
                update.setForcePartition(partition);
            } else {
                throw new ParserException("TODO. " + this.lexer.info());
            }
        }
        while (this.lexer.token() == Token.HINT) {
            this.exprParser.parseHints(update.getHints());
        }
        SQLSelectParser selectParser = this.exprParser.createSelectParser();
        SQLTableSource updateTableSource = selectParser.parseTableSource();
        update.setTableSource(updateTableSource);
        this.accept(Token.SET);
        while (true) {
            SQLUpdateSetItem item = this.exprParser.parseUpdateSetItem();
            update.addItem(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            update.setWhere(this.exprParser.expr());
        }
        update.setOrderBy(this.exprParser.parseOrderBy());
        update.setLimit(this.exprParser.parseLimit());
        return update;
    }

    protected void parseInto(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token() == Token.INTO) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("OUTFILE")) {
                this.lexer.nextToken();
                MySqlOutFileExpr outFile = new MySqlOutFileExpr();
                outFile.setFile(this.expr());
                queryBlock.setInto(outFile);
                if (this.lexer.identifierEquals("FIELDS") || this.lexer.identifierEquals("COLUMNS")) {
                    this.lexer.nextToken();
                    if (this.lexer.identifierEquals("TERMINATED")) {
                        this.lexer.nextToken();
                        this.accept(Token.BY);
                    }
                    outFile.setColumnsTerminatedBy(this.expr());
                    if (this.lexer.identifierEquals("OPTIONALLY")) {
                        this.lexer.nextToken();
                        outFile.setColumnsEnclosedOptionally(true);
                    }
                    if (this.lexer.identifierEquals("ENCLOSED")) {
                        this.lexer.nextToken();
                        this.accept(Token.BY);
                        outFile.setColumnsEnclosedBy((SQLLiteralExpr)this.expr());
                    }
                    if (this.lexer.identifierEquals("ESCAPED")) {
                        this.lexer.nextToken();
                        this.accept(Token.BY);
                        outFile.setColumnsEscaped((SQLLiteralExpr)this.expr());
                    }
                }
                if (this.lexer.identifierEquals("LINES")) {
                    this.lexer.nextToken();
                    if (this.lexer.identifierEquals("STARTING")) {
                        this.lexer.nextToken();
                        this.accept(Token.BY);
                        outFile.setLinesStartingBy((SQLLiteralExpr)this.expr());
                    } else {
                        this.lexer.identifierEquals("TERMINATED");
                        this.lexer.nextToken();
                        this.accept(Token.BY);
                        outFile.setLinesTerminatedBy((SQLLiteralExpr)this.expr());
                    }
                }
            } else {
                SQLExpr intoExpr = this.exprParser.name();
                if (this.lexer.token() == Token.COMMA) {
                    SQLListExpr list = new SQLListExpr();
                    list.addItem(intoExpr);
                    while (this.lexer.token() == Token.COMMA) {
                        this.lexer.nextToken();
                        SQLName name = this.exprParser.name();
                        list.addItem(name);
                    }
                    intoExpr = list;
                }
                queryBlock.setInto(intoExpr);
            }
        }
    }

    @Override
    protected SQLTableSource primaryTableSourceRest(SQLTableSource tableSource) {
        MySqlIndexHintImpl hint;
        if (this.lexer.token() == Token.USE) {
            this.lexer.nextToken();
            hint = new MySqlUseIndexHint();
            this.parseIndexHint(hint);
            tableSource.getHints().add(hint);
        }
        if (this.lexer.identifierEquals("IGNORE")) {
            this.lexer.nextToken();
            hint = new MySqlIgnoreIndexHint();
            this.parseIndexHint(hint);
            tableSource.getHints().add(hint);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.FORCE)) {
            this.lexer.nextToken();
            hint = new MySqlForceIndexHint();
            this.parseIndexHint(hint);
            tableSource.getHints().add(hint);
        }
        if (this.lexer.token() == Token.PARTITION) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.exprParser.names(((SQLExprTableSource)tableSource).getPartitions(), tableSource);
            this.accept(Token.RPAREN);
        }
        return tableSource;
    }

    @Override
    protected SQLTableSource parseTableSourceRest(SQLTableSource tableSource) {
        if (this.lexer.identifierEquals(FnvHash.Constants.USING)) {
            return tableSource;
        }
        this.parseIndexHintList(tableSource);
        if (this.lexer.token() == Token.PARTITION) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.exprParser.names(((SQLExprTableSource)tableSource).getPartitions(), tableSource);
            this.accept(Token.RPAREN);
        }
        return super.parseTableSourceRest(tableSource);
    }

    private void parseIndexHintList(SQLTableSource tableSource) {
        MySqlIndexHintImpl hint;
        if (this.lexer.token() == Token.USE) {
            this.lexer.nextToken();
            hint = new MySqlUseIndexHint();
            this.parseIndexHint(hint);
            tableSource.getHints().add(hint);
            this.parseIndexHintList(tableSource);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.IGNORE)) {
            this.lexer.nextToken();
            hint = new MySqlIgnoreIndexHint();
            this.parseIndexHint(hint);
            tableSource.getHints().add(hint);
            this.parseIndexHintList(tableSource);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.FORCE)) {
            this.lexer.nextToken();
            hint = new MySqlForceIndexHint();
            this.parseIndexHint(hint);
            tableSource.getHints().add(hint);
            this.parseIndexHintList(tableSource);
        }
    }

    private void parseIndexHint(MySqlIndexHintImpl hint) {
        if (this.lexer.token() == Token.INDEX) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.KEY);
        }
        if (this.lexer.token() == Token.FOR) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.JOIN) {
                this.lexer.nextToken();
                hint.setOption(MySqlIndexHint.Option.JOIN);
            } else if (this.lexer.token() == Token.ORDER) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                hint.setOption(MySqlIndexHint.Option.ORDER_BY);
            } else {
                this.accept(Token.GROUP);
                this.accept(Token.BY);
                hint.setOption(MySqlIndexHint.Option.GROUP_BY);
            }
        }
        this.accept(Token.LPAREN);
        if (this.lexer.token() == Token.PRIMARY) {
            this.lexer.nextToken();
            hint.getIndexList().add(new SQLIdentifierExpr("PRIMARY"));
        } else {
            this.exprParser.names(hint.getIndexList());
        }
        this.accept(Token.RPAREN);
    }

    @Override
    public SQLUnionQuery unionRest(SQLUnionQuery union) {
        if (this.lexer.token() == Token.LIMIT) {
            union.setLimit(this.exprParser.parseLimit());
        }
        return super.unionRest(union);
    }

    public MySqlExprParser getExprParser() {
        return (MySqlExprParser)this.exprParser;
    }
}

