/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.mysql.visitor.transform;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLExistsExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.dialect.oracle.visitor.OracleASTVisitorAdapter;
import com.alibaba.fastsql.util.FnvHash;

public class NameResolveVisitor
extends OracleASTVisitorAdapter {
    @Override
    public boolean visit(SQLIdentifierExpr x) {
        String name;
        SQLObject parent = x.getParent();
        if (parent instanceof SQLBinaryOpExpr && x.getResolvedColumn() == null) {
            boolean isJoinCondition;
            SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)parent;
            boolean bl = isJoinCondition = binaryOpExpr.getLeft() instanceof SQLName && binaryOpExpr.getRight() instanceof SQLName;
            if (isJoinCondition) {
                return false;
            }
        }
        if ("ROWNUM".equalsIgnoreCase(name = x.getName())) {
            return false;
        }
        long hash = x.nameHashCode64();
        Object tableSource = null;
        if (hash == FnvHash.Constants.LEVEL || hash == FnvHash.Constants.CONNECT_BY_ISCYCLE || hash == FnvHash.Constants.SYSTIMESTAMP) {
            return false;
        }
        if (parent instanceof SQLPropertyExpr) {
            return false;
        }
        while (parent != null) {
            if (parent instanceof SQLTableSource) {
                return false;
            }
            if (parent instanceof SQLSelectQueryBlock) {
                String alias;
                SQLObject pp;
                SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)parent;
                if (queryBlock.getInto() != null) {
                    return false;
                }
                if (queryBlock.getParent() instanceof SQLSelect && ((pp = queryBlock.getParent().getParent()) instanceof SQLInSubQueryExpr || pp instanceof SQLExistsExpr)) {
                    return false;
                }
                SQLTableSource from = queryBlock.getFrom();
                if ((from instanceof SQLExprTableSource || from instanceof SQLSubqueryTableSource) && (alias = from.getAlias()) != null) {
                    boolean isRowNumColumn = this.isRowNumColumn(x, queryBlock);
                    boolean isAliasColumn = this.isAliasColumn(x, queryBlock);
                    if (!isRowNumColumn && !isAliasColumn) {
                        SQLUtils.replaceInParent(x, new SQLPropertyExpr(alias, name));
                    }
                }
                return false;
            }
            parent = parent.getParent();
        }
        return true;
    }

    @Override
    public boolean visit(SQLPropertyExpr x) {
        String ownerName = x.getOwnernName();
        if (ownerName == null) {
            return super.visit(x);
        }
        for (SQLObject parent = x.getParent(); parent != null; parent = parent.getParent()) {
            SQLSelectQueryBlock queryBlock;
            SQLTableSource tableSource;
            if (!(parent instanceof SQLSelectQueryBlock) || (tableSource = (queryBlock = (SQLSelectQueryBlock)parent).findTableSource(ownerName)) == null) continue;
            String alias = tableSource.computeAlias();
            if (tableSource == null || !ownerName.equalsIgnoreCase(alias) || ownerName.equals(alias)) break;
            x.setOwner(alias);
            break;
        }
        return super.visit(x);
    }

    public boolean isRowNumColumn(SQLExpr x, SQLSelectQueryBlock source) {
        if (x instanceof SQLIdentifierExpr) {
            SQLSelectQueryBlock subQueryBlock;
            SQLSelectItem selectItem;
            SQLIdentifierExpr identifierExpr = (SQLIdentifierExpr)x;
            long nameHashCode64 = identifierExpr.nameHashCode64();
            if (nameHashCode64 == FnvHash.Constants.ROWNUM) {
                return true;
            }
            SQLSelectQueryBlock queryBlock = source;
            if (queryBlock.getFrom() instanceof SQLSubqueryTableSource && ((SQLSubqueryTableSource)queryBlock.getFrom()).getSelect().getQuery() instanceof SQLSelectQueryBlock && (selectItem = (subQueryBlock = ((SQLSubqueryTableSource)queryBlock.getFrom()).getSelect().getQueryBlock()).findSelectItem(nameHashCode64)) != null && this.isRowNumColumn(selectItem.getExpr(), subQueryBlock)) {
                return true;
            }
        }
        return false;
    }

    public boolean isAliasColumn(SQLExpr x, SQLSelectQueryBlock source) {
        if (x instanceof SQLIdentifierExpr) {
            SQLSelectQueryBlock subQueryBlock;
            SQLSelectQueryBlock queryBlock = source;
            SQLIdentifierExpr identifierExpr = (SQLIdentifierExpr)x;
            long nameHashCode64 = identifierExpr.nameHashCode64();
            SQLSelectItem selectItem = queryBlock.findSelectItem(nameHashCode64);
            if (selectItem != null) {
                return true;
            }
            if (queryBlock.getFrom() instanceof SQLSubqueryTableSource && ((SQLSubqueryTableSource)queryBlock.getFrom()).getSelect().getQuery() instanceof SQLSelectQueryBlock && this.isAliasColumn(x, subQueryBlock = ((SQLSubqueryTableSource)queryBlock.getFrom()).getSelect().getQueryBlock())) {
                return true;
            }
        }
        return false;
    }
}

