/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.oracle.ast.stmt;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.dialect.oracle.ast.clause.PartitionExtensionClause;
import com.alibaba.fastsql.sql.dialect.oracle.ast.clause.SampleClause;
import com.alibaba.fastsql.sql.dialect.oracle.ast.stmt.OracleSelectPivotBase;
import com.alibaba.fastsql.sql.dialect.oracle.ast.stmt.OracleSelectTableSource;
import com.alibaba.fastsql.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;

public class OracleSelectTableReference
extends SQLExprTableSource
implements OracleSelectTableSource {
    private boolean only = false;
    protected OracleSelectPivotBase pivot;
    protected PartitionExtensionClause partition;
    protected SampleClause sampleClause;

    public OracleSelectTableReference() {
    }

    public OracleSelectTableReference(SQLExpr expr) {
        this.setExpr(expr);
    }

    public PartitionExtensionClause getPartition() {
        return this.partition;
    }

    public void setPartition(PartitionExtensionClause partition) {
        this.partition = partition;
    }

    public boolean isOnly() {
        return this.only;
    }

    public void setOnly(boolean only) {
        this.only = only;
    }

    public SampleClause getSampleClause() {
        return this.sampleClause;
    }

    public void setSampleClause(SampleClause sampleClause) {
        this.sampleClause = sampleClause;
    }

    @Override
    public OracleSelectPivotBase getPivot() {
        return this.pivot;
    }

    @Override
    public void setPivot(OracleSelectPivotBase pivot) {
        this.pivot = pivot;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor instanceof OracleASTVisitor) {
            this.accept0((OracleASTVisitor)visitor);
        } else {
            super.accept0(visitor);
        }
    }

    protected void accept0(OracleASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.expr);
            this.acceptChild((SQLASTVisitor)visitor, this.partition);
            this.acceptChild((SQLASTVisitor)visitor, this.sampleClause);
            this.acceptChild((SQLASTVisitor)visitor, this.pivot);
        }
        visitor.endVisit(this);
    }

    @Override
    public void output(StringBuffer buf) {
        if (this.only) {
            buf.append("ONLY (");
            this.expr.output(buf);
            buf.append(")");
        } else {
            this.expr.output(buf);
        }
        if (this.pivot != null) {
            buf.append(" ");
            this.pivot.output(buf);
        }
        if (this.alias != null && this.alias.length() != 0) {
            buf.append(this.alias);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OracleSelectTableReference that = (OracleSelectTableReference)o;
        if (this.only != that.only) {
            return false;
        }
        if (this.pivot != null ? !this.pivot.equals(that.pivot) : that.pivot != null) {
            return false;
        }
        if (this.partition != null ? !this.partition.equals(that.partition) : that.partition != null) {
            return false;
        }
        if (this.sampleClause != null ? !this.sampleClause.equals(that.sampleClause) : that.sampleClause != null) {
            return false;
        }
        return this.flashback != null ? this.flashback.equals(that.flashback) : that.flashback == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.only ? 1 : 0);
        result = 31 * result + (this.pivot != null ? this.pivot.hashCode() : 0);
        result = 31 * result + (this.partition != null ? this.partition.hashCode() : 0);
        result = 31 * result + (this.sampleClause != null ? this.sampleClause.hashCode() : 0);
        result = 31 * result + (this.flashback != null ? this.flashback.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return SQLUtils.toOracleString(this);
    }

    @Override
    public OracleSelectTableReference clone() {
        OracleSelectTableReference x = new OracleSelectTableReference();
        this.cloneTo(x);
        x.only = this.only;
        if (this.pivot != null) {
            x.setPivot(this.pivot.clone());
        }
        if (this.partition != null) {
            x.setPartition(this.partition.clone());
        }
        if (this.sampleClause != null) {
            x.setSampleClause(this.sampleClause.clone());
        }
        if (this.flashback != null) {
            this.setFlashback(this.flashback.clone());
        }
        return x;
    }
}

