/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.optimizer.OptimizerFeature;
import com.alibaba.fastsql.sql.optimizer.visitor.CastFloatToReal;
import com.alibaba.fastsql.sql.optimizer.visitor.ConstFolding;
import com.alibaba.fastsql.sql.optimizer.visitor.Constant;
import com.alibaba.fastsql.sql.optimizer.visitor.MergeUnion;
import com.alibaba.fastsql.sql.optimizer.visitor.Ordinal;
import com.alibaba.fastsql.sql.optimizer.visitor.PipesAsConcat;
import com.alibaba.fastsql.sql.optimizer.visitor.PushDown;
import com.alibaba.fastsql.sql.optimizer.visitor.PushDownQueryExpr;
import com.alibaba.fastsql.sql.optimizer.visitor.PushUp;
import com.alibaba.fastsql.sql.optimizer.visitor.TypeInference;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.repository.SchemaRepository;
import com.alibaba.fastsql.sql.repository.SchemaResolveVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class Optimizers {
    private static long DEFAULT_FEATURES;

    public static String optimize(String sql, DbType dbType) {
        return Optimizers.optimize(sql, dbType, new OptimizerFeature[0]);
    }

    public static String optimize(String sql, DbType dbType, OptimizerFeature ... features) {
        return Optimizers.optimize(sql, dbType, null, DEFAULT_FEATURES, features);
    }

    public static String optimize(String sql, DbType dbType, SchemaRepository repository, OptimizerFeature ... features) {
        return Optimizers.optimize(sql, dbType, repository, DEFAULT_FEATURES, features);
    }

    public static String optimize(String sql, DbType dbType, SchemaRepository repository, long defaultFeatures, OptimizerFeature ... features) {
        SQLParserFeature[] parserFeatures = new SQLParserFeature[]{};
        if (features != null) {
            for (OptimizerFeature feature : features) {
                if (feature != OptimizerFeature.PipesAsConcat) continue;
                parserFeatures = new SQLParserFeature[]{SQLParserFeature.PipesAsConcat};
                break;
            }
        }
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType, parserFeatures);
        for (int i = 0; i < stmtList.size(); ++i) {
            SQLStatement stmt = stmtList.get(i);
            if (repository != null) {
                repository.resolve(stmt, new SchemaResolveVisitor.Option[0]);
            }
            Optimizers.optimize(stmt, dbType, repository, defaultFeatures, features);
        }
        return SQLUtils.toSQLString(stmtList, dbType);
    }

    public static void optimize(SQLStatement stmt, DbType dbType) {
        Optimizers.optimize(stmt, dbType, null, new OptimizerFeature[0]);
    }

    public static void optimize(SQLStatement stmt, DbType dbType, SchemaRepository repository, OptimizerFeature ... features) {
        Optimizers.optimize(stmt, dbType, repository, DEFAULT_FEATURES, features);
    }

    public static void optimize(SQLStatement stmt, DbType dbType, SchemaRepository repository, long defaultFeatures, OptimizerFeature ... features) {
        for (OptimizerFeature feature : features) {
            defaultFeatures |= feature.mask;
        }
        List<SQLASTVisitor> visitors = Optimizers.visitors(dbType, repository, defaultFeatures);
        for (int i = 0; i < visitors.size(); ++i) {
            SQLASTVisitor v = visitors.get(i);
            stmt.accept(v);
        }
    }

    private static List<SQLASTVisitor> visitors(DbType dbType, SchemaRepository repository, long features) {
        ArrayList<SQLASTVisitor> visitors = new ArrayList<SQLASTVisitor>();
        if ((features & OptimizerFeature.PipesAsConcat.mask) != 0L) {
            visitors.add(new PipesAsConcat());
        }
        if ((features & OptimizerFeature.ConstFolding.mask) != 0L) {
            visitors.add(new Constant(repository));
            visitors.add(new ConstFolding(dbType));
        }
        if ((features & OptimizerFeature.MergeUnion.mask) != 0L) {
            visitors.add(new MergeUnion());
        }
        if ((features & OptimizerFeature.PushDown.mask) != 0L) {
            visitors.add(new PushDown());
            visitors.add(new PushDownQueryExpr());
        }
        if ((features & OptimizerFeature.PushUp.mask) != 0L) {
            visitors.add(new PushUp());
        }
        if ((features & OptimizerFeature.Ordinal.mask) != 0L) {
            visitors.add(new Ordinal());
        }
        if ((features & OptimizerFeature.CastFloatToReal.mask) != 0L) {
            visitors.add(new CastFloatToReal());
        }
        if ((features & OptimizerFeature.TypeInference.mask) != 0L) {
            visitors.add(new TypeInference());
        }
        return visitors;
    }

    static {
        DEFAULT_FEATURES |= OptimizerFeature.ConstFolding.mask;
        DEFAULT_FEATURES |= OptimizerFeature.PushUp.mask;
        DEFAULT_FEATURES |= OptimizerFeature.PushDown.mask;
        DEFAULT_FEATURES |= OptimizerFeature.MergeUnion.mask;
        DEFAULT_FEATURES |= OptimizerFeature.Ordinal.mask;
        DEFAULT_FEATURES |= OptimizerFeature.TypeInference.mask;
    }
}

