/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer.visitor;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExprGroup;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLDateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLInListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntervalExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntervalUnit;
import com.alibaba.fastsql.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNullExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNumberExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTimeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLValuableExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitorAdapter;
import com.alibaba.fastsql.sql.visitor.functions.Concat;
import com.alibaba.fastsql.sql.visitor.functions.Greatest;
import com.alibaba.fastsql.sql.visitor.functions.IfNull;
import com.alibaba.fastsql.sql.visitor.functions.Lcase;
import com.alibaba.fastsql.sql.visitor.functions.Least;
import com.alibaba.fastsql.sql.visitor.functions.Length;
import com.alibaba.fastsql.sql.visitor.functions.Substring;
import com.alibaba.fastsql.sql.visitor.functions.Ucase;
import com.alibaba.fastsql.util.FnvHash;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConstFolding
extends SQLASTVisitorAdapter {
    private int optimizedCount = 0;

    public ConstFolding() {
    }

    public ConstFolding(DbType dbType) {
        this.dbType = dbType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        SQLExpr owner = x.getOwner();
        if (owner != null) {
            owner.accept(this);
        }
        for (SQLExpr param : x.getArguments()) {
            param.accept(this);
        }
        SQLExpr for_ = x.getFor();
        if (for_ != null) {
            for_.accept(this);
        }
        boolean allConst = true;
        for (SQLExpr param : x.getArguments()) {
            if (param instanceof SQLValuableExpr) continue;
            allConst = false;
        }
        if (!allConst) return false;
        long hash = x.methodNameHashCode64();
        if (hash == FnvHash.Constants.SUBSTR) {
            Object val = Substring.instance.eval(x);
            if (!(val instanceof String)) return false;
            if (!SQLUtils.replaceInParent(x, new SQLCharExpr((String)val))) return false;
            ++this.optimizedCount;
            return false;
        }
        if (hash == FnvHash.Constants.CONCAT) {
            Object val = Concat.instance.eval(x);
            if (!(val instanceof String)) return false;
            if (!SQLUtils.replaceInParent(x, new SQLCharExpr((String)val))) return false;
            ++this.optimizedCount;
            return false;
        }
        if (hash == FnvHash.Constants.LCASE || hash == FnvHash.Constants.LOWER) {
            Object val = Lcase.instance.eval(x);
            if (!(val instanceof String)) return false;
            if (!SQLUtils.replaceInParent(x, new SQLCharExpr((String)val))) return false;
            ++this.optimizedCount;
            return false;
        }
        if (hash == FnvHash.Constants.UCASE || hash == FnvHash.Constants.UPPER) {
            Object val = Ucase.instance.eval(x);
            if (!(val instanceof String)) return false;
            if (!SQLUtils.replaceInParent(x, new SQLCharExpr((String)val))) return false;
            ++this.optimizedCount;
            return false;
        }
        if (hash == FnvHash.Constants.LENGTH || hash == FnvHash.Constants.LEN) {
            Object val = Length.instance.eval(x);
            if (!(val instanceof Integer)) return false;
            if (!SQLUtils.replaceInParent(x, new SQLIntegerExpr((Integer)val))) return false;
            ++this.optimizedCount;
            return false;
        }
        if (hash == FnvHash.Constants.GREAST) {
            Object val = Greatest.instance.eval(x);
            if (!(val instanceof Integer)) return false;
            if (!SQLUtils.replaceInParent(x, new SQLIntegerExpr((Integer)val))) return false;
            ++this.optimizedCount;
            return false;
        }
        if (hash == FnvHash.Constants.LEAST) {
            Object val = Least.instance.eval(x);
            if (!(val instanceof Integer)) return false;
            if (!SQLUtils.replaceInParent(x, new SQLIntegerExpr((Integer)val))) return false;
            ++this.optimizedCount;
            return false;
        }
        if (hash == FnvHash.Constants.IFNULL) {
            Object val = IfNull.instance.eval(x);
            if (val instanceof Integer) {
                if (!SQLUtils.replaceInParent(x, new SQLIntegerExpr((Integer)val))) return false;
                ++this.optimizedCount;
                return false;
            }
            if (!(val instanceof String)) return false;
            if (!SQLUtils.replaceInParent(x, new SQLCharExpr((String)val))) return false;
            ++this.optimizedCount;
            return false;
        }
        if (hash == FnvHash.Constants.IF) {
            Object condVal;
            SQLExpr condExpr;
            if (x.getArguments().size() != 3 || !((condExpr = x.getArguments().get(0)) instanceof SQLValuableExpr) || !((condVal = ((SQLValuableExpr)condExpr).getValue()) instanceof Boolean)) return false;
            if (((Boolean)condVal).booleanValue()) {
                SQLUtils.replaceInParent(x, x.getArguments().get(1));
                return false;
            } else {
                SQLUtils.replaceInParent(x, x.getArguments().get(2));
            }
            return false;
        }
        if (hash == FnvHash.Constants.TO_DATE) {
            boolean supportDateExpr;
            List<SQLExpr> arguments = x.getArguments();
            boolean bl = supportDateExpr = this.dbType == DbType.mysql || this.dbType == DbType.ads || this.dbType == DbType.hive;
            if (arguments.size() != 2 || !(arguments.get(0) instanceof SQLCharExpr) || !(arguments.get(1) instanceof SQLCharExpr) || !supportDateExpr) return false;
            String chars = ((SQLCharExpr)arguments.get(0)).getText();
            String format = ((SQLCharExpr)arguments.get(1)).getText();
            if (!format.equals("yyyymmdd")) return false;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
            try {
                Date date = dateFormat.parse(chars);
                String dateLiteral = new SimpleDateFormat("yyyy-MM-dd").format(date);
                if (!SQLUtils.replaceInParent(x, new SQLDateExpr(dateLiteral))) return false;
                ++this.optimizedCount;
                return false;
            }
            catch (ParseException e) {
                return false;
            }
        } else if (hash == FnvHash.Constants.DATEADD) {
            SQLDateExpr dateCloned;
            boolean supportDateAdd;
            List<SQLExpr> arguments = x.getArguments();
            boolean bl = supportDateAdd = this.dbType == DbType.mysql || this.dbType == DbType.ads;
            if (arguments.size() != 3 || !(arguments.get(0) instanceof SQLDateExpr) || !(arguments.get(1) instanceof SQLIntegerExpr) || !(arguments.get(2) instanceof SQLCharExpr) || !supportDateAdd) return false;
            SQLDateExpr dateExpr = (SQLDateExpr)arguments.get(0);
            int delta = ((SQLIntegerExpr)arguments.get(1)).getNumber().intValue();
            String type = ((SQLCharExpr)arguments.get(2)).getText();
            if (!"day".equalsIgnoreCase(type) || !(dateCloned = dateExpr.clone()).addDay(delta) || !SQLUtils.replaceInParent(x, dateCloned)) return false;
            ++this.optimizedCount;
            return false;
        } else {
            SimpleDateFormat dateFormat;
            String chars;
            List<SQLExpr> arguments;
            if (hash != FnvHash.Constants.TO_CHAR || (arguments = x.getArguments()).size() != 2 || !(arguments.get(0) instanceof SQLDateExpr) || !(arguments.get(1) instanceof SQLCharExpr)) return false;
            SQLDateExpr dateExpr = (SQLDateExpr)arguments.get(0);
            Date date = dateExpr.getDate();
            String format = ((SQLCharExpr)arguments.get(1)).getText();
            if (!format.equals("yyyymmdd") || date == null || !SQLUtils.replaceInParent(x, new SQLCharExpr(chars = (dateFormat = new SimpleDateFormat("yyyyMMdd")).format(date)))) return false;
            ++this.optimizedCount;
        }
        return false;
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        SQLExpr right;
        SQLExprImpl left;
        SQLBinaryOperator op;
        block49: {
            SQLLiteralExpr literal;
            String pattern;
            SQLExpr right2;
            op = x.getOperator();
            x.getLeft().accept(this);
            x.getRight().accept(this);
            if ((op == SQLBinaryOperator.BooleanAnd || op == SQLBinaryOperator.BooleanOr) && x.getLeft() instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)x.getLeft()).getOperator() == x.getOperator()) {
                SQLBinaryOpExprGroup group = new SQLBinaryOpExprGroup(op, x.getDbType());
                group.add(x.getLeft());
                group.add(x.getRight());
                if (SQLUtils.replaceInParent(x, group)) {
                    ++this.optimizedCount;
                    group.accept(this);
                    return false;
                }
            }
            if (op == SQLBinaryOperator.Like && x.getRight() instanceof SQLCharExpr) {
                right2 = (SQLCharExpr)x.getRight();
                pattern = right2.getText();
                if (pattern.indexOf(37) == -1 && pattern.indexOf(95) == -1) {
                    x.setOperator(SQLBinaryOperator.Equality);
                }
            } else if (op == SQLBinaryOperator.NotLike && x.getRight() instanceof SQLCharExpr && (pattern = (right2 = (SQLCharExpr)x.getRight()).getText()).indexOf(37) == -1 && pattern.indexOf(95) == -1) {
                x.setOperator(SQLBinaryOperator.LessThanOrGreater);
            }
            if (this.isNameAndLiteral(x.getLeft()) && x.getRight() instanceof SQLLiteralExpr) {
                left = (SQLBinaryOpExpr)x.getLeft();
                right = (SQLLiteralExpr)x.getRight();
                SQLLiteralExpr leftRight = (SQLLiteralExpr)((SQLBinaryOpExpr)left).getRight();
                if (((SQLBinaryOpExpr)left).getOperator() == x.getOperator()) {
                    switch (((SQLBinaryOpExpr)left).getOperator()) {
                        case Add: 
                        case Subtract: 
                        case Mod: 
                        case Modulus: 
                        case Multiply: 
                        case DIV: 
                        case Divide: 
                        case Concat: {
                            x.setLeft(((SQLBinaryOpExpr)left).getLeft());
                            x.setRight(new SQLBinaryOpExpr((SQLExpr)leftRight, ((SQLBinaryOpExpr)left).getOperator(), right));
                            x.getRight().accept(this);
                            break;
                        }
                    }
                }
            }
            if (x.getLeft() instanceof SQLValuableExpr && x.getRight() instanceof SQLValuableExpr) {
                this.handValueValue(x, op, (SQLValuableExpr)x.getLeft(), (SQLValuableExpr)x.getRight());
                return false;
            }
            if (x.getLeft() instanceof SQLDateExpr && x.getRight() instanceof SQLIntervalExpr && (op == SQLBinaryOperator.Add || op == SQLBinaryOperator.Subtract)) {
                String text;
                int intervalInt;
                left = (SQLDateExpr)x.getLeft();
                right = (SQLIntervalExpr)x.getRight();
                if (((SQLIntervalExpr)right).getValue() instanceof SQLCharExpr) {
                    String intervalText = ((SQLCharExpr)((SQLIntervalExpr)right).getValue()).getText();
                    try {
                        intervalInt = Integer.parseInt(intervalText);
                    }
                    catch (NumberFormatException ex) {
                        return false;
                    }
                } else {
                    return false;
                }
                if (op == SQLBinaryOperator.Subtract) {
                    intervalInt = -intervalInt;
                }
                if ((text = ((SQLDateExpr)left).getValue()).length() == 10) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        Date date = format.parse(text);
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(date);
                        if (((SQLIntervalExpr)right).getUnit() == SQLIntervalUnit.DAY) {
                            calendar.add(5, intervalInt);
                            String dateChanged = format.format(calendar.getTime());
                            if (SQLUtils.replaceInParent(x, new SQLDateExpr(dateChanged))) {
                                ++this.optimizedCount;
                                return false;
                            }
                        }
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
            if (this.isLeftLiteralAndRightName(x)) {
                right2 = (SQLName)x.getRight();
                SQLLiteralExpr left2 = (SQLLiteralExpr)x.getLeft();
                if (x.getOperator() == SQLBinaryOperator.LessThan) {
                    x.setRight(left2);
                    x.setLeft(right2);
                    x.setOperator(SQLBinaryOperator.GreaterThan);
                    ++this.optimizedCount;
                } else if (x.getOperator() == SQLBinaryOperator.Equality) {
                    x.setRight(left2);
                    x.setLeft(right2);
                    ++this.optimizedCount;
                } else if (x.getOperator() == SQLBinaryOperator.GreaterThanOrEqual) {
                    x.setRight(left2);
                    x.setLeft(right2);
                    x.setOperator(SQLBinaryOperator.LessThanOrEqual);
                    ++this.optimizedCount;
                }
            }
            if (x.isLeftNameAndRightLiteral()) {
                SQLName name = (SQLName)x.getLeft();
                literal = (SQLLiteralExpr)x.getRight();
                this.handleNameLiteral(x, name, literal);
            }
            if (this.isLeftFunctionAndRightLiteral(x)) {
                long dataTypeNameHash;
                SQLMethodInvokeExpr functionCall = (SQLMethodInvokeExpr)x.getLeft();
                literal = (SQLLiteralExpr)x.getRight();
                long nameHash = functionCall.methodNameHashCode64();
                SQLDataType dataType = functionCall.getResolvedReturnDataType();
                if (dataType != null && (dataTypeNameHash = dataType.nameHashCode64()) == FnvHash.Constants.BIGINT && literal instanceof SQLCharExpr) {
                    String text = ((SQLCharExpr)literal).getText();
                    try {
                        long val = Long.parseLong(text);
                        x.setRight(new SQLIntegerExpr(val));
                        ++this.optimizedCount;
                    }
                    catch (NumberFormatException ex) {
                        if (!SQLUtils.replaceInParent(x, new SQLBooleanExpr(false))) break block49;
                        ++this.optimizedCount;
                        return false;
                    }
                }
            }
        }
        if (op == SQLBinaryOperator.BooleanAnd) {
            if (this.isLeftNameAndRightLiteral(x.getLeft()) && this.isLeftNameAndRightLiteral(x.getRight())) {
                left = (SQLBinaryOpExpr)x.getLeft();
                right = (SQLBinaryOpExpr)x.getRight();
                this.mergeTwiceOp(x, (SQLBinaryOpExpr)left, (SQLBinaryOpExpr)right);
            } else if (this.isBothName(x.getLeft()) && this.isLeftNameAndRightLiteral(x.getRight())) {
                left = (SQLBinaryOpExpr)x.getLeft();
                right = (SQLBinaryOpExpr)x.getRight();
                if (((SQLBinaryOpExpr)left).getOperator() == ((SQLBinaryOpExpr)right).getOperator()) {
                    if (((SQLBinaryOpExpr)left).getLeft().equals(((SQLBinaryOpExpr)right).getLeft())) {
                        ((SQLBinaryOpExpr)left).setRight(((SQLBinaryOpExpr)right).getRight().clone());
                        ++this.optimizedCount;
                    } else if (((SQLBinaryOpExpr)left).getRight().equals(((SQLBinaryOpExpr)right).getLeft())) {
                        ((SQLBinaryOpExpr)left).setLeft(((SQLBinaryOpExpr)left).getRight());
                        ((SQLBinaryOpExpr)left).setRight(((SQLBinaryOpExpr)right).getRight().clone());
                        ++this.optimizedCount;
                    }
                }
            }
        }
        if (op == SQLBinaryOperator.Equality) {
            SQLSelectQueryBlock queryBlock;
            if (this.isLeftNameAndRightLiteral(x.getLeft()) && x.getRight() instanceof SQLLiteralExpr) {
                left = (SQLBinaryOpExpr)x.getLeft();
                if (((SQLBinaryOpExpr)left).getOperator() == SQLBinaryOperator.Add && ((SQLBinaryOpExpr)left).getRight() instanceof SQLIntegerExpr && x.getRight() instanceof SQLIntegerExpr) {
                    int val = ((SQLIntegerExpr)x.getRight()).getNumber().intValue() - ((SQLIntegerExpr)((SQLBinaryOpExpr)left).getRight()).getNumber().intValue();
                    x.setRight(new SQLIntegerExpr(val));
                    x.setLeft(((SQLBinaryOpExpr)left).getLeft());
                    ++this.optimizedCount;
                    return false;
                }
            } else if (x.isLeftNameAndRightLiteral() && x.getParent() instanceof SQLSelectQueryBlock && (queryBlock = (SQLSelectQueryBlock)x.getParent()).getLimit() == null && queryBlock.getFrom() instanceof SQLJoinTableSource && this.isBothName(((SQLJoinTableSource)queryBlock.getFrom()).getCondition())) {
                SQLJoinTableSource joinTableSource = (SQLJoinTableSource)queryBlock.getFrom();
                SQLBinaryOpExpr joinCondition = (SQLBinaryOpExpr)joinTableSource.getCondition();
                if (joinTableSource.getJoinType() == SQLJoinTableSource.JoinType.INNER_JOIN && joinCondition.getOperator() == SQLBinaryOperator.Equality && joinCondition.getLeft().equals(x.getLeft())) {
                    SQLExpr to = SQLBinaryOpExpr.and(joinCondition.clone(), x.clone(), new SQLBinaryOpExpr(joinCondition.getRight().clone(), SQLBinaryOperator.Equality, x.getRight().clone()));
                    if (SQLUtils.replaceInParent(x, null)) {
                        joinTableSource.setCondition(to);
                        ++this.optimizedCount;
                        return false;
                    }
                }
            }
        }
        return false;
    }

    private void mergeTwiceOp(SQLExpr x, SQLBinaryOpExpr left, SQLBinaryOpExpr right) {
        SQLBinaryOperator leftOp = left.getOperator();
        SQLBinaryOperator rightOp = right.getOperator();
        SQLBinaryOpExpr replaceTo = null;
        if (left.getLeft().equals(right.getLeft()) && left.getRight().equals(right.getRight())) {
            if (leftOp == SQLBinaryOperator.Equality && (rightOp == SQLBinaryOperator.LessThanOrEqual || rightOp == SQLBinaryOperator.GreaterThanOrEqual)) {
                replaceTo = left;
            } else if (rightOp == SQLBinaryOperator.Equality && (leftOp == SQLBinaryOperator.LessThanOrEqual || leftOp == SQLBinaryOperator.GreaterThanOrEqual)) {
                replaceTo = right;
            } else if (leftOp == SQLBinaryOperator.LessThanOrEqual && rightOp == SQLBinaryOperator.GreaterThanOrEqual || leftOp == SQLBinaryOperator.GreaterThanOrEqual && rightOp == SQLBinaryOperator.LessThanOrEqual) {
                SQLBinaryOpExpr expr;
                replaceTo = expr = new SQLBinaryOpExpr(left.getLeft().clone(), SQLBinaryOperator.Equality, left.getRight().clone());
            }
        }
        if (replaceTo != null) {
            if (x instanceof SQLBinaryOpExprGroup) {
                SQLBinaryOpExprGroup group = (SQLBinaryOpExprGroup)x;
                if (group.getOperator() == SQLBinaryOperator.BooleanAnd) {
                    group.getItems().remove(left);
                    group.getItems().remove(right);
                    group.add(replaceTo);
                }
            } else if (SQLUtils.replaceInParent(x, replaceTo)) {
                ++this.optimizedCount;
            }
        }
    }

    private void handValueValue(SQLBinaryOpExpr x, SQLBinaryOperator op, SQLValuableExpr leftExpr, SQLValuableExpr rightExpr) {
        if (rightExpr instanceof SQLNullExpr) {
            if (op == SQLBinaryOperator.Is) {
                if (leftExpr instanceof SQLNullExpr) {
                    if (SQLUtils.replaceInParent(x, new SQLBooleanExpr(true))) {
                        ++this.optimizedCount;
                    }
                } else if (SQLUtils.replaceInParent(x, new SQLBooleanExpr(false))) {
                    ++this.optimizedCount;
                }
            } else if (op == SQLBinaryOperator.IsNot) {
                if (leftExpr instanceof SQLNullExpr) {
                    if (SQLUtils.replaceInParent(x, new SQLBooleanExpr(false))) {
                        ++this.optimizedCount;
                    }
                } else if (SQLUtils.replaceInParent(x, new SQLBooleanExpr(true))) {
                    ++this.optimizedCount;
                }
            }
        }
        Object leftVal = leftExpr.getValue();
        Object rightVal = rightExpr.getValue();
        if (leftVal instanceof Integer && rightVal instanceof Integer) {
            int leftIntVal = (Integer)leftVal;
            int rightIntVal = (Integer)rightVal;
            switch (op) {
                case Add: {
                    if (!SQLUtils.replaceInParent(x, new SQLIntegerExpr(leftIntVal + rightIntVal))) break;
                    ++this.optimizedCount;
                    return;
                }
                case Subtract: {
                    if (!SQLUtils.replaceInParent(x, new SQLIntegerExpr(leftIntVal - rightIntVal))) break;
                    ++this.optimizedCount;
                    return;
                }
                case Multiply: {
                    if (!SQLUtils.replaceInParent(x, new SQLIntegerExpr(leftIntVal * rightIntVal))) break;
                    ++this.optimizedCount;
                    return;
                }
                case Divide: {
                    int result = leftIntVal / rightIntVal;
                    int mod = leftIntVal % rightIntVal;
                    if (mod != 0 || !SQLUtils.replaceInParent(x, new SQLIntegerExpr(result))) break;
                    ++this.optimizedCount;
                    return;
                }
                case Mod: 
                case Modulus: {
                    int result = leftIntVal % rightIntVal;
                    if (!SQLUtils.replaceInParent(x, new SQLIntegerExpr(result))) break;
                    ++this.optimizedCount;
                    return;
                }
            }
        }
        if (leftVal instanceof Integer && rightVal instanceof Long) {
            leftVal = new Long(((Integer)leftVal).intValue());
        } else if (leftVal instanceof Long && rightVal instanceof Integer) {
            rightVal = new Long(((Integer)rightVal).intValue());
        }
        if (leftVal instanceof Long && rightVal instanceof Long) {
            long leftIntVal = (Long)leftVal;
            long rightIntVal = (Long)rightVal;
            switch (op) {
                case Add: {
                    if (!SQLUtils.replaceInParent(x, new SQLIntegerExpr(leftIntVal + rightIntVal))) break;
                    ++this.optimizedCount;
                    return;
                }
                case Subtract: {
                    if (!SQLUtils.replaceInParent(x, new SQLIntegerExpr(leftIntVal - rightIntVal))) break;
                    ++this.optimizedCount;
                    return;
                }
                case Multiply: {
                    if (!SQLUtils.replaceInParent(x, new SQLIntegerExpr(leftIntVal * rightIntVal))) break;
                    ++this.optimizedCount;
                    return;
                }
                case Divide: {
                    long result = leftIntVal / rightIntVal;
                    long mod = leftIntVal % rightIntVal;
                    if (mod != 0L || !SQLUtils.replaceInParent(x, new SQLIntegerExpr(result))) break;
                    ++this.optimizedCount;
                    return;
                }
                case Mod: 
                case Modulus: {
                    long result = leftIntVal % rightIntVal;
                    if (!SQLUtils.replaceInParent(x, new SQLIntegerExpr(result))) break;
                    ++this.optimizedCount;
                    return;
                }
            }
        }
        if (leftVal instanceof BigDecimal && (rightVal instanceof Long || rightVal instanceof Integer)) {
            rightVal = new BigDecimal(((Number)rightVal).longValue());
        } else if (rightExpr instanceof BigDecimal && (leftVal instanceof Long || leftVal instanceof Integer)) {
            leftVal = new BigDecimal(((Number)leftVal).longValue());
        }
        if (leftVal instanceof Double && rightVal instanceof Number) {
            rightVal = ((Number)rightVal).doubleValue();
        } else if (leftVal instanceof Float && rightVal instanceof Number) {
            leftVal = ((Float)leftVal).doubleValue();
            rightVal = ((Number)rightVal).doubleValue();
        }
        if (leftVal instanceof BigDecimal && rightVal instanceof BigDecimal) {
            BigDecimal leftRealVal = (BigDecimal)leftVal;
            BigDecimal rightRealVal = (BigDecimal)rightVal;
            switch (op) {
                case Add: {
                    if (!SQLUtils.replaceInParent(x, new SQLNumberExpr(leftRealVal.add(rightRealVal)))) break;
                    ++this.optimizedCount;
                    return;
                }
                case Subtract: {
                    if (!SQLUtils.replaceInParent(x, new SQLNumberExpr(leftRealVal.subtract(rightRealVal)))) break;
                    ++this.optimizedCount;
                    return;
                }
                case Multiply: {
                    if (!SQLUtils.replaceInParent(x, new SQLNumberExpr(leftRealVal.multiply(rightRealVal)))) break;
                    ++this.optimizedCount;
                    return;
                }
                case Divide: {
                    if (!SQLUtils.replaceInParent(x, new SQLNumberExpr(leftRealVal.divide(rightRealVal)))) break;
                    ++this.optimizedCount;
                    return;
                }
            }
        } else if (leftVal instanceof Double && rightVal instanceof Double) {
            double leftDoubleVal = (Double)leftVal;
            double rightDoubleVal = (Double)rightVal;
            switch (op) {
                case Add: {
                    if (!SQLUtils.replaceInParent(x, new SQLNumberExpr(leftDoubleVal + rightDoubleVal))) break;
                    ++this.optimizedCount;
                    return;
                }
                case Subtract: {
                    if (!SQLUtils.replaceInParent(x, new SQLNumberExpr(leftDoubleVal - rightDoubleVal))) break;
                    ++this.optimizedCount;
                    return;
                }
                case Multiply: {
                    if (!SQLUtils.replaceInParent(x, new SQLNumberExpr(leftDoubleVal * rightDoubleVal))) break;
                    ++this.optimizedCount;
                    return;
                }
                case Divide: {
                    if (!SQLUtils.replaceInParent(x, new SQLNumberExpr(leftDoubleVal / rightDoubleVal))) break;
                    ++this.optimizedCount;
                    return;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleNameLiteral(SQLExpr x, SQLName name, SQLLiteralExpr literal) {
        SQLColumnDefinition column = null;
        if (name instanceof SQLIdentifierExpr) {
            column = ((SQLIdentifierExpr)name).getResolvedColumn();
        } else {
            if (!(name instanceof SQLPropertyExpr)) return;
            column = ((SQLPropertyExpr)name).getResolvedColumn();
        }
        if (column == null || column.getDataType() == null) return;
        SQLDataType dataType = column.getDataType();
        long dataTypeNameHash = dataType.nameHashCode64();
        if (dataTypeNameHash == FnvHash.Constants.BIGINT || dataTypeNameHash == FnvHash.Constants.INT || dataTypeNameHash == FnvHash.Constants.SMALLINT || dataTypeNameHash == FnvHash.Constants.TINYINT) {
            if (literal instanceof SQLCharExpr) {
                String text = ((SQLCharExpr)literal).getText();
                try {
                    SQLIntegerExpr intExpr;
                    if (dataTypeNameHash == FnvHash.Constants.BIGINT) {
                        long val = Long.parseLong(text);
                        intExpr = new SQLIntegerExpr(val);
                    } else {
                        int val = Integer.parseInt(text);
                        intExpr = new SQLIntegerExpr(val);
                    }
                    if (!SQLUtils.replaceInParent(literal, intExpr)) return;
                    ++this.optimizedCount;
                    return;
                }
                catch (NumberFormatException ex) {
                    if (!SQLUtils.replaceInParent(x, new SQLBooleanExpr(false))) return;
                    ++this.optimizedCount;
                    return;
                }
            } else {
                SQLNumberExpr numberExpr;
                Number number;
                if (!(literal instanceof SQLNumberExpr) || !((number = (numberExpr = (SQLNumberExpr)literal).getNumber()) instanceof BigDecimal)) return;
                BigDecimal decimal = (BigDecimal)number;
                String strVal = decimal.toString();
                if (decimal.doubleValue() != (double)decimal.longValue()) return;
                BigInteger integer = decimal.toBigInteger();
                numberExpr.setNumber(integer);
            }
            return;
        } else if (dataTypeNameHash == FnvHash.Constants.CHAR || dataTypeNameHash == FnvHash.Constants.VARCHAR || dataTypeNameHash == FnvHash.Constants.VARCHAR2 || dataTypeNameHash == FnvHash.Constants.CLOB) {
            String text;
            SQLCharExpr charExpr;
            if (!(literal instanceof SQLIntegerExpr) || !SQLUtils.replaceInParent(literal, charExpr = new SQLCharExpr(text = literal.toString()))) return;
            ++this.optimizedCount;
            return;
        } else if (dataTypeNameHash == FnvHash.Constants.DATE) {
            String text;
            SQLDateExpr dateExpr;
            if (!(literal instanceof SQLCharExpr) || !SQLUtils.replaceInParent(literal, dateExpr = new SQLDateExpr(text = ((SQLCharExpr)literal).getText()))) return;
            ++this.optimizedCount;
            return;
        } else if (dataTypeNameHash == FnvHash.Constants.TIMESTAMP) {
            String text;
            SQLTimestampExpr timestampExpr;
            if (!(literal instanceof SQLCharExpr) || !SQLUtils.replaceInParent(literal, timestampExpr = new SQLTimestampExpr(text = ((SQLCharExpr)literal).getText()))) return;
            ++this.optimizedCount;
            return;
        } else if (dataTypeNameHash == FnvHash.Constants.TIME) {
            String text;
            SQLTimeExpr timeExpr;
            if (!(literal instanceof SQLCharExpr) || !SQLUtils.replaceInParent(literal, timeExpr = new SQLTimeExpr(text = ((SQLCharExpr)literal).getText()))) return;
            ++this.optimizedCount;
            return;
        } else if (dataTypeNameHash == FnvHash.Constants.DOUBLE) {
            if (literal instanceof SQLNumberExpr) {
                double value = ((SQLNumberExpr)literal).getNumber().doubleValue();
                SQLNumberExpr numberExpr = new SQLNumberExpr(value);
                if (!SQLUtils.replaceInParent(literal, numberExpr)) return;
                ++this.optimizedCount;
                return;
            } else {
                String chars;
                double value;
                SQLNumberExpr numberExpr;
                if (!(literal instanceof SQLCharExpr) || !SQLUtils.replaceInParent(literal, numberExpr = new SQLNumberExpr(value = Double.parseDouble(chars = ((SQLCharExpr)literal).getText())))) return;
                ++this.optimizedCount;
            }
            return;
        } else if (dataTypeNameHash == FnvHash.Constants.FLOAT) {
            if (literal instanceof SQLNumberExpr) {
                float value = ((SQLNumberExpr)literal).getNumber().floatValue();
                SQLNumberExpr numberExpr = new SQLNumberExpr(Float.valueOf(value));
                if (!SQLUtils.replaceInParent(literal, numberExpr)) return;
                ++this.optimizedCount;
                return;
            } else {
                String chars;
                float value;
                SQLNumberExpr numberExpr;
                if (!(literal instanceof SQLCharExpr) || !SQLUtils.replaceInParent(literal, numberExpr = new SQLNumberExpr(Float.valueOf(value = Float.parseFloat(chars = ((SQLCharExpr)literal).getText()))))) return;
                ++this.optimizedCount;
            }
            return;
        } else {
            String chars;
            BigDecimal value;
            SQLNumberExpr numberExpr;
            if (dataTypeNameHash != FnvHash.Constants.DECIMAL || !(literal instanceof SQLCharExpr) || !SQLUtils.replaceInParent(literal, numberExpr = new SQLNumberExpr(value = new BigDecimal(chars = ((SQLCharExpr)literal).getText())))) return;
            ++this.optimizedCount;
        }
    }

    @Override
    public boolean visit(SQLBinaryOpExprGroup x) {
        if (x.getOperator() == SQLBinaryOperator.BooleanAnd) {
            SQLExpr right;
            SQLExpr left;
            SQLBinaryOpExpr binaryOpExpr;
            HashMap<SQLExpr, SQLExpr> constFields = new HashMap<SQLExpr, SQLExpr>();
            HashMap<SQLName, ArrayList<SQLBinaryOpExpr>> nameConditions = new HashMap<SQLName, ArrayList<SQLBinaryOpExpr>>();
            for (int i = 0; i < x.getItems().size(); ++i) {
                SQLExpr sQLExpr = x.getItems().get(i);
                if (!(sQLExpr instanceof SQLBinaryOpExpr)) continue;
                binaryOpExpr = (SQLBinaryOpExpr)sQLExpr;
                left = binaryOpExpr.getLeft();
                right = binaryOpExpr.getRight();
                if (binaryOpExpr.getOperator() == SQLBinaryOperator.Equality && left instanceof SQLName && right instanceof SQLValuableExpr) {
                    constFields.put(left, right);
                }
                if (!this.isLeftNameAndRightLiteral(sQLExpr)) continue;
                ArrayList<SQLBinaryOpExpr> exprList = (ArrayList<SQLBinaryOpExpr>)nameConditions.get(left);
                if (exprList == null) {
                    exprList = new ArrayList<SQLBinaryOpExpr>();
                    nameConditions.put((SQLName)left, exprList);
                }
                exprList.add((SQLBinaryOpExpr)sQLExpr);
            }
            for (SQLExpr sQLExpr : x.getItems()) {
                SQLExpr rightLiteral;
                if (!(sQLExpr instanceof SQLBinaryOpExpr)) continue;
                binaryOpExpr = (SQLBinaryOpExpr)sQLExpr;
                left = binaryOpExpr.getLeft();
                right = binaryOpExpr.getRight();
                if (!(left instanceof SQLName) || !(right instanceof SQLName)) continue;
                SQLExpr leftLiteral = (SQLExpr)constFields.get(left);
                if (leftLiteral != null) {
                    binaryOpExpr.setLeft(leftLiteral.clone());
                    ++this.optimizedCount;
                }
                if ((rightLiteral = (SQLExpr)constFields.get(right)) == null) continue;
                binaryOpExpr.setRight(rightLiteral.clone());
                ++this.optimizedCount;
            }
            for (Map.Entry entry : nameConditions.entrySet()) {
                List exprList = (List)entry.getValue();
                for (int i = 1; i < exprList.size(); ++i) {
                    SQLBinaryOpExpr left2 = (SQLBinaryOpExpr)exprList.get(i - 1);
                    SQLBinaryOpExpr right2 = (SQLBinaryOpExpr)exprList.get(i);
                    this.mergeTwiceOp(x, left2, right2);
                }
            }
        }
        Collections.sort(x.getItems(), new Comparator<SQLExpr>(){

            @Override
            public int compare(SQLExpr a, SQLExpr b) {
                if (a instanceof SQLBinaryOpExpr && b instanceof SQLBinaryOpExpr) {
                    return this.compare((SQLBinaryOpExpr)a, (SQLBinaryOpExpr)b);
                }
                return 0;
            }

            @Override
            public int compare(SQLBinaryOpExpr a, SQLBinaryOpExpr b) {
                if (ConstFolding.this.isNameAndLiteral(a) && ConstFolding.this.isName2(b)) {
                    return -1;
                }
                if (ConstFolding.this.isNameAndLiteral(b) && ConstFolding.this.isName2(a)) {
                    return 1;
                }
                if (ConstFolding.this.isNameAndLiteral(a) && ConstFolding.this.isNameAndLiteral(b)) {
                    SQLName aName = this.getName(a);
                    SQLName bName = this.getName(b);
                    SQLLiteralExpr aLiteral = this.getLiterlal(a);
                    SQLLiteralExpr bLiteral = this.getLiterlal(b);
                    if (!aName.equals(bName) || aLiteral.getClass() == bLiteral.getClass()) {
                        // empty if block
                    }
                }
                return 0;
            }

            private SQLName getName(SQLBinaryOpExpr x) {
                SQLExpr left = x.getLeft();
                SQLExpr right = x.getRight();
                if (left instanceof SQLName) {
                    return (SQLName)left;
                }
                if (right instanceof SQLName) {
                    return (SQLName)right;
                }
                return null;
            }

            private SQLLiteralExpr getLiterlal(SQLBinaryOpExpr x) {
                SQLExpr left = x.getLeft();
                SQLExpr right = x.getRight();
                if (left instanceof SQLLiteralExpr) {
                    return (SQLLiteralExpr)left;
                }
                if (right instanceof SQLLiteralExpr) {
                    return (SQLLiteralExpr)right;
                }
                return null;
            }
        });
        for (SQLExpr item : x.getItems()) {
            item.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLInListExpr x) {
        SQLExpr expr = x.getExpr();
        List<SQLExpr> targetList = x.getTargetList();
        expr.accept(this);
        for (SQLExpr item : targetList) {
            item.accept(this);
        }
        if (expr instanceof SQLName) {
            SQLName name = (SQLName)expr;
            for (int i = 0; i < targetList.size(); ++i) {
                SQLExpr item = targetList.get(i);
                if (!(item instanceof SQLLiteralExpr)) continue;
                SQLLiteralExpr literal = (SQLLiteralExpr)item;
                this.handleNameLiteral(x, name, literal);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLBetweenExpr x) {
        SQLExpr expr = x.getTestExpr();
        x.getTestExpr().accept(this);
        x.getBeginExpr().accept(this);
        x.getEndExpr().accept(this);
        if (expr instanceof SQLName) {
            SQLName name = (SQLName)expr;
            if (x.getBeginExpr() instanceof SQLLiteralExpr) {
                this.handleNameLiteral(x, name, (SQLLiteralExpr)x.getBeginExpr());
            }
            if (x.getEndExpr() instanceof SQLLiteralExpr) {
                this.handleNameLiteral(x, name, (SQLLiteralExpr)x.getEndExpr());
            }
        }
        return false;
    }

    private boolean isBothName(SQLExpr x) {
        if (x instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)x;
            return binaryOpExpr.getLeft() instanceof SQLName && binaryOpExpr.getRight() instanceof SQLName;
        }
        return false;
    }

    private boolean isLeftNameAndRightLiteral(SQLExpr x) {
        if (x instanceof SQLBinaryOpExpr) {
            return ((SQLBinaryOpExpr)x).isLeftNameAndRightLiteral();
        }
        return false;
    }

    private boolean isLeftNameAndRightLiteral(SQLBinaryOpExpr x) {
        return x.getLeft() instanceof SQLName && x.getRight() instanceof SQLLiteralExpr;
    }

    private boolean isLeftFunctionAndRightLiteral(SQLBinaryOpExpr x) {
        return x.getLeft() instanceof SQLMethodInvokeExpr && x.getRight() instanceof SQLLiteralExpr;
    }

    private boolean isLeftLiteralAndRightName(SQLBinaryOpExpr x) {
        return x.getRight() instanceof SQLName && x.getLeft() instanceof SQLLiteralExpr;
    }

    private boolean isNameAndLiteral(SQLExpr x) {
        if (x instanceof SQLBinaryOpExpr) {
            return this.isNameAndLiteral((SQLBinaryOpExpr)x);
        }
        return false;
    }

    private boolean isNameAndLiteral(SQLBinaryOpExpr x) {
        SQLExpr left = x.getLeft();
        SQLExpr right = x.getRight();
        if (left instanceof SQLLiteralExpr && right instanceof SQLName) {
            return true;
        }
        return left instanceof SQLName && right instanceof SQLLiteralExpr;
    }

    private boolean isName2(SQLBinaryOpExpr x) {
        return x.getLeft() instanceof SQLName && x.getRight() instanceof SQLName;
    }

    public int getOptimizedCount() {
        return this.optimizedCount;
    }
}

