/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer.visitor;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExprGroup;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNullExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.repository.SchemaRepository;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitorAdapter;

public class Constant
extends SQLASTVisitorAdapter {
    private SchemaRepository repository;

    public Constant() {
    }

    public Constant(SchemaRepository repository) {
        this.repository = repository;
    }

    @Override
    public void endVisit(SQLSelectQueryBlock x) {
        SQLExpr where = x.getWhere();
        if (where instanceof SQLBooleanExpr && ((SQLBooleanExpr)where).getBooleanValue()) {
            x.setWhere(null);
        }
    }

    @Override
    public boolean visit(SQLBinaryOpExprGroup x) {
        block6: {
            int i;
            block5: {
                for (i = x.getItems().size() - 1; i >= 0; --i) {
                    x.getItems().get(i).accept(this);
                }
                if (x.getOperator() != SQLBinaryOperator.BooleanOr) break block5;
                for (i = x.getItems().size() - 1; i >= 0; --i) {
                    SQLExpr expr = x.getItems().get(i);
                    if (!(expr instanceof SQLBooleanExpr)) continue;
                    if (((SQLBooleanExpr)expr).getBooleanValue()) {
                        if (!SQLUtils.replaceInParent(x, expr)) continue;
                        return false;
                    }
                    x.getItems().remove(i);
                }
                break block6;
            }
            if (x.getOperator() != SQLBinaryOperator.BooleanAnd) break block6;
            for (i = x.getItems().size() - 1; i >= 0; --i) {
                SQLExpr expr = x.getItems().get(i);
                if (!(expr instanceof SQLBooleanExpr)) continue;
                if (((SQLBooleanExpr)expr).getBooleanValue()) {
                    x.getItems().remove(i);
                    continue;
                }
                if (!SQLUtils.replaceInParent(x, expr)) continue;
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        x.getLeft().accept(this);
        x.getRight().accept(this);
        SQLExpr left = x.getLeft();
        SQLExpr right = x.getRight();
        switch (x.getOperator()) {
            case Equality: {
                if (left instanceof SQLLiteralExpr && right instanceof SQLLiteralExpr && left.equals(right)) {
                    SQLUtils.replaceInParent(x, new SQLBooleanExpr(true));
                    break;
                }
                if (left instanceof SQLLiteralExpr && right instanceof SQLLiteralExpr && left.getClass() == right.getClass() && !left.equals(right)) {
                    SQLUtils.replaceInParent(x, new SQLBooleanExpr(false));
                    break;
                }
                if (left instanceof SQLIdentifierExpr && right instanceof SQLIdentifierExpr && left.equals(right)) {
                    SQLColumnDefinition column = ((SQLIdentifierExpr)left).getResolvedColumn();
                    if (column != null && column.containsNotNullConstaint()) {
                        SQLUtils.replaceInParent(x, new SQLBooleanExpr(true));
                        break;
                    }
                    SQLUtils.replaceInParent(x, new SQLBinaryOpExpr(left.clone(), SQLBinaryOperator.IsNot, new SQLNullExpr()));
                    break;
                }
                if (!(left instanceof SQLPropertyExpr) || !(right instanceof SQLPropertyExpr) || !left.equals(right)) break;
                SQLColumnDefinition column = ((SQLPropertyExpr)left).getResolvedColumn();
                if (column != null && column.containsNotNullConstaint()) {
                    SQLUtils.replaceInParent(x, new SQLBooleanExpr(true));
                    break;
                }
                SQLUtils.replaceInParent(x, new SQLBinaryOpExpr(left.clone(), SQLBinaryOperator.IsNot, new SQLNullExpr()));
                break;
            }
            case LessThan: 
            case GreaterThan: {
                if (!(left instanceof SQLName) || !(right instanceof SQLName) || !left.equals(right)) break;
                SQLUtils.replaceInParent(x, new SQLBooleanExpr(false));
                break;
            }
            case NotEqual: 
            case LessThanOrGreater: {
                if (!(left instanceof SQLLiteralExpr) || !(right instanceof SQLLiteralExpr) || left.getClass() != right.getClass()) break;
                if (left.equals(right)) {
                    SQLUtils.replaceInParent(x, new SQLBooleanExpr(false));
                    break;
                }
                SQLUtils.replaceInParent(x, new SQLBooleanExpr(true));
                break;
            }
            case BooleanOr: {
                if (left instanceof SQLBooleanExpr) {
                    if (((SQLBooleanExpr)left).getBooleanValue()) {
                        SQLUtils.replaceInParent(x, left);
                        break;
                    }
                    SQLUtils.replaceInParent(x, right);
                    break;
                }
                if (!(right instanceof SQLBooleanExpr)) break;
                if (((SQLBooleanExpr)right).getBooleanValue()) {
                    SQLUtils.replaceInParent(x, right);
                    break;
                }
                SQLUtils.replaceInParent(x, left);
                break;
            }
            case BooleanAnd: {
                if (left instanceof SQLBooleanExpr) {
                    if (((SQLBooleanExpr)left).getBooleanValue()) {
                        SQLUtils.replaceInParent(x, right);
                        break;
                    }
                    SQLUtils.replaceInParent(x, left);
                    break;
                }
                if (!(right instanceof SQLBooleanExpr)) break;
                if (((SQLBooleanExpr)right).getBooleanValue()) {
                    SQLUtils.replaceInParent(x, left);
                    break;
                }
                SQLUtils.replaceInParent(x, right);
                break;
            }
            case Like: {
                SQLColumnDefinition column = null;
                if (left instanceof SQLIdentifierExpr) {
                    column = ((SQLIdentifierExpr)left).getResolvedColumn();
                } else if (left instanceof SQLPropertyExpr) {
                    column = ((SQLPropertyExpr)left).getResolvedColumn();
                }
                if (column == null || !column.containsNotNullConstaint() || !(right instanceof SQLCharExpr)) break;
                boolean matchAll = false;
                String pattern = ((SQLCharExpr)right).getText();
                if (pattern.length() > 0) {
                    int count = 0;
                    for (int i = 0; i < pattern.length(); ++i) {
                        char ch = pattern.charAt(i);
                        if (ch != '%') continue;
                        ++count;
                    }
                    if (count == pattern.length()) {
                        matchAll = true;
                    }
                }
                if (!matchAll) break;
                SQLUtils.replaceInParent(x, new SQLBooleanExpr(true));
                break;
            }
        }
        return false;
    }
}

