/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer.visitor;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLOrderBy;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLInsertStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitorAdapter;
import java.util.List;

public class Ordinal
extends SQLASTVisitorAdapter {
    private int replaceCount = 0;

    @Override
    public boolean visit(SQLSelectQueryBlock x) {
        SQLOrderBy orderBy;
        List<SQLSelectItem> selectItems = x.getSelectList();
        SQLSelectGroupByClause groupBy = x.getGroupBy();
        if (groupBy != null && !groupBy.isWithCube() && !groupBy.isWithRollUp()) {
            block0: for (int i = 0; i < groupBy.getItems().size(); ++i) {
                SQLExpr expr = groupBy.getItems().get(i);
                if (expr instanceof SQLLiteralExpr) continue;
                for (int j = 0; j < selectItems.size(); ++j) {
                    SQLExpr selectItemExpr = selectItems.get(j).getExpr();
                    if (!expr.equals(selectItemExpr)) continue;
                    SQLIntegerExpr indexExpr = new SQLIntegerExpr(j + 1);
                    indexExpr.setParent(x);
                    groupBy.getItems().set(i, indexExpr);
                    ++this.replaceCount;
                    continue block0;
                }
            }
        }
        if ((orderBy = x.getOrderBy()) != null && (groupBy == null || !groupBy.isWithCube() && !groupBy.isWithRollUp())) {
            block2: for (int i = 0; i < orderBy.getItems().size(); ++i) {
                SQLSelectOrderByItem orderByItem = orderBy.getItems().get(i);
                SQLExpr expr = orderByItem.getExpr();
                if (expr instanceof SQLLiteralExpr) continue;
                for (int j = 0; j < selectItems.size(); ++j) {
                    SQLExpr selectItemExpr = selectItems.get(j).getExpr();
                    if (!expr.equals(selectItemExpr)) continue;
                    orderByItem.setExpr(new SQLIntegerExpr(j + 1));
                    ++this.replaceCount;
                    continue block2;
                }
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLInsertStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLUpdateStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLDeleteStatement x) {
        return false;
    }

    public int getReplaceCount() {
        return this.replaceCount;
    }
}

