/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer.visitor;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLLimit;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLAggregateOption;
import com.alibaba.fastsql.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQuery;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitorAdapter;
import com.alibaba.fastsql.util.FnvHash;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class PushDown
extends SQLASTVisitorAdapter {
    private int optimizedCount = 0;

    @Override
    public boolean visit(SQLSelectQueryBlock x) {
        List<SQLSelectItem> subSelectList;
        SQLExpr expr;
        SQLTableSource from;
        List<SQLSelectItem> selectList = x.getSelectList();
        for (SQLSelectItem selectItem : selectList) {
            selectItem.accept(this);
        }
        SQLExpr where = x.getWhere();
        if (where != null) {
            where.accept(this);
        }
        if ((from = x.getFrom()) != null) {
            from.accept(this);
        }
        if (!((from = x.getFrom()) instanceof SQLSubqueryTableSource) || !(((SQLSubqueryTableSource)from).getSelect().getQuery() instanceof SQLSelectQueryBlock)) {
            return false;
        }
        SQLSelectQueryBlock subQuery = ((SQLSubqueryTableSource)from).getSelect().getQueryBlock();
        for (SQLSelectItem selectItem : subQuery.getSelectList()) {
            expr = selectItem.getExpr();
            if (!(expr instanceof SQLAggregateExpr) || ((SQLAggregateExpr)expr).getOver() == null) continue;
            return false;
        }
        boolean allColumnMatched = false;
        SQLSelectItem aggItem = null;
        if (selectList.size() == 1) {
            SQLAggregateExpr aggExpr;
            expr = selectList.get(0).getExpr();
            if (expr instanceof SQLAllColumnExpr) {
                allColumnMatched = true;
            } else if (expr instanceof SQLPropertyExpr && ((SQLPropertyExpr)expr).getName().equals("*")) {
                allColumnMatched = true;
            } else if (expr instanceof SQLAggregateExpr && (aggExpr = ((SQLAggregateExpr)expr).clone()).getArguments().size() == 1 && aggExpr.methodNameHashCode64() == FnvHash.Constants.COUNT) {
                SQLExpr arg = aggExpr.getArguments().get(0);
                ExprReplaceVisitor replaceVisitor = new ExprReplaceVisitor(x, subQuery);
                arg.accept(replaceVisitor);
                if (replaceVisitor.repalcedFailCount > 0) {
                    return false;
                }
                aggItem = new SQLSelectItem(aggExpr, selectList.get(0).getAlias());
            }
        }
        if (!allColumnMatched && aggItem == null && (subSelectList = subQuery.getSelectList()).size() >= selectList.size()) {
            boolean match = true;
            for (int i = 0; i < selectList.size(); ++i) {
                SQLExpr selectItemExpr = selectList.get(i).getExpr();
                SQLSelectItem subSelectItem = subSelectList.get(i);
                if (selectItemExpr instanceof SQLIdentifierExpr || selectItemExpr instanceof SQLPropertyExpr) {
                    long subSelectItemHashCoe;
                    long nameHashCode64 = ((SQLName)selectItemExpr).nameHashCode64();
                    if (nameHashCode64 == (subSelectItemHashCoe = FnvHash.hashCode64(subSelectItem.computeAlias()))) continue;
                    match = false;
                    break;
                }
                match = false;
                break;
            }
            if (match) {
                allColumnMatched = true;
            }
        }
        SQLExpr where2 = null;
        if (x.getWhere() != null) {
            where2 = x.getWhere().clone();
            ExprReplaceVisitor whereVisitor = new ExprReplaceVisitor(x, subQuery);
            where2.accept(whereVisitor);
            if (whereVisitor.repalcedFailCount > 0) {
                return false;
            }
        }
        if (allColumnMatched || aggItem != null) {
            SQLObject parent;
            SQLSelectQueryBlock queryBlock = subQuery.clone();
            if (aggItem != null) {
                SQLAggregateExpr aggregateExpr = (SQLAggregateExpr)aggItem.getExpr();
                List<SQLSelectItem> subSelectList2 = queryBlock.getSelectList();
                if (aggregateExpr.getArguments().size() == 1 && aggregateExpr.getArguments().get(0) instanceof SQLAllColumnExpr) {
                    aggregateExpr.getArguments().clear();
                    for (int i = 0; i < subSelectList2.size(); ++i) {
                        aggregateExpr.addArgument(subSelectList2.get(i).getExpr());
                    }
                }
                subSelectList2.clear();
                queryBlock.addSelectItem(aggItem);
                if (queryBlock.getDistionOption() == 2) {
                    queryBlock.setDistionOption(0);
                    aggregateExpr.setOption(SQLAggregateOption.DISTINCT);
                }
            }
            queryBlock.addOrderBy(x.getOrderBy());
            final AtomicBoolean aggregate = new AtomicBoolean();
            if (queryBlock.getGroupBy() != null) {
                aggregate.set(true);
            }
            if (aggregate.get() && where2 != null) {
                SQLASTVisitorAdapter v = new SQLASTVisitorAdapter(){

                    @Override
                    public boolean visit(SQLAggregateExpr x) {
                        aggregate.set(true);
                        return false;
                    }
                };
                where2.accept(v);
            }
            if (aggregate.get()) {
                queryBlock.addHaving(where2);
            } else {
                queryBlock.addWhere(where2);
            }
            SQLLimit limit = x.getLimit();
            if (limit != null) {
                if (queryBlock.getLimit() == null) {
                    queryBlock.setLimit(limit);
                } else {
                    return false;
                }
            }
            if ((parent = x.getParent()) instanceof SQLSelect) {
                SQLSelect select = (SQLSelect)x.getParent();
                select.setQuery(queryBlock);
                queryBlock.accept(this);
            } else if (parent instanceof SQLUnionQuery) {
                SQLUnionQuery union = (SQLUnionQuery)x.getParent();
                if (union.getLeft() == x) {
                    union.setLeft(queryBlock);
                } else {
                    union.setRight(queryBlock);
                }
                queryBlock.accept(this);
            }
        }
        return false;
    }

    class ExprReplaceVisitor
    extends SQLASTVisitorAdapter {
        private final SQLSelectQueryBlock queryBlock;
        private final SQLSelectQueryBlock subQueryBlock;
        private int repalcedFailCount = 0;

        public ExprReplaceVisitor(SQLSelectQueryBlock queryBlock, SQLSelectQueryBlock subQueryBlock) {
            this.queryBlock = queryBlock;
            this.subQueryBlock = subQueryBlock;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            SQLSelectItem selectItem = this.subQueryBlock.findSelectItem(x.nameHashCode64());
            if (selectItem == null) {
                ++this.repalcedFailCount;
                return false;
            }
            if (!SQLUtils.replaceInParent(x, selectItem.getExpr().clone())) {
                ++this.repalcedFailCount;
            }
            return false;
        }

        @Override
        public boolean visit(SQLPropertyExpr x) {
            if (!(x.getOwner() instanceof SQLIdentifierExpr)) {
                ++this.repalcedFailCount;
                return false;
            }
            SQLIdentifierExpr owner = (SQLIdentifierExpr)x.getOwner();
            if (this.queryBlock.getFrom().aliasHashCode64() != owner.nameHashCode64()) {
                ++this.repalcedFailCount;
                return false;
            }
            if (x.getName().equals("*")) {
                if (!SQLUtils.replaceInParent(x, new SQLAllColumnExpr())) {
                    ++this.repalcedFailCount;
                }
                return false;
            }
            SQLSelectItem selectItem = this.subQueryBlock.findSelectItem(x.nameHashCode64());
            if (selectItem == null) {
                ++this.repalcedFailCount;
                return false;
            }
            if (!SQLUtils.replaceInParent(x, selectItem.getExpr().clone())) {
                ++this.repalcedFailCount;
            }
            return false;
        }
    }
}

