/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer.visitor;

import com.alibaba.fastsql.funtions.FunctionDef;
import com.alibaba.fastsql.funtions.FunctionRepository;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCastExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLCharacterDataType;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitorAdapter;
import com.alibaba.fastsql.util.FnvHash;
import java.util.List;

public class TypeInference
extends SQLASTVisitorAdapter {
    private int replaceCount = 0;
    private FunctionRepository functionRepository = FunctionRepository.MY_SQL;

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        long hash = x.methodNameHashCode64();
        FunctionDef functionDef = this.findFunction(hash);
        List<SQLExpr> arguments = x.getArguments();
        if (functionDef != null) {
            for (int i = 0; i < arguments.size(); ++i) {
                SQLDataType paramType;
                SQLMethodInvokeExpr argFunction;
                FunctionDef paramFunctionDef;
                SQLDataType type = functionDef.getParemeterType(i);
                SQLExpr arg = arguments.get(i);
                if (type == null || FnvHash.Constants.CHAR != type.nameHashCode64()) continue;
                if (arg instanceof SQLIntegerExpr) {
                    String chars = ((SQLIntegerExpr)arg).getNumber().toString();
                    SQLCharExpr charExpr = new SQLCharExpr(chars);
                    charExpr.setParent(x);
                    arguments.set(i, charExpr);
                    ++this.replaceCount;
                    continue;
                }
                if (!(arg instanceof SQLMethodInvokeExpr) || (paramFunctionDef = this.findFunction((argFunction = (SQLMethodInvokeExpr)arg).methodNameHashCode64())) == null || FnvHash.Constants.BIGINT != (paramType = paramFunctionDef.getReturnType()).nameHashCode64()) continue;
                SQLCastExpr castExpr = new SQLCastExpr(arg, new SQLCharacterDataType("CHAR"));
                castExpr.setParent(x);
                arguments.set(i, castExpr);
                ++this.replaceCount;
            }
        }
        return true;
    }

    public FunctionDef findFunction(long nameHash) {
        return this.functionRepository.find(nameHash);
    }
}

