/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.parser;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLConstraint;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLTableElement;
import com.alibaba.fastsql.sql.dialect.oracle.parser.OracleSelectParser;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLDDLParser;
import com.alibaba.fastsql.sql.parser.SQLExprParser;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;
import java.util.List;

public class SQLCreateTableParser
extends SQLDDLParser {
    public SQLCreateTableParser(String sql) {
        super(sql);
    }

    public SQLCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    public SQLCreateTableStatement parseCreateTable() {
        List<String> comments = null;
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            comments = this.lexer.readAndResetComments();
        }
        SQLCreateTableStatement stmt = this.parseCreateTable(true);
        if (comments != null) {
            stmt.addBeforeComment(comments);
        }
        return stmt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SQLCreateTableStatement parseCreateTable(boolean acceptCreate) {
        SQLCreateTableStatement createTable = this.newCreateStatement();
        if (acceptCreate) {
            if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
                createTable.addBeforeComment(this.lexer.readAndResetComments());
            }
            this.accept(Token.CREATE);
        }
        if (this.lexer.identifierEquals("GLOBAL")) {
            this.lexer.nextToken();
            if (!this.lexer.identifierEquals("TEMPORARY")) throw new ParserException("syntax error " + this.lexer.info());
            this.lexer.nextToken();
            createTable.setType(SQLCreateTableStatement.Type.GLOBAL_TEMPORARY);
        } else if (this.lexer.token == Token.IDENTIFIER && this.lexer.stringVal().equalsIgnoreCase("LOCAL")) {
            this.lexer.nextToken();
            if (this.lexer.token != Token.IDENTIFIER || !this.lexer.stringVal().equalsIgnoreCase("TEMPORAY")) throw new ParserException("syntax error. " + this.lexer.info());
            this.lexer.nextToken();
            createTable.setType(SQLCreateTableStatement.Type.LOCAL_TEMPORARY);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DIMENSION)) {
            this.lexer.nextToken();
            createTable.setDimemsion(true);
        }
        this.accept(Token.TABLE);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            createTable.setIfNotExiists(true);
        }
        createTable.setName(this.exprParser.name());
        if (this.lexer.token == Token.LPAREN) {
            this.lexer.nextToken();
            do {
                SQLColumnDefinition column;
                Token token;
                if ((token = this.lexer.token) == Token.IDENTIFIER && this.lexer.stringVal().equalsIgnoreCase("SUPPLEMENTAL") && DbType.oracle == this.dbType) {
                    this.parseCreateTableSupplementalLogingProps(createTable);
                } else if (token == Token.IDENTIFIER || token == Token.LITERAL_ALIAS) {
                    column = this.exprParser.parseColumn();
                    createTable.getTableElementList().add(column);
                } else if (token == Token.PRIMARY || token == Token.UNIQUE || token == Token.CHECK || token == Token.CONSTRAINT || token == Token.FOREIGN) {
                    SQLConstraint constraint = this.exprParser.parseConstaint();
                    constraint.setParent(createTable);
                    createTable.getTableElementList().add((SQLTableElement)((Object)constraint));
                } else {
                    if (token == Token.TABLESPACE) {
                        throw new ParserException("TODO " + this.lexer.info());
                    }
                    column = this.exprParser.parseColumn();
                    createTable.getTableElementList().add(column);
                }
                if (this.lexer.token != Token.COMMA) break;
                this.lexer.nextToken();
            } while (this.lexer.token != Token.RPAREN);
            this.accept(Token.RPAREN);
            if (this.lexer.identifierEquals(FnvHash.Constants.INHERITS)) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                SQLName inherits = this.exprParser.name();
                createTable.setInherits(new SQLExprTableSource(inherits));
                this.accept(Token.RPAREN);
            }
        }
        if (this.lexer.token == Token.AS) {
            this.lexer.nextToken();
            SQLSelect select = null;
            select = DbType.oracle == this.dbType ? new OracleSelectParser(this.exprParser).select() : this.createSQLSelectParser().select();
            createTable.setSelect(select);
        }
        if (this.lexer.token != Token.WITH || DbType.postgresql != this.dbType) return createTable;
        this.lexer.nextToken();
        this.accept(Token.LPAREN);
        while (true) {
            String name = this.lexer.stringVal();
            this.lexer.nextToken();
            this.accept(Token.EQ);
            SQLExpr value = this.exprParser.expr();
            value.setParent(createTable);
            createTable.getTableOptions().put(name, value);
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        return createTable;
    }

    protected void parseCreateTableSupplementalLogingProps(SQLCreateTableStatement stmt) {
        throw new ParserException("TODO " + this.lexer.info());
    }

    @Override
    protected SQLCreateTableStatement newCreateStatement() {
        return new SQLCreateTableStatement(this.getDbType());
    }
}

