/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.parser;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.ads.parser.AdsStatementParser;
import com.alibaba.fastsql.sql.dialect.db2.ast.stmt.DB2SelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.db2.parser.DB2ExprParser;
import com.alibaba.fastsql.sql.dialect.db2.parser.DB2Lexer;
import com.alibaba.fastsql.sql.dialect.db2.parser.DB2StatementParser;
import com.alibaba.fastsql.sql.dialect.h2.parser.H2ExprParser;
import com.alibaba.fastsql.sql.dialect.h2.parser.H2Lexer;
import com.alibaba.fastsql.sql.dialect.h2.parser.H2StatementParser;
import com.alibaba.fastsql.sql.dialect.hive.parser.HiveExprParser;
import com.alibaba.fastsql.sql.dialect.hive.parser.HiveStatementParser;
import com.alibaba.fastsql.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.mysql.parser.MySqlExprParser;
import com.alibaba.fastsql.sql.dialect.mysql.parser.MySqlLexer;
import com.alibaba.fastsql.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.odps.parser.OdpsExprParser;
import com.alibaba.fastsql.sql.dialect.odps.parser.OdpsLexer;
import com.alibaba.fastsql.sql.dialect.odps.parser.OdpsStatementParser;
import com.alibaba.fastsql.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.oracle.parser.OracleExprParser;
import com.alibaba.fastsql.sql.dialect.oracle.parser.OracleLexer;
import com.alibaba.fastsql.sql.dialect.oracle.parser.OracleStatementParser;
import com.alibaba.fastsql.sql.dialect.phoenix.parser.PhoenixExprParser;
import com.alibaba.fastsql.sql.dialect.phoenix.parser.PhoenixLexer;
import com.alibaba.fastsql.sql.dialect.phoenix.parser.PhoenixStatementParser;
import com.alibaba.fastsql.sql.dialect.postgresql.ast.stmt.PGSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.postgresql.parser.PGExprParser;
import com.alibaba.fastsql.sql.dialect.postgresql.parser.PGLexer;
import com.alibaba.fastsql.sql.dialect.postgresql.parser.PGSQLStatementParser;
import com.alibaba.fastsql.sql.dialect.presto.parser.PrestoExprParser;
import com.alibaba.fastsql.sql.dialect.presto.parser.PrestoLexer;
import com.alibaba.fastsql.sql.dialect.presto.parser.PrestoStatementParser;
import com.alibaba.fastsql.sql.dialect.sqlserver.ast.SQLServerSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.sqlserver.parser.SQLServerExprParser;
import com.alibaba.fastsql.sql.dialect.sqlserver.parser.SQLServerStatementParser;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.SQLExprParser;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.SQLStatementParser;
import com.alibaba.fastsql.sql.parser.SQLType;

public class SQLParserUtils {
    public static SQLStatementParser createSQLStatementParser(String sql, DbType dbType) {
        SQLParserFeature[] features = DbType.odps == dbType || DbType.mysql == dbType ? new SQLParserFeature[]{SQLParserFeature.KeepComments} : new SQLParserFeature[]{};
        return SQLParserUtils.createSQLStatementParser(sql, dbType, features);
    }

    public static SQLStatementParser createSQLStatementParser(String sql, DbType dbType, boolean keepComments) {
        SQLParserFeature[] features = keepComments ? new SQLParserFeature[]{SQLParserFeature.KeepComments} : new SQLParserFeature[]{};
        return SQLParserUtils.createSQLStatementParser(sql, dbType, features);
    }

    public static SQLStatementParser createSQLStatementParser(String sql, String dbType, SQLParserFeature ... features) {
        return SQLParserUtils.createSQLStatementParser(sql, dbType == null ? null : DbType.valueOf(dbType), features);
    }

    public static SQLStatementParser createSQLStatementParser(String sql, DbType dbType, SQLParserFeature ... features) {
        if (dbType == null) {
            dbType = DbType.other;
        }
        switch (dbType) {
            case oracle: {
                return new OracleStatementParser(sql, features);
            }
            case mysql: 
            case mariadb: 
            case elastic_search: {
                return new MySqlStatementParser(sql, features);
            }
            case postgresql: 
            case edb: {
                return new PGSQLStatementParser(sql, features);
            }
            case sqlserver: 
            case jtds: {
                return new SQLServerStatementParser(sql);
            }
            case h2: {
                return new H2StatementParser(sql, features);
            }
            case db2: {
                return new DB2StatementParser(sql, features);
            }
            case odps: {
                return new OdpsStatementParser(sql, features);
            }
            case phoenix: {
                return new PhoenixStatementParser(sql);
            }
            case hive: {
                return new HiveStatementParser(sql, features);
            }
            case presto: {
                return new PrestoStatementParser(sql);
            }
            case ads: {
                return new AdsStatementParser(sql);
            }
        }
        return new SQLStatementParser(sql, dbType);
    }

    public static SQLExprParser createExprParser(String sql, DbType dbType, SQLParserFeature ... features) {
        if (dbType == null) {
            dbType = DbType.other;
        }
        switch (dbType) {
            case oracle: {
                return new OracleExprParser(sql, features);
            }
            case mysql: 
            case mariadb: {
                return new MySqlExprParser(sql, features);
            }
            case h2: {
                return new H2ExprParser(sql, features);
            }
            case postgresql: 
            case edb: {
                return new PGExprParser(sql, features);
            }
            case sqlserver: 
            case jtds: {
                return new SQLServerExprParser(sql, features);
            }
            case db2: {
                return new DB2ExprParser(sql, features);
            }
            case odps: {
                return new OdpsExprParser(sql, features);
            }
            case phoenix: {
                return new PhoenixExprParser(sql, features);
            }
            case presto: {
                return new PrestoExprParser(sql, features);
            }
            case hive: {
                return new HiveExprParser(sql, features);
            }
        }
        return new SQLExprParser(sql, dbType, features);
    }

    public static Lexer createLexer(String sql, DbType dbType) {
        return SQLParserUtils.createLexer(sql, dbType, new SQLParserFeature[0]);
    }

    public static Lexer createLexer(String sql, DbType dbType, SQLParserFeature ... features) {
        if (dbType == null) {
            dbType = DbType.other;
        }
        switch (dbType) {
            case oracle: {
                return new OracleLexer(sql);
            }
            case mysql: 
            case mariadb: {
                return new MySqlLexer(sql);
            }
            case h2: {
                return new H2Lexer(sql);
            }
            case postgresql: 
            case edb: {
                return new PGLexer(sql, new SQLParserFeature[0]);
            }
            case db2: {
                return new DB2Lexer(sql);
            }
            case odps: {
                return new OdpsLexer(sql, new SQLParserFeature[0]);
            }
            case phoenix: {
                return new PhoenixLexer(sql, new SQLParserFeature[0]);
            }
            case presto: {
                return new PrestoLexer(sql, new SQLParserFeature[0]);
            }
        }
        return new Lexer(sql, null, dbType);
    }

    public static SQLSelectQueryBlock createSelectQueryBlock(DbType dbType) {
        if (dbType == null) {
            dbType = DbType.other;
        }
        switch (dbType) {
            case mysql: {
                return new MySqlSelectQueryBlock();
            }
            case oracle: {
                return new OracleSelectQueryBlock();
            }
            case db2: {
                return new DB2SelectQueryBlock();
            }
            case postgresql: {
                return new PGSelectQueryBlock();
            }
            case odps: {
                return new OdpsSelectQueryBlock();
            }
            case sqlserver: {
                return new SQLServerSelectQueryBlock();
            }
        }
        return new SQLSelectQueryBlock();
    }

    public static SQLType getSQLType(String sql, DbType dbType) {
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        return lexer.scanSQLType();
    }
}

