/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.parser;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLLimit;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.SQLOrderBy;
import com.alibaba.fastsql.sql.ast.SQLOrderingSpecification;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLDateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLRealExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLExprHint;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLLateralViewTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionOperator;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.fastsql.sql.dialect.db2.ast.stmt.DB2SelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.mysql.ast.expr.MySqlOrderingExpr;
import com.alibaba.fastsql.sql.parser.EOFParserException;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLExprParser;
import com.alibaba.fastsql.sql.parser.SQLParser;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.SQLSelectListCache;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;
import com.alibaba.fastsql.util.StringUtils;
import java.util.List;

public class SQLSelectParser
extends SQLParser {
    protected SQLExprParser exprParser;
    protected SQLSelectListCache selectListCache;

    public SQLSelectParser(String sql) {
        super(sql);
    }

    public SQLSelectParser(Lexer lexer) {
        super(lexer);
    }

    public SQLSelectParser(SQLExprParser exprParser) {
        this(exprParser, null);
    }

    public SQLSelectParser(SQLExprParser exprParser, SQLSelectListCache selectListCache) {
        super(exprParser.getLexer(), exprParser.getDbType());
        this.exprParser = exprParser;
        this.selectListCache = selectListCache;
    }

    public SQLSelect select() {
        SQLSelect select = new SQLSelect();
        if (this.lexer.token == Token.WITH) {
            SQLWithSubqueryClause with = this.parseWith();
            select.setWithSubQuery(with);
        }
        SQLSelectQuery query = this.query(select);
        select.setQuery(query);
        SQLOrderBy orderBy = this.parseOrderBy();
        if (query instanceof SQLSelectQueryBlock) {
            SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)query;
            if (queryBlock.getOrderBy() == null) {
                queryBlock.setOrderBy(orderBy);
            } else {
                select.setOrderBy(orderBy);
            }
            if (orderBy != null) {
                this.parseFetchClause(queryBlock);
            }
        } else {
            select.setOrderBy(orderBy);
        }
        while (this.lexer.token == Token.HINT) {
            this.exprParser.parseHints(select.getHints());
        }
        return select;
    }

    protected SQLUnionQuery createSQLUnionQuery() {
        SQLUnionQuery union = new SQLUnionQuery();
        union.setDbType(this.dbType);
        return union;
    }

    public SQLUnionQuery unionRest(SQLUnionQuery union) {
        if (this.lexer.token == Token.ORDER) {
            SQLOrderBy orderBy = this.exprParser.parseOrderBy();
            union.setOrderBy(orderBy);
            return this.unionRest(union);
        }
        return union;
    }

    public SQLSelectQuery queryRest(SQLSelectQuery selectQuery) {
        return this.queryRest(selectQuery, true);
    }

    public SQLSelectQuery queryRest(SQLSelectQuery selectQuery, boolean acceptUnion) {
        if (!acceptUnion) {
            return selectQuery;
        }
        if (this.lexer.token == Token.UNION) {
            boolean paren;
            SQLUnionQuery union;
            this.lexer.nextToken();
            SQLUnionQuery parentUnion = null;
            if (selectQuery.getParent() instanceof SQLUnionQuery) {
                parentUnion = (SQLUnionQuery)selectQuery.getParent();
            }
            if ((union = this.createSQLUnionQuery()).getLeft() == null) {
                union.setLeft(selectQuery);
            }
            boolean bl = paren = this.lexer.token == Token.LPAREN;
            if (this.lexer.token == Token.ALL) {
                union.setOperator(SQLUnionOperator.UNION_ALL);
                this.lexer.nextToken();
            } else if (this.lexer.token == Token.DISTINCT) {
                union.setOperator(SQLUnionOperator.DISTINCT);
                this.lexer.nextToken();
            }
            SQLSelectQuery right = this.query(paren ? null : union, false);
            union.setRight(right);
            if (!paren) {
                SQLUnionQuery rightUnion;
                if (right instanceof SQLSelectQueryBlock) {
                    SQLSelectQueryBlock rightQuery = (SQLSelectQueryBlock)right;
                    SQLOrderBy orderBy = rightQuery.getOrderBy();
                    SQLLimit limit = rightQuery.getLimit();
                    if (orderBy != null && limit == null) {
                        union.setOrderBy(orderBy);
                        rightQuery.setOrderBy(null);
                    }
                } else if (right instanceof SQLUnionQuery && (rightUnion = (SQLUnionQuery)right).getOrderBy() != null) {
                    union.setOrderBy(rightUnion.getOrderBy());
                    rightUnion.setOrderBy(null);
                }
            }
            union = this.unionRest(union);
            return this.queryRest(union, true);
        }
        if (this.lexer.token == Token.EXCEPT) {
            this.lexer.nextToken();
            SQLUnionQuery union = new SQLUnionQuery();
            union.setLeft(selectQuery);
            union.setOperator(SQLUnionOperator.EXCEPT);
            SQLSelectQuery right = this.query(union, false);
            union.setRight(right);
            return union;
        }
        if (this.lexer.token == Token.INTERSECT) {
            this.lexer.nextToken();
            SQLUnionQuery union = new SQLUnionQuery();
            union.setLeft(selectQuery);
            union.setOperator(SQLUnionOperator.INTERSECT);
            SQLSelectQuery right = this.query();
            union.setRight(right);
            return union;
        }
        if (acceptUnion && this.lexer.token == Token.MINUS) {
            this.lexer.nextToken();
            SQLUnionQuery union = new SQLUnionQuery();
            union.setLeft(selectQuery);
            union.setOperator(SQLUnionOperator.MINUS);
            SQLSelectQuery right = this.query();
            union.setRight(right);
            return union;
        }
        return selectQuery;
    }

    private void setToLeft(SQLSelectQuery selectQuery, SQLUnionQuery parentUnion, SQLUnionQuery union, SQLSelectQuery right) {
        SQLUnionOperator operator = union.getOperator();
        if (union.getLeft() instanceof SQLUnionQuery) {
            SQLUnionQuery left = (SQLUnionQuery)union.getLeft();
            while (left.getLeft() instanceof SQLUnionQuery) {
                left = (SQLUnionQuery)left.getLeft();
            }
            left.setLeft(new SQLUnionQuery(parentUnion.getLeft(), parentUnion.getOperator(), left.getLeft()));
            parentUnion.setLeft(union.getLeft());
            parentUnion.setRight(union.getRight());
        } else {
            parentUnion.setRight(right);
            union.setLeft(parentUnion.getLeft());
            parentUnion.setLeft(union);
            union.setRight(selectQuery);
            union.setOperator(parentUnion.getOperator());
            parentUnion.setOperator(operator);
        }
    }

    public SQLSelectQuery query() {
        return this.query(null, true);
    }

    public SQLSelectQuery query(SQLObject parent) {
        return this.query(parent, true);
    }

    public SQLSelectQuery query(SQLObject parent, boolean acceptUnion) {
        if (this.lexer.token == Token.LPAREN) {
            this.lexer.nextToken();
            SQLSelectQuery select = this.query();
            this.accept(Token.RPAREN);
            return this.queryRest(select, acceptUnion);
        }
        SQLSelectQueryBlock queryBlock = new SQLSelectQueryBlock();
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            queryBlock.addBeforeComment(this.lexer.readAndResetComments());
        }
        this.accept(Token.SELECT);
        if (this.lexer.token() == Token.HINT) {
            this.exprParser.parseHints(queryBlock.getHints());
        }
        if (this.lexer.token == Token.COMMENT) {
            this.lexer.nextToken();
        }
        if (DbType.informix == this.dbType) {
            if (this.lexer.identifierEquals(FnvHash.Constants.SKIP)) {
                this.lexer.nextToken();
                SQLExpr offset = this.exprParser.primary();
                queryBlock.setOffset(offset);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.FIRST)) {
                this.lexer.nextToken();
                SQLExpr first = this.exprParser.primary();
                queryBlock.setFirst(first);
            }
        }
        if (this.lexer.token == Token.DISTINCT) {
            queryBlock.setDistionOption(2);
            this.lexer.nextToken();
        } else if (this.lexer.token == Token.UNIQUE) {
            queryBlock.setDistionOption(3);
            this.lexer.nextToken();
        } else if (this.lexer.token == Token.ALL) {
            queryBlock.setDistionOption(1);
            this.lexer.nextToken();
        }
        this.parseSelectList(queryBlock);
        this.parseFrom(queryBlock);
        this.parseWhere(queryBlock);
        this.parseGroupBy(queryBlock);
        this.parseSortBy(queryBlock);
        this.parseFetchClause(queryBlock);
        return this.queryRest(queryBlock, acceptUnion);
    }

    protected void withSubquery(SQLSelect select) {
        if (this.lexer.token == Token.WITH) {
            this.lexer.nextToken();
            SQLWithSubqueryClause withQueryClause = new SQLWithSubqueryClause();
            if (this.lexer.token == Token.RECURSIVE || this.lexer.identifierEquals(FnvHash.Constants.RECURSIVE)) {
                this.lexer.nextToken();
                withQueryClause.setRecursive(true);
            }
            while (true) {
                SQLWithSubqueryClause.Entry entry = new SQLWithSubqueryClause.Entry();
                entry.setParent(withQueryClause);
                String alias = this.lexer.stringVal();
                this.lexer.nextToken();
                entry.setAlias(alias);
                if (this.lexer.token == Token.LPAREN) {
                    this.lexer.nextToken();
                    this.exprParser.names(entry.getColumns());
                    this.accept(Token.RPAREN);
                }
                this.accept(Token.AS);
                this.accept(Token.LPAREN);
                entry.setSubQuery(this.select());
                this.accept(Token.RPAREN);
                withQueryClause.addEntry(entry);
                if (this.lexer.token != Token.COMMA) break;
                this.lexer.nextToken();
            }
            select.setWithSubQuery(withQueryClause);
        }
    }

    public SQLWithSubqueryClause parseWith() {
        this.accept(Token.WITH);
        SQLWithSubqueryClause withQueryClause = new SQLWithSubqueryClause();
        if (this.lexer.token == Token.RECURSIVE || this.lexer.identifierEquals(FnvHash.Constants.RECURSIVE)) {
            this.lexer.nextToken();
            withQueryClause.setRecursive(true);
        }
        while (true) {
            SQLWithSubqueryClause.Entry entry = new SQLWithSubqueryClause.Entry();
            entry.setParent(withQueryClause);
            String alias = this.lexer.stringVal();
            this.lexer.nextToken();
            entry.setAlias(alias);
            if (this.lexer.token == Token.LPAREN) {
                this.lexer.nextToken();
                this.exprParser.names(entry.getColumns());
                this.accept(Token.RPAREN);
            }
            this.accept(Token.AS);
            this.accept(Token.LPAREN);
            switch (this.lexer.token) {
                case SELECT: {
                    entry.setSubQuery(this.select());
                    break;
                }
            }
            this.accept(Token.RPAREN);
            withQueryClause.addEntry(entry);
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return withQueryClause;
    }

    public void parseWhere(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token == Token.WHERE) {
            SQLExpr where;
            this.lexer.nextTokenIdent();
            List<String> beforeComments = null;
            if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
                beforeComments = this.lexer.readAndResetComments();
            }
            if (this.lexer.token == Token.IDENTIFIER) {
                SQLExpr identExpr;
                String ident = this.lexer.stringVal();
                long hash_lower = this.lexer.hash_lower();
                this.lexer.nextTokenEq();
                if (this.lexer.token == Token.LITERAL_CHARS) {
                    String literal = this.lexer.stringVal;
                    if (hash_lower == FnvHash.Constants.TIMESTAMP) {
                        identExpr = new SQLTimestampExpr(literal);
                        this.lexer.nextToken();
                    } else if (hash_lower == FnvHash.Constants.DATE) {
                        identExpr = new SQLDateExpr(literal);
                        this.lexer.nextToken();
                    } else if (hash_lower == FnvHash.Constants.REAL) {
                        identExpr = new SQLRealExpr(Float.valueOf(Float.parseFloat(literal)));
                        this.lexer.nextToken();
                    } else {
                        identExpr = new SQLIdentifierExpr(ident, hash_lower);
                    }
                } else {
                    identExpr = new SQLIdentifierExpr(ident, hash_lower);
                }
                if (this.lexer.token == Token.DOT) {
                    identExpr = this.exprParser.primaryRest(identExpr);
                }
                if (this.lexer.token == Token.EQ) {
                    SQLExpr rightExp;
                    this.lexer.nextToken();
                    try {
                        rightExp = this.exprParser.bitOr();
                    }
                    catch (EOFParserException e) {
                        throw new ParserException("EOF, " + ident + "=", e);
                    }
                    where = new SQLBinaryOpExpr(identExpr, SQLBinaryOperator.Equality, rightExp, this.dbType);
                    if (this.lexer.token == Token.IS) {
                        where = this.exprParser.relationalRest(where);
                    }
                    where = this.exprParser.andRest(where);
                    where = this.exprParser.orRest(where);
                } else {
                    identExpr = this.exprParser.primaryRest(identExpr);
                    where = this.exprParser.exprRest(identExpr);
                }
            } else {
                where = this.exprParser.expr();
            }
            if (beforeComments != null) {
                where.addBeforeComment(beforeComments);
            }
            if (this.lexer.hasComment() && this.lexer.isKeepComments() && this.lexer.token != Token.INSERT) {
                where.addAfterComment(this.lexer.readAndResetComments());
            }
            queryBlock.setWhere(where);
        }
    }

    protected void parseSortBy(SQLSelectQueryBlock queryBlock) {
    }

    protected void parseGroupBy(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token == Token.GROUP) {
            this.lexer.nextTokenBy();
            this.accept(Token.BY);
            SQLSelectGroupByClause groupBy = new SQLSelectGroupByClause();
            if (this.lexer.identifierEquals(FnvHash.Constants.ROLLUP)) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                groupBy.setWithRollUp(true);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.CUBE)) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                groupBy.setWithCube(true);
            }
            while (true) {
                SQLExpr item = this.parseGroupByItem();
                item.setParent(groupBy);
                groupBy.addItem(item);
                if (this.lexer.token != Token.COMMA) break;
                this.lexer.nextToken();
            }
            if (groupBy.isWithRollUp() || groupBy.isWithCube()) {
                this.accept(Token.RPAREN);
                groupBy.setParen(true);
            }
            if (this.lexer.token == Token.HAVING) {
                this.lexer.nextToken();
                SQLExpr having = this.exprParser.expr();
                groupBy.setHaving(having);
            }
            if (this.lexer.token == Token.WITH) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals(FnvHash.Constants.CUBE)) {
                    this.lexer.nextToken();
                    groupBy.setWithCube(true);
                } else if (this.lexer.identifierEquals(FnvHash.Constants.ROLLUP)) {
                    this.lexer.nextToken();
                    groupBy.setWithRollUp(true);
                } else if (this.lexer.identifierEquals(FnvHash.Constants.RS) && DbType.db2 == this.dbType) {
                    this.lexer.nextToken();
                    ((DB2SelectQueryBlock)queryBlock).setIsolation(DB2SelectQueryBlock.Isolation.RS);
                } else if (this.lexer.identifierEquals(FnvHash.Constants.RR) && DbType.db2 == this.dbType) {
                    this.lexer.nextToken();
                    ((DB2SelectQueryBlock)queryBlock).setIsolation(DB2SelectQueryBlock.Isolation.RR);
                } else if (this.lexer.identifierEquals(FnvHash.Constants.CS) && DbType.db2 == this.dbType) {
                    this.lexer.nextToken();
                    ((DB2SelectQueryBlock)queryBlock).setIsolation(DB2SelectQueryBlock.Isolation.CS);
                } else if (this.lexer.identifierEquals(FnvHash.Constants.UR) && DbType.db2 == this.dbType) {
                    this.lexer.nextToken();
                    ((DB2SelectQueryBlock)queryBlock).setIsolation(DB2SelectQueryBlock.Isolation.UR);
                } else {
                    throw new ParserException("TODO " + this.lexer.info());
                }
            }
            queryBlock.setGroupBy(groupBy);
        } else if (this.lexer.token == Token.HAVING) {
            this.lexer.nextToken();
            SQLSelectGroupByClause groupBy = new SQLSelectGroupByClause();
            groupBy.setHaving(this.exprParser.expr());
            if (this.lexer.token == Token.GROUP) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                while (true) {
                    SQLExpr item = this.parseGroupByItem();
                    item.setParent(groupBy);
                    groupBy.addItem(item);
                    if (this.lexer.token != Token.COMMA) break;
                    this.lexer.nextToken();
                }
            }
            if (this.lexer.token == Token.WITH) {
                this.lexer.nextToken();
                this.acceptIdentifier("ROLLUP");
                groupBy.setWithRollUp(true);
            }
            if (DbType.mysql == this.dbType && this.lexer.token == Token.DESC) {
                this.lexer.nextToken();
            }
            queryBlock.setGroupBy(groupBy);
        }
    }

    protected SQLExpr parseGroupByItem() {
        SQLExpr item = this.exprParser.expr();
        if (DbType.mysql == this.dbType) {
            if (this.lexer.token == Token.DESC) {
                this.lexer.nextToken();
                item = new MySqlOrderingExpr(item, SQLOrderingSpecification.DESC);
            } else if (this.lexer.token == Token.ASC) {
                this.lexer.nextToken();
                item = new MySqlOrderingExpr(item, SQLOrderingSpecification.ASC);
            }
        }
        return item;
    }

    protected void parseSelectList(SQLSelectQueryBlock queryBlock) {
        List<SQLSelectItem> selectList = queryBlock.getSelectList();
        while (true) {
            SQLSelectItem selectItem = this.exprParser.parseSelectItem();
            selectList.add(selectItem);
            selectItem.setParent(queryBlock);
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }

    public void parseFrom(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token != Token.FROM) {
            return;
        }
        this.lexer.nextToken();
        queryBlock.setFrom(this.parseTableSource());
    }

    public SQLTableSource parseTableSource() {
        if (this.lexer.token == Token.LPAREN) {
            SQLTableSource tableSource;
            this.lexer.nextToken();
            if (this.lexer.token == Token.SELECT || this.lexer.token == Token.WITH || this.lexer.token == Token.SEL) {
                SQLSelect select = this.select();
                this.accept(Token.RPAREN);
                SQLSelectQuery query = this.queryRest(select.getQuery(), true);
                tableSource = query instanceof SQLUnionQuery ? new SQLUnionQueryTableSource((SQLUnionQuery)query) : new SQLSubqueryTableSource(select);
            } else if (this.lexer.token == Token.LPAREN) {
                tableSource = this.parseTableSource();
                this.accept(Token.RPAREN);
            } else {
                tableSource = this.parseTableSource();
                this.accept(Token.RPAREN);
            }
            return this.parseTableSourceRest(tableSource);
        }
        if (this.lexer.token == Token.SELECT) {
            throw new ParserException("TODO " + this.lexer.info());
        }
        SQLExprTableSource tableReference = new SQLExprTableSource();
        this.parseTableSourceQueryTableExpr(tableReference);
        SQLTableSource tableSrc = this.parseTableSourceRest(tableReference);
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            tableSrc.addAfterComment(this.lexer.readAndResetComments());
        }
        return tableSrc;
    }

    protected void parseTableSourceQueryTableExpr(SQLExprTableSource tableReference) {
        if (this.lexer.token == Token.LITERAL_ALIAS || this.lexer.token == Token.IDENTIFIED || this.lexer.token == Token.LITERAL_CHARS) {
            tableReference.setExpr(this.exprParser.name());
            return;
        }
        tableReference.setExpr(this.expr());
    }

    protected SQLTableSource primaryTableSourceRest(SQLTableSource tableSource) {
        return tableSource;
    }

    protected SQLTableSource parseTableSourceRest(SQLTableSource tableSource) {
        boolean natural;
        String alias;
        long hash;
        Token token;
        if ((tableSource.getAlias() == null || tableSource.getAlias().length() == 0) && (token = this.lexer.token) != Token.LEFT && token != Token.RIGHT && token != Token.FULL && token != Token.OUTER && (token != Token.IDENTIFIER || (hash = this.lexer.hash_lower()) != FnvHash.Constants.STRAIGHT_JOIN && hash != FnvHash.Constants.CROSS) && (alias = this.tableAlias()) != null) {
            if (this.isEnabled(SQLParserFeature.IgnoreNameQuotes) && alias.length() > 1) {
                alias = StringUtils.removeNameQuotes(alias);
            }
            tableSource.setAlias(alias);
            if (this.lexer.token == Token.WHERE) {
                return tableSource;
            }
            return this.parseTableSourceRest(tableSource);
        }
        SQLJoinTableSource.JoinType joinType = null;
        boolean bl = natural = this.lexer.identifierEquals(FnvHash.Constants.NATURAL) && DbType.mysql == this.dbType;
        if (natural) {
            this.lexer.nextToken();
        }
        if (this.lexer.token == Token.LEFT) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.SEMI)) {
                this.lexer.nextToken();
                joinType = SQLJoinTableSource.JoinType.LEFT_SEMI_JOIN;
            } else if (this.lexer.identifierEquals(FnvHash.Constants.ANTI)) {
                this.lexer.nextToken();
                joinType = SQLJoinTableSource.JoinType.LEFT_ANTI_JOIN;
            } else if (this.lexer.token == Token.OUTER) {
                this.lexer.nextToken();
                joinType = SQLJoinTableSource.JoinType.LEFT_OUTER_JOIN;
            } else {
                joinType = SQLJoinTableSource.JoinType.LEFT_OUTER_JOIN;
            }
            this.accept(Token.JOIN);
        } else if (this.lexer.token == Token.RIGHT) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.OUTER) {
                this.lexer.nextToken();
            }
            this.accept(Token.JOIN);
            joinType = SQLJoinTableSource.JoinType.RIGHT_OUTER_JOIN;
        } else if (this.lexer.token == Token.FULL) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.OUTER) {
                this.lexer.nextToken();
            }
            this.accept(Token.JOIN);
            joinType = SQLJoinTableSource.JoinType.FULL_OUTER_JOIN;
        } else if (this.lexer.token == Token.INNER) {
            this.lexer.nextToken();
            this.accept(Token.JOIN);
            joinType = SQLJoinTableSource.JoinType.INNER_JOIN;
        } else if (this.lexer.token == Token.JOIN) {
            this.lexer.nextToken();
            joinType = SQLJoinTableSource.JoinType.JOIN;
        } else if (this.lexer.token == Token.COMMA) {
            this.lexer.nextToken();
            joinType = SQLJoinTableSource.JoinType.COMMA;
        } else if (this.lexer.identifierEquals(FnvHash.Constants.STRAIGHT_JOIN)) {
            this.lexer.nextToken();
            joinType = SQLJoinTableSource.JoinType.STRAIGHT_JOIN;
        } else if (this.lexer.identifierEquals(FnvHash.Constants.CROSS)) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.JOIN) {
                this.lexer.nextToken();
                joinType = SQLJoinTableSource.JoinType.CROSS_JOIN;
            } else if (this.lexer.identifierEquals(FnvHash.Constants.APPLY)) {
                this.lexer.nextToken();
                joinType = SQLJoinTableSource.JoinType.CROSS_APPLY;
            }
        } else if (this.lexer.token == Token.OUTER) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.APPLY)) {
                this.lexer.nextToken();
                joinType = SQLJoinTableSource.JoinType.OUTER_APPLY;
            }
        }
        if (joinType != null) {
            Lexer.SavePoint savePoint;
            SQLTableSource rightTableSource;
            SQLJoinTableSource join = new SQLJoinTableSource();
            join.setLeft(tableSource);
            join.setJoinType(joinType);
            if (this.lexer.token == Token.LPAREN) {
                this.lexer.nextToken();
                if (this.lexer.token == Token.SELECT) {
                    SQLSelect select = this.select();
                    rightTableSource = new SQLSubqueryTableSource(select);
                } else {
                    rightTableSource = this.parseTableSource();
                }
                this.accept(Token.RPAREN);
            } else {
                SQLExpr expr = this.expr();
                rightTableSource = new SQLExprTableSource(expr);
                this.primaryTableSourceRest(rightTableSource);
            }
            if (this.lexer.token == Token.USING || this.lexer.identifierEquals(FnvHash.Constants.USING)) {
                savePoint = this.lexer.mark();
                this.lexer.nextToken();
                if (this.lexer.token == Token.LPAREN) {
                    this.lexer.nextToken();
                    join.setRight(rightTableSource);
                    this.exprParser.exprList(join.getUsing(), join);
                    this.accept(Token.RPAREN);
                } else {
                    if (this.lexer.token == Token.IDENTIFIER) {
                        this.lexer.reset(savePoint);
                        join.setRight(rightTableSource);
                        return join;
                    }
                    join.setAlias(this.tableAlias());
                }
            } else {
                rightTableSource.setAlias(this.tableAlias());
                this.primaryTableSourceRest(rightTableSource);
            }
            if (this.lexer.token == Token.WITH) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                while (true) {
                    SQLExpr hintExpr = this.expr();
                    SQLExprHint hint = new SQLExprHint(hintExpr);
                    hint.setParent(tableSource);
                    rightTableSource.getHints().add(hint);
                    if (this.lexer.token != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
            join.setRight(rightTableSource);
            if (!natural && tableSource.aliasHashCode64() == FnvHash.Constants.NATURAL && DbType.mysql == this.dbType) {
                tableSource.setAlias(null);
                natural = true;
            }
            join.setNatural(natural);
            if (this.lexer.token == Token.ON) {
                this.lexer.nextToken();
                join.setCondition(this.expr());
            } else if (this.lexer.token == Token.USING || this.lexer.identifierEquals(FnvHash.Constants.USING)) {
                savePoint = this.lexer.mark();
                this.lexer.nextToken();
                if (this.lexer.token == Token.LPAREN) {
                    this.lexer.nextToken();
                    this.exprParser.exprList(join.getUsing(), join);
                    this.accept(Token.RPAREN);
                } else {
                    this.lexer.reset(savePoint);
                }
            }
            return this.parseTableSourceRest(join);
        }
        if (tableSource.aliasHashCode64() == FnvHash.Constants.LATERAL && this.lexer.token() == Token.VIEW) {
            return this.parseLateralView(tableSource);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LATERAL)) {
            this.lexer.nextToken();
            return this.parseLateralView(tableSource);
        }
        return tableSource;
    }

    public SQLExpr expr() {
        return this.exprParser.expr();
    }

    public SQLOrderBy parseOrderBy() {
        return this.exprParser.parseOrderBy();
    }

    public void acceptKeyword(String ident) {
        if (this.lexer.token != Token.IDENTIFIER || !ident.equalsIgnoreCase(this.lexer.stringVal())) {
            this.setErrorEndPos(this.lexer.pos());
            throw new ParserException("syntax error, expect " + ident + ", actual " + (Object)((Object)this.lexer.token) + ", " + this.lexer.info());
        }
        this.lexer.nextToken();
    }

    public void parseFetchClause(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token == Token.LIMIT) {
            SQLLimit limit = this.exprParser.parseLimit();
            queryBlock.setLimit(limit);
            return;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.OFFSET) || this.lexer.token == Token.OFFSET) {
            this.lexer.nextToken();
            SQLExpr offset = this.exprParser.primary();
            queryBlock.setOffset(offset);
            if (this.lexer.identifierEquals(FnvHash.Constants.ROW) || this.lexer.identifierEquals(FnvHash.Constants.ROWS)) {
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token == Token.FETCH) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.FIRST || this.lexer.identifierEquals(FnvHash.Constants.NEXT)) {
                this.lexer.nextToken();
            } else {
                this.acceptIdentifier("FIRST");
            }
            SQLExpr first = this.exprParser.primary();
            queryBlock.setFirst(first);
            if (this.lexer.identifierEquals(FnvHash.Constants.ROW) || this.lexer.identifierEquals(FnvHash.Constants.ROWS)) {
                this.lexer.nextToken();
            }
            if (this.lexer.token == Token.ONLY) {
                this.lexer.nextToken();
            } else {
                this.acceptIdentifier("ONLY");
            }
        }
    }

    protected void parseHierachical(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token == Token.CONNECT || this.lexer.identifierEquals(FnvHash.Constants.CONNECT)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            if (this.lexer.token == Token.PRIOR || this.lexer.identifierEquals(FnvHash.Constants.PRIOR)) {
                this.lexer.nextToken();
                queryBlock.setPrior(true);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.NOCYCLE)) {
                queryBlock.setNoCycle(true);
                this.lexer.nextToken();
                if (this.lexer.token == Token.PRIOR) {
                    this.lexer.nextToken();
                    queryBlock.setPrior(true);
                }
            }
            queryBlock.setConnectBy(this.exprParser.expr());
        }
        if (this.lexer.token == Token.START || this.lexer.identifierEquals(FnvHash.Constants.START)) {
            this.lexer.nextToken();
            this.accept(Token.WITH);
            queryBlock.setStartWith(this.exprParser.expr());
        }
        if (this.lexer.token == Token.CONNECT || this.lexer.identifierEquals(FnvHash.Constants.CONNECT)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            if (this.lexer.token == Token.PRIOR || this.lexer.identifierEquals(FnvHash.Constants.PRIOR)) {
                this.lexer.nextToken();
                queryBlock.setPrior(true);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.NOCYCLE)) {
                queryBlock.setNoCycle(true);
                this.lexer.nextToken();
                if (this.lexer.token == Token.PRIOR || this.lexer.identifierEquals(FnvHash.Constants.PRIOR)) {
                    this.lexer.nextToken();
                    queryBlock.setPrior(true);
                }
            }
            queryBlock.setConnectBy(this.exprParser.expr());
        }
    }

    protected SQLTableSource parseLateralView(SQLTableSource tableSource) {
        this.accept(Token.VIEW);
        if ("LATERAL".equalsIgnoreCase(tableSource.getAlias())) {
            tableSource.setAlias(null);
        }
        SQLLateralViewTableSource lateralViewTabSrc = new SQLLateralViewTableSource();
        lateralViewTabSrc.setTableSource(tableSource);
        SQLMethodInvokeExpr udtf = (SQLMethodInvokeExpr)this.exprParser.expr();
        lateralViewTabSrc.setMethod(udtf);
        String alias = this.as();
        lateralViewTabSrc.setAlias(alias);
        this.accept(Token.AS);
        this.exprParser.names(lateralViewTabSrc.getColumns());
        return this.parseTableSourceRest(lateralViewTabSrc);
    }
}

