/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.repository;

import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLTableElement;
import com.alibaba.fastsql.sql.ast.statement.SQLUniqueConstraint;
import com.alibaba.fastsql.sql.repository.SchemaObject;
import com.alibaba.fastsql.sql.repository.SchemaObjectType;
import com.alibaba.fastsql.util.FnvHash;

public class SchemaObjectImpl
implements SchemaObject {
    private final String name;
    private final long hashCode64;
    private final SchemaObjectType type;
    private SQLStatement statement;
    public long rowCount = -1L;

    public SchemaObjectImpl(String name, SchemaObjectType type) {
        this(name, type, null);
    }

    public SchemaObjectImpl(String name, SchemaObjectType type, SQLStatement statement) {
        this.name = name;
        this.type = type;
        this.statement = statement;
        this.hashCode64 = FnvHash.hashCode64(name);
    }

    @Override
    public long nameHashCode64() {
        return this.hashCode64;
    }

    @Override
    public SQLStatement getStatement() {
        return this.statement;
    }

    @Override
    public SQLColumnDefinition findColumn(String columName) {
        long hash = FnvHash.hashCode64(columName);
        return this.findColumn(hash);
    }

    @Override
    public SQLColumnDefinition findColumn(long columNameHash) {
        if (this.statement == null) {
            return null;
        }
        if (this.statement instanceof SQLCreateTableStatement) {
            return ((SQLCreateTableStatement)this.statement).findColumn(columNameHash);
        }
        return null;
    }

    @Override
    public boolean matchIndex(String columnName) {
        if (this.statement == null) {
            return false;
        }
        if (this.statement instanceof SQLCreateTableStatement) {
            SQLTableElement index = ((SQLCreateTableStatement)this.statement).findIndex(columnName);
            return index != null;
        }
        return false;
    }

    @Override
    public boolean matchKey(String columnName) {
        if (this.statement == null) {
            return false;
        }
        if (this.statement instanceof SQLCreateTableStatement) {
            SQLTableElement index = ((SQLCreateTableStatement)this.statement).findIndex(columnName);
            return index instanceof SQLUniqueConstraint;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SchemaObjectType getType() {
        return this.type;
    }

    @Override
    public long getRowCount() {
        return this.rowCount;
    }

    public static enum Type {
        Sequence,
        Table,
        View,
        Index,
        Function;

    }
}

