/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.support.calcite;

import com.alibaba.fastsql.FastsqlException;
import com.alibaba.fastsql.sql.ast.SQLCommentHint;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLLimit;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.SQLOrderBy;
import com.alibaba.fastsql.sql.ast.SQLOrderingSpecification;
import com.alibaba.fastsql.sql.ast.TDDLHint;
import com.alibaba.fastsql.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLAggregateOption;
import com.alibaba.fastsql.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLAllExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLAnyExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLExistsExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLInListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNullExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNumberExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLSomeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLUnaryExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLUnaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLInsertStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionOperator;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.fastsql.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.fastsql.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.alibaba.fastsql.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.fastsql.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.fastsql.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.fastsql.support.calcite.CalciteSqlBasicCall;
import com.alibaba.fastsql.support.calcite.TDDLSqlSelect;
import com.alibaba.fastsql.util.FnvHash;
import com.alibaba.fastsql.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlPrefixOperator;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlUnresolvedFunction;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.fun.SqlQuantifyOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.SqlParserUtil;

public class CalciteMySqlNodeVisitor
extends MySqlASTVisitorAdapter {
    private SqlNode sqlNode;

    public SqlNode getSqlNode() {
        return this.sqlNode;
    }

    @Override
    public boolean visit(MySqlInsertStatement x) {
        SqlNodeList keywords = new SqlNodeList(new ArrayList(), SqlParserPos.ZERO);
        SQLExprTableSource tableSource = x.getTableSource();
        SqlNode targetTable = this.convertToSqlNode(tableSource.getExpr());
        List<SQLInsertStatement.ValuesClause> valuesList = x.getValuesList();
        SqlNode[] rows = new SqlNode[valuesList.size()];
        for (int j = 0; j < valuesList.size(); ++j) {
            List<SQLExpr> values = valuesList.get(j).getValues();
            SqlNode[] valueNodes = new SqlNode[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                SqlNode valueNode;
                valueNodes[i] = valueNode = this.convertToSqlNode(values.get(i));
            }
            SqlBasicCall row = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.ROW, valueNodes, SqlParserPos.ZERO);
            rows[j] = row;
        }
        SqlBasicCall source = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.VALUES, rows, SqlParserPos.ZERO);
        SqlNodeList columnList = this.convertToSqlNodeList(x.getColumns());
        this.sqlNode = new SqlInsert(SqlParserPos.ZERO, keywords, targetTable, (SqlNode)source, columnList);
        return false;
    }

    @Override
    public boolean visit(MySqlUpdateStatement x) {
        if (x.getTableSource().getClass() != SQLExprTableSource.class) {
            throw new UnsupportedOperationException("Support single table only for SqlUpdate statement of calcite.");
        }
        SQLExprTableSource tableSource = (SQLExprTableSource)x.getTableSource();
        SqlNode targetTable = this.convertToSqlNode(tableSource.getExpr());
        ArrayList<SqlNode> columns = new ArrayList<SqlNode>();
        ArrayList<SqlNode> values = new ArrayList<SqlNode>();
        for (SQLUpdateSetItem item : x.getItems()) {
            columns.add(this.convertToSqlNode(item.getColumn()));
            values.add(this.convertToSqlNode(item.getValue()));
        }
        SqlNodeList targetColumnList = new SqlNodeList(columns, SqlParserPos.ZERO);
        SqlNodeList sourceExpressList = new SqlNodeList(values, SqlParserPos.ZERO);
        SqlNode condition = this.convertToSqlNode(x.getWhere());
        SqlIdentifier alias = null;
        if (x.getTableSource().getAlias() != null) {
            alias = new SqlIdentifier(tableSource.getAlias(), SqlParserPos.ZERO);
        }
        this.sqlNode = new SqlUpdate(SqlParserPos.ZERO, targetTable, targetColumnList, sourceExpressList, condition, null, alias);
        return false;
    }

    @Override
    public boolean visit(MySqlDeleteStatement x) {
        SQLExprTableSource tableSource = (SQLExprTableSource)x.getTableSource();
        SqlNode targetTable = this.convertToSqlNode(tableSource.getExpr());
        SqlNode condition = this.convertToSqlNode(x.getWhere());
        SqlIdentifier alias = null;
        if (x.getTableSource().getAlias() != null) {
            alias = new SqlIdentifier(tableSource.getAlias(), SqlParserPos.ZERO);
        }
        this.sqlNode = new SqlDelete(SqlParserPos.ZERO, targetTable, condition, null, alias);
        return false;
    }

    @Override
    public boolean visit(SQLUnionQuery x) {
        SqlNode left = this.convertToSqlNode(x.getLeft());
        SqlNode right = this.convertToSqlNode(x.getRight());
        SqlNodeList orderBySqlNode = null;
        SQLOrderBy orderBy = x.getOrderBy();
        if (orderBy != null) {
            orderBySqlNode = this.convertOrderby(orderBy);
        }
        SqlNode offset = null;
        SqlNode fetch = null;
        SQLLimit limit = x.getLimit();
        if (limit != null) {
            offset = this.convertToSqlNode(limit.getOffset());
            fetch = this.convertToSqlNode(limit.getRowCount());
        }
        SQLUnionOperator operator = x.getOperator();
        SqlBasicCall union = null;
        switch (operator) {
            case UNION_ALL: {
                union = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.UNION_ALL, new SqlNode[]{left, right}, SqlParserPos.ZERO);
                break;
            }
            case UNION: 
            case DISTINCT: {
                union = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.UNION, new SqlNode[]{left, right}, SqlParserPos.ZERO);
                break;
            }
            default: {
                throw new FastsqlException("unsupported join type: " + (Object)((Object)operator));
            }
        }
        this.sqlNode = null == orderBy && null == offset && null == fetch ? union : new SqlOrderBy(SqlParserPos.ZERO, (SqlNode)union, orderBySqlNode, offset, fetch);
        return false;
    }

    @Override
    public boolean visit(MySqlSelectQueryBlock x) {
        SqlNodeList keywordList = null;
        ArrayList<SqlLiteral> keywordNodes = new ArrayList<SqlLiteral>(5);
        int option = x.getDistionOption();
        if (option != 0) {
            if (option == 2 || option == 4) {
                keywordNodes.add(SqlSelectKeyword.DISTINCT.symbol(SqlParserPos.ZERO));
            }
            keywordList = new SqlNodeList(keywordNodes, SqlParserPos.ZERO);
        }
        ArrayList<SqlNode> columnNodes = new ArrayList<SqlNode>(x.getSelectList().size());
        for (SQLSelectItem selectItem : x.getSelectList()) {
            SqlNode column = this.convertToSqlNode(selectItem);
            if (selectItem.getAlias() != null) {
                column = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, new SqlNode[]{column, new SqlIdentifier(selectItem.getAlias(), SqlParserPos.ZERO)}, SqlParserPos.ZERO);
            } else if (!(selectItem.getExpr() instanceof SQLAggregateExpr) && selectItem.getExpr() instanceof SQLMethodInvokeExpr) {
                column = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, new SqlNode[]{column, new SqlIdentifier(((SQLMethodInvokeExpr)selectItem.getExpr()).getMethodName(), SqlParserPos.ZERO)}, SqlParserPos.ZERO);
            }
            columnNodes.add(column);
        }
        SqlNodeList selectList = new SqlNodeList(columnNodes, SqlParserPos.ZERO);
        SqlNode from = null;
        SQLTableSource tableSource = x.getFrom();
        if (tableSource != null) {
            from = this.convertToSqlNode(tableSource);
        }
        SqlNode where = this.convertToSqlNode(x.getWhere());
        SqlNodeList orderBySqlNode = null;
        SQLOrderBy orderBy = x.getOrderBy();
        if (orderBy != null) {
            orderBySqlNode = this.convertOrderby(orderBy);
        }
        SqlNodeList groupBySqlNode = null;
        SqlNode having = null;
        SQLSelectGroupByClause groupBys = x.getGroupBy();
        if (groupBys != null) {
            ArrayList<SqlNode> groupByNodes = new ArrayList<SqlNode>(groupBys.getItems().size());
            if (groupBys.getHaving() != null) {
                having = this.convertToSqlNode(groupBys.getHaving());
            }
            for (SQLExpr groupBy : groupBys.getItems()) {
                SqlNode groupByNode = this.convertToSqlNode(groupBy);
                groupByNodes.add(groupByNode);
            }
            groupBySqlNode = new SqlNodeList(groupByNodes, SqlParserPos.ZERO);
        }
        SqlNode offset = null;
        SqlNode fetch = null;
        SQLLimit limit = x.getLimit();
        if (limit != null) {
            offset = this.convertToSqlNode(limit.getOffset());
            fetch = this.convertToSqlNode(limit.getRowCount());
        }
        SqlNodeList hints = this.convertHints(x.getHints());
        this.sqlNode = new TDDLSqlSelect(SqlParserPos.ZERO, keywordList, selectList, from, where, groupBySqlNode, having, null, orderBySqlNode, offset, fetch, hints, null);
        return false;
    }

    public boolean visit(SQLTableSource x) {
        Class<?> clazz = x.getClass();
        if (clazz == SQLJoinTableSource.class) {
            this.visit((SQLJoinTableSource)x);
        } else if (clazz == SQLExprTableSource.class) {
            this.visit((SQLExprTableSource)x);
        } else if (clazz == SQLSubqueryTableSource.class) {
            this.visit((SQLSubqueryTableSource)x);
        } else {
            x.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        String name = x.getName().getSimpleName();
        List<String> names = Collections.singletonList(name);
        SqlIdentifier table = new SqlIdentifier(names, SqlParserPos.ZERO);
        if (x.getAlias() != null) {
            SqlIdentifier alias = new SqlIdentifier(x.computeAlias(), SqlParserPos.ZERO);
            SqlBasicCall as = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, new SqlNode[]{table, alias}, SqlParserPos.ZERO);
            this.sqlNode = as;
        } else {
            this.sqlNode = table;
        }
        return false;
    }

    @Override
    public boolean visit(SQLJoinTableSource x) {
        SQLJoinTableSource.JoinType joinType = x.getJoinType();
        SqlNode left = this.convertToSqlNode(x.getLeft());
        SqlNode right = this.convertToSqlNode(x.getRight());
        SqlNode condition = this.convertToSqlNode(x.getCondition());
        switch (joinType) {
            case COMMA: {
                this.sqlNode = new SqlJoin(SqlParserPos.ZERO, left, SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), JoinType.COMMA.symbol(SqlParserPos.ZERO), right, JoinConditionType.NONE.symbol(SqlParserPos.ZERO), null);
                break;
            }
            case JOIN: 
            case INNER_JOIN: {
                if (x.getCondition() == null) {
                    this.sqlNode = new SqlJoin(SqlParserPos.ZERO, left, SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), JoinType.COMMA.symbol(SqlParserPos.ZERO), right, JoinConditionType.NONE.symbol(SqlParserPos.ZERO), null);
                    break;
                }
                this.sqlNode = new SqlJoin(SqlParserPos.ZERO, left, SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), JoinType.INNER.symbol(SqlParserPos.ZERO), right, JoinConditionType.ON.symbol(SqlParserPos.ZERO), condition);
                break;
            }
            case LEFT_OUTER_JOIN: {
                this.sqlNode = new SqlJoin(SqlParserPos.ZERO, left, SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), JoinType.LEFT.symbol(SqlParserPos.ZERO), right, JoinConditionType.ON.symbol(SqlParserPos.ZERO), condition);
                break;
            }
            case RIGHT_OUTER_JOIN: {
                this.sqlNode = new SqlJoin(SqlParserPos.ZERO, left, SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), JoinType.RIGHT.symbol(SqlParserPos.ZERO), right, JoinConditionType.ON.symbol(SqlParserPos.ZERO), condition);
                break;
            }
            case NATURAL_JOIN: {
                this.sqlNode = new SqlJoin(SqlParserPos.ZERO, left, SqlLiteral.createBoolean((boolean)true, (SqlParserPos)SqlParserPos.ZERO), JoinType.COMMA.symbol(SqlParserPos.ZERO), right, JoinConditionType.NONE.symbol(SqlParserPos.ZERO), null);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported : " + (Object)((Object)joinType));
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        this.sqlNode = this.convertToSqlNode(x.getSelect());
        if (x.getAlias() != null) {
            SqlIdentifier aliasIdentifier = new SqlIdentifier(x.getAlias(), SqlParserPos.ZERO);
            this.sqlNode = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, new SqlNode[]{this.sqlNode, aliasIdentifier}, SqlParserPos.ZERO);
        }
        return false;
    }

    @Override
    public boolean visit(SQLInSubQueryExpr x) {
        SqlNode left = this.convertToSqlNode(x.getExpr());
        SqlNode right = this.convertToSqlNode(x.subQuery);
        this.sqlNode = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.IN, new SqlNode[]{left, right}, SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLSelect x) {
        SQLWithSubqueryClause withSubQuery = x.getWithSubQuery();
        if (withSubQuery != null) {
            withSubQuery.accept(this);
        }
        this.sqlNode = this.convertToSqlNode(x.getQuery());
        return false;
    }

    @Override
    public boolean visit(SQLSelectStatement x) {
        SqlNode sqlNode = this.convertToSqlNode(x.getSelect());
        if (sqlNode instanceof TDDLSqlSelect) {
            TDDLSqlSelect select = (TDDLSqlSelect)sqlNode;
            SqlNodeList headHints = this.convertHints(x.getHeadHintsDirect());
            select.setHeadHints(headHints);
            this.sqlNode = select;
        } else {
            this.sqlNode = sqlNode;
        }
        return false;
    }

    protected void visit(SQLSelectQuery x) {
        Class<?> clazz = x.getClass();
        if (clazz == MySqlSelectQueryBlock.class) {
            this.visit((MySqlSelectQueryBlock)x);
        } else if (clazz == SQLUnionQuery.class) {
            this.visit((SQLUnionQuery)x);
        } else {
            x.accept(this);
        }
    }

    @Override
    public boolean visit(SQLAllExpr x) {
        this.sqlNode = this.convertToSqlNode(x.getSubQuery());
        return false;
    }

    @Override
    public boolean visit(SQLAnyExpr x) {
        this.sqlNode = this.convertToSqlNode(x.getSubQuery());
        return false;
    }

    private boolean isSqlAllExpr(SQLExpr x) {
        return x.getClass() == SQLAllExpr.class;
    }

    private boolean isAnyOrSomeExpr(SQLExpr x) {
        return x.getClass() == SQLAnyExpr.class || x.getClass() == SQLSomeExpr.class;
    }

    @Override
    public boolean visit(SQLSelectItem x) {
        this.sqlNode = this.convertToSqlNode(x.getExpr());
        SqlIdentifier as = null;
        if (x.getAlias() != null) {
            as = new SqlIdentifier(x.getAlias(), SqlParserPos.ZERO);
        }
        if (as != null) {
            this.sqlNode = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, new SqlNode[]{this.sqlNode, as}, SqlParserPos.ZERO);
        }
        return false;
    }

    @Override
    public boolean visit(SQLIdentifierExpr x) {
        this.sqlNode = new SqlIdentifier(x.getName(), SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLPropertyExpr x) {
        this.sqlNode = new SqlIdentifier(Arrays.asList(x.getOwnernName(), x.getName()), SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        SqlBinaryOperator operator = null;
        SqlQuantifyOperator someOrAllOperator = null;
        SQLExpr rightExpr = x.getRight();
        SqlNode right = this.convertToSqlNode(rightExpr);
        switch (x.getOperator()) {
            case Equality: {
                if (this.isSqlAllExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.ALL_EQ;
                    break;
                }
                if (this.isAnyOrSomeExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.SOME_EQ;
                    break;
                }
                operator = SqlStdOperatorTable.EQUALS;
                break;
            }
            case GreaterThan: {
                if (this.isSqlAllExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.ALL_GT;
                    break;
                }
                if (this.isAnyOrSomeExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.SOME_GT;
                    break;
                }
                operator = SqlStdOperatorTable.GREATER_THAN;
                break;
            }
            case GreaterThanOrEqual: {
                if (this.isSqlAllExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.ALL_GE;
                    break;
                }
                if (this.isAnyOrSomeExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.SOME_GE;
                    break;
                }
                operator = SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
                break;
            }
            case LessThan: {
                if (this.isSqlAllExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.ALL_LT;
                    break;
                }
                if (this.isAnyOrSomeExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.SOME_LT;
                    break;
                }
                operator = SqlStdOperatorTable.LESS_THAN;
                break;
            }
            case LessThanOrEqual: {
                if (this.isSqlAllExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.ALL_LE;
                    break;
                }
                if (this.isAnyOrSomeExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.SOME_LE;
                    break;
                }
                operator = SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
                break;
            }
            case NotEqual: 
            case LessThanOrGreater: {
                if (this.isSqlAllExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.ALL_NE;
                    break;
                }
                if (this.isAnyOrSomeExpr(rightExpr)) {
                    someOrAllOperator = SqlStdOperatorTable.SOME_NE;
                    break;
                }
                operator = SqlStdOperatorTable.NOT_EQUALS;
                break;
            }
            case Add: {
                operator = SqlStdOperatorTable.PLUS;
                break;
            }
            case Subtract: {
                operator = SqlStdOperatorTable.MINUS;
                break;
            }
            case Multiply: {
                operator = SqlStdOperatorTable.MULTIPLY;
                break;
            }
            case Divide: {
                operator = SqlStdOperatorTable.DIVIDE;
                break;
            }
            case Modulus: {
                operator = SqlStdOperatorTable.MOD;
                break;
            }
            case Like: {
                operator = SqlStdOperatorTable.LIKE;
                break;
            }
            case NotLike: {
                operator = SqlStdOperatorTable.NOT_LIKE;
                break;
            }
            case BooleanAnd: {
                operator = SqlStdOperatorTable.AND;
                break;
            }
            case BooleanOr: {
                operator = SqlStdOperatorTable.OR;
                break;
            }
            case Is: {
                if (x.getRight() instanceof SQLNullExpr) {
                    operator = SqlStdOperatorTable.IS_NULL;
                    break;
                }
                if (!(x.getRight() instanceof SQLBooleanExpr)) break;
                if (((SQLBooleanExpr)rightExpr).getValue().booleanValue()) {
                    operator = SqlStdOperatorTable.IS_TRUE;
                    break;
                }
                operator = SqlStdOperatorTable.IS_NOT_TRUE;
                break;
            }
            case IsNot: {
                if (rightExpr instanceof SQLNullExpr) {
                    operator = SqlStdOperatorTable.IS_NOT_NULL;
                    break;
                }
                if (!(rightExpr instanceof SQLBooleanExpr)) break;
                if (((SQLBooleanExpr)rightExpr).getValue().booleanValue()) {
                    operator = SqlStdOperatorTable.IS_NOT_TRUE;
                    break;
                }
                operator = SqlStdOperatorTable.IS_TRUE;
                break;
            }
            default: {
                throw new FastsqlException("not support " + (Object)((Object)x.getOperator()));
            }
        }
        SqlNode left = this.convertToSqlNode(x.getLeft());
        this.sqlNode = someOrAllOperator != null ? new SqlBasicCall((SqlOperator)someOrAllOperator, new SqlNode[]{left, right}, SqlParserPos.ZERO) : (operator == SqlStdOperatorTable.IS_NULL || operator == SqlStdOperatorTable.IS_NOT_NULL || operator == SqlStdOperatorTable.IS_TRUE || operator == SqlStdOperatorTable.IS_NOT_TRUE ? new SqlBasicCall((SqlOperator)operator, new SqlNode[]{left}, SqlParserPos.ZERO) : new SqlBasicCall((SqlOperator)operator, new SqlNode[]{left, right}, SqlParserPos.ZERO));
        return false;
    }

    @Override
    public boolean visit(SQLExistsExpr x) {
        SqlPrefixOperator sqlOperator = SqlStdOperatorTable.EXISTS;
        SqlCall sqlNode = sqlOperator.createCall(SqlParserPos.ZERO, new SqlNode[]{this.convertToSqlNode(x.getSubQuery())});
        if (x.isNot()) {
            sqlNode = SqlStdOperatorTable.NOT.createCall(SqlParserPos.ZERO, new SqlNode[]{sqlNode});
        }
        this.sqlNode = sqlNode;
        return false;
    }

    @Override
    public boolean visit(SQLAllColumnExpr x) {
        this.sqlNode = new SqlIdentifier(Arrays.asList(""), SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLCharExpr x) {
        this.sqlNode = SqlLiteral.createCharString((String)x.getText(), (SqlParserPos)SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLNullExpr x) {
        this.sqlNode = SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLIntegerExpr x) {
        this.sqlNode = SqlLiteral.createExactNumeric((String)String.valueOf(x.getNumber().longValue()), (SqlParserPos)SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLBooleanExpr x) {
        this.sqlNode = SqlLiteral.createBoolean((boolean)x.getBooleanValue(), (SqlParserPos)SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLNumberExpr x) {
        this.sqlNode = SqlLiteral.createExactNumeric((String)x.getNumber().toString(), (SqlParserPos)SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLAggregateExpr x) {
        Object functionOperator = null;
        String methodName = x.getMethodName();
        long hashCode64 = x.methodNameHashCode64();
        functionOperator = hashCode64 == FnvHash.Constants.COUNT ? SqlStdOperatorTable.COUNT : (hashCode64 == FnvHash.Constants.SUM ? SqlStdOperatorTable.SUM : (hashCode64 == FnvHash.Constants.MAX ? SqlStdOperatorTable.MAX : (hashCode64 == FnvHash.Constants.MIN ? SqlStdOperatorTable.MIN : (hashCode64 == FnvHash.Constants.AVG ? SqlStdOperatorTable.AVG : new SqlUnresolvedFunction(new SqlIdentifier(methodName, SqlParserPos.ZERO), null, null, null, null, SqlFunctionCategory.USER_DEFINED_FUNCTION)))));
        SqlLiteral functionQualifier = null;
        if (x.getOption() == SQLAggregateOption.DISTINCT) {
            functionQualifier = SqlSelectKeyword.DISTINCT.symbol(SqlParserPos.ZERO);
        }
        List<SQLExpr> arguments = x.getArguments();
        ArrayList<SqlNode> argNodes = new ArrayList<SqlNode>(arguments.size());
        if (arguments != null) {
            for (SQLExpr exp : arguments) {
                argNodes.add(this.convertToSqlNode(exp));
            }
        }
        this.sqlNode = new CalciteSqlBasicCall((SqlOperator)functionOperator, SqlParserUtil.toNodeArray(argNodes), SqlParserPos.ZERO, false, functionQualifier);
        return false;
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        Object functionOperator = null;
        String methodName = x.getMethodName();
        functionOperator = StringUtils.equals(methodName, "EXISTS") ? SqlStdOperatorTable.EXISTS : new SqlUnresolvedFunction(new SqlIdentifier(methodName, SqlParserPos.ZERO), null, null, null, null, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        SqlLiteral functionQualifier = null;
        List<SQLExpr> arguments = x.getArguments();
        ArrayList<SqlNode> argNodes = new ArrayList<SqlNode>(arguments.size());
        if (arguments != null) {
            for (SQLExpr exp : arguments) {
                argNodes.add(this.convertToSqlNode(exp));
            }
        }
        this.sqlNode = new CalciteSqlBasicCall((SqlOperator)functionOperator, SqlParserUtil.toNodeArray(argNodes), SqlParserPos.ZERO, false, functionQualifier);
        return false;
    }

    @Override
    public boolean visit(SQLInListExpr x) {
        SqlNodeList sqlNodes = this.convertToSqlNodeList(x.getTargetList());
        SqlBinaryOperator sqlOperator = x.isNot() ? SqlStdOperatorTable.NOT_IN : SqlStdOperatorTable.IN;
        this.sqlNode = new SqlBasicCall((SqlOperator)sqlOperator, new SqlNode[]{this.convertToSqlNode(x.getExpr()), sqlNodes}, SqlParserPos.ZERO);
        return false;
    }

    @Override
    public boolean visit(SQLVariantRefExpr x) {
        if ("?".equals(x.getName())) {
            this.sqlNode = new SqlDynamicParam(x.getIndex(), SqlParserPos.ZERO);
            return false;
        }
        System.out.println("end");
        return false;
    }

    @Override
    public boolean visit(SQLUnaryExpr x) {
        SQLUnaryOperator operator = x.getOperator();
        switch (operator) {
            case NOT: {
                this.sqlNode = SqlStdOperatorTable.NOT.createCall(SqlParserPos.ZERO, new SqlNode[]{this.convertToSqlNode(x.getExpr())});
                break;
            }
            case Negative: {
                this.sqlNode = SqlStdOperatorTable.UNARY_MINUS.createCall(SqlParserPos.ZERO, new SqlNode[]{this.convertToSqlNode(x.getExpr())});
                break;
            }
            default: {
                super.visit(x);
            }
        }
        return false;
    }

    protected SqlNodeList convertToSqlNodeList(List<? extends SQLExpr> exprList) {
        int size = exprList.size();
        ArrayList<SqlNode> nodes = new ArrayList<SqlNode>(size);
        for (int i = 0; i < size; ++i) {
            SQLExpr expr = exprList.get(i);
            SqlNode node = this.convertToSqlNode(expr);
            nodes.add(node);
        }
        return new SqlNodeList(nodes, SqlParserPos.ZERO);
    }

    protected SqlNode convertToSqlNode(SQLObject ast) {
        if (ast == null) {
            return null;
        }
        CalciteMySqlNodeVisitor visitor = new CalciteMySqlNodeVisitor();
        ast.accept(visitor);
        return visitor.getSqlNode();
    }

    private SqlNodeList convertOrderby(SQLOrderBy orderBy) {
        List<SQLSelectOrderByItem> items = orderBy.getItems();
        ArrayList<SqlNode> orderByNodes = new ArrayList<SqlNode>(items.size());
        for (SQLSelectOrderByItem item : items) {
            SqlNode node = this.convertToSqlNode(item.getExpr());
            if (item.getType() == SQLOrderingSpecification.DESC) {
                node = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.DESC, new SqlNode[]{node}, SqlParserPos.ZERO);
            }
            orderByNodes.add(node);
        }
        return new SqlNodeList(orderByNodes, SqlParserPos.ZERO);
    }

    private SqlNodeList convertHints(List<SQLCommentHint> hints) {
        if (hints == null) {
            return null;
        }
        ArrayList<SqlNodeList> nodes = new ArrayList<SqlNodeList>(hints.size());
        for (SQLCommentHint hint : hints) {
            if (!(hint instanceof TDDLHint)) continue;
            nodes.add(this.convertTDDLHint((TDDLHint)hint));
        }
        return new SqlNodeList(nodes, SqlParserPos.ZERO);
    }

    private SqlNodeList convertTDDLHint(TDDLHint hint) {
        List<TDDLHint.Function> functions = hint.getFunctions();
        ArrayList<SqlBasicCall> funNodes = new ArrayList<SqlBasicCall>(functions.size());
        for (TDDLHint.Function function : functions) {
            String functionName = function.getName();
            List<TDDLHint.Argument> arguments = function.getArguments();
            SqlNode[] argNodes = new SqlNode[arguments.size()];
            for (int i = 0; i < arguments.size(); ++i) {
                TDDLHint.Argument argument = arguments.get(i);
                SqlNode argName = this.convertToSqlNode(argument.getName());
                SqlNode argValue = this.convertToSqlNode(argument.getValue());
                ArrayList<SqlNode> arg = new ArrayList<SqlNode>();
                if (argName != null) {
                    arg.add(argName);
                }
                if (argValue != null) {
                    arg.add(argValue);
                }
                SqlCall argNode = null;
                if (arg.size() == 2) {
                    argNode = SqlStdOperatorTable.EQUALS.createCall(SqlParserPos.ZERO, arg);
                } else if (arg.size() == 1) {
                    argNode = argName;
                }
                argNodes[i] = argNode;
            }
            SqlBasicCall funNode = new SqlBasicCall((SqlOperator)new SqlUnresolvedFunction(new SqlIdentifier(functionName, SqlParserPos.ZERO), null, null, null, null, SqlFunctionCategory.USER_DEFINED_FUNCTION), argNodes, SqlParserPos.ZERO);
            funNodes.add(funNode);
        }
        return new SqlNodeList(funNodes, SqlParserPos.ZERO);
    }
}

