/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.support.opds.udf;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.visitor.SchemaStatVisitor;
import com.alibaba.fastsql.stat.TableStat;
import com.aliyun.odps.udf.UDF;
import java.util.List;
import java.util.Map;

public class ExportTables
extends UDF {
    public String evaluate(String sql) {
        return this.evaluate(sql, null);
    }

    public String evaluate(String sql, DbType dbType) {
        try {
            List<SQLStatement> statementList = SQLUtils.parseStatements(sql, dbType, new SQLParserFeature[0]);
            SchemaStatVisitor visitor = SQLUtils.createSchemaStatVisitor(dbType);
            for (SQLStatement stmt : statementList) {
                stmt.accept(visitor);
            }
            StringBuffer buf = new StringBuffer();
            for (Map.Entry<TableStat.Name, TableStat> entry : visitor.getTables().entrySet()) {
                TableStat.Name name = entry.getKey();
                if (buf.length() != 0) {
                    buf.append(',');
                }
                buf.append(name.toString());
            }
            return buf.toString();
        }
        catch (Throwable ex) {
            System.err.println("error sql : " + sql);
            ex.printStackTrace();
            return null;
        }
    }
}

