/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.util;

import com.alibaba.fastsql.support.logging.Log;
import com.alibaba.fastsql.support.logging.LogFactory;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class JdbcSqlStatUtils {
    private static final Log LOG = LogFactory.getLog(JdbcSqlStatUtils.class);

    public static long[] rtrim(long[] array) {
        int notZeroLen = array.length;
        int i = array.length - 1;
        while (i >= 0 && array[i] == 0L) {
            --i;
            --notZeroLen;
        }
        if (notZeroLen != array.length) {
            array = Arrays.copyOf(array, notZeroLen);
        }
        return array;
    }

    public static <T> int get(T stat, AtomicIntegerFieldUpdater<T> updater, boolean reset) {
        if (reset) {
            return updater.getAndSet(stat, 0);
        }
        return updater.get(stat);
    }

    public static <T> long get(T stat, AtomicLongFieldUpdater<T> updater, boolean reset) {
        if (reset) {
            return updater.getAndSet(stat, 0L);
        }
        return updater.get(stat);
    }

    public static long get(AtomicLong counter, boolean reset) {
        if (reset) {
            return counter.getAndSet(0L);
        }
        return counter.get();
    }

    public static int get(AtomicInteger counter, boolean reset) {
        if (reset) {
            return counter.getAndSet(0);
        }
        return counter.get();
    }
}

