/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.util;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.util.JdbcUtils;
import com.alibaba.fastsql.util.Utils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MySqlUtils {
    private static Set<String> keywords;
    private static Set<String> builtinDataTypes;

    public static boolean isKeyword(String name) {
        if (name == null) {
            return false;
        }
        String name_lower = name.toLowerCase();
        Set<String> words = keywords;
        if (words == null) {
            words = new HashSet<String>();
            Utils.loadFromFile("META-INF/fastsql/parser/mysql/keywords", words);
            keywords = words;
        }
        return words.contains(name_lower);
    }

    public static boolean isBuiltinDataType(String dataType) {
        if (dataType == null) {
            return false;
        }
        String table_lower = dataType.toLowerCase();
        Set<String> dataTypes = builtinDataTypes;
        if (dataTypes == null) {
            dataTypes = new HashSet<String>();
            Utils.loadFromFile("META-INF/fastsql/parser/mysql/builtin_datatypes", dataTypes);
            builtinDataTypes = dataTypes;
        }
        return dataTypes.contains(table_lower);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> showTables(Connection conn) throws SQLException {
        ArrayList<String> tables = new ArrayList<String>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("show tables");
            while (rs.next()) {
                String tableName = rs.getString(1);
                tables.add(tableName);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.close(rs);
            JdbcUtils.close(stmt);
            throw throwable;
        }
        JdbcUtils.close(rs);
        JdbcUtils.close(stmt);
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> getTableDDL(Connection conn, List<String> tables) throws SQLException {
        ArrayList<String> ddlList = new ArrayList<String>();
        Statement stmt = null;
        try {
            for (String table : tables) {
                ResultSet rs;
                block8: {
                    if (stmt == null) {
                        stmt = conn.createStatement();
                    }
                    if (MySqlUtils.isKeyword(table)) {
                        table = "`" + table + "`";
                    }
                    rs = null;
                    try {
                        rs = stmt.executeQuery("show create table " + table);
                        if (!rs.next()) break block8;
                        String ddl = rs.getString(2);
                        ddlList.add(ddl);
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.close(rs);
                        throw throwable;
                        return ddlList;
                    }
                }
                JdbcUtils.close(rs);
            }
        }
        finally {
            JdbcUtils.close(stmt);
        }
    }

    public static String getCreateTableScript(Connection conn) throws SQLException {
        return MySqlUtils.getCreateTableScript(conn, true, true);
    }

    public static String getCreateTableScript(Connection conn, boolean sorted, boolean simplify) throws SQLException {
        List<String> tables = MySqlUtils.showTables(conn);
        List<String> ddlList = MySqlUtils.getTableDDL(conn, tables);
        StringBuilder buf = new StringBuilder();
        for (String ddl : ddlList) {
            buf.append(ddl);
            buf.append(';');
        }
        String ddlScript = buf.toString();
        if (!sorted && !simplify) {
            return ddlScript;
        }
        List<SQLStatement> stmtList = SQLUtils.parseStatements(ddlScript, DbType.mysql, new SQLParserFeature[0]);
        if (simplify) {
            for (SQLStatement o : stmtList) {
                if (!(o instanceof SQLCreateTableStatement)) continue;
                SQLCreateTableStatement createTableStmt = (SQLCreateTableStatement)o;
                createTableStmt.simplify();
            }
        }
        if (sorted) {
            SQLCreateTableStatement.sort(stmtList);
        }
        return SQLUtils.toSQLString(stmtList, DbType.mysql);
    }
}

