/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.wall;

import com.alibaba.fastsql.support.json.JSONUtils;
import com.alibaba.fastsql.support.logging.Log;
import com.alibaba.fastsql.support.logging.LogFactory;
import com.alibaba.fastsql.wall.WallProviderStatLogger;
import com.alibaba.fastsql.wall.WallProviderStatLoggerAdapter;
import com.alibaba.fastsql.wall.WallProviderStatValue;
import java.util.Map;
import java.util.Properties;

public class WallProviderStatLoggerImpl
extends WallProviderStatLoggerAdapter
implements WallProviderStatLogger {
    private static Log LOG = LogFactory.getLog(WallProviderStatLoggerImpl.class);
    private Log logger = LOG;

    @Override
    public void configFromProperties(Properties properties) {
        String property = properties.getProperty("fastsql.stat.loggerName");
        if (property != null && property.length() > 0) {
            this.setLoggerName(property);
        }
    }

    public void setLoggerName(String loggerName) {
        this.logger = LogFactory.getLog(loggerName);
    }

    public void setLogger(Log logger) {
        if (logger == null) {
            throw new IllegalArgumentException("logger can not be null");
        }
        this.logger = logger;
    }

    public boolean isLogEnable() {
        return this.logger.isInfoEnabled();
    }

    public void log(String value) {
        this.logger.info(value);
    }

    @Override
    public void log(WallProviderStatValue statValue) {
        if (!this.isLogEnable()) {
            return;
        }
        Map<String, Object> map = statValue.toMap();
        String text = JSONUtils.toJSONString(map);
        this.log(text);
    }
}

