/*
 * Decompiled with CFR 0.152.
 */
package mockit;

import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Deencapsulation {
    private Deencapsulation() {
    }

    public static <T> T getField(Object objectWithField, String fieldName) {
        return (T)Utilities.getField(objectWithField.getClass(), fieldName, objectWithField);
    }

    public static <T> T getField(Object objectWithField, Class<T> fieldType) {
        return Utilities.getField(objectWithField.getClass(), fieldType, objectWithField);
    }

    public static <T> T getField(Class<?> classWithStaticField, String fieldName) {
        return (T)Utilities.getField(classWithStaticField, fieldName, null);
    }

    public static <T> T getField(Class<?> classWithStaticField, Class<T> fieldType) {
        return Utilities.getField(classWithStaticField, fieldType, null);
    }

    public static void setField(Object objectWithField, String fieldName, Object fieldValue) {
        Utilities.setField(objectWithField.getClass(), objectWithField, fieldName, fieldValue);
    }

    public static void setField(Object objectWithField, Object fieldValue) {
        Utilities.setField(objectWithField.getClass(), objectWithField, null, fieldValue);
    }

    public static void setField(Class<?> classWithStaticField, String fieldName, Object fieldValue) {
        Utilities.setField(classWithStaticField, null, fieldName, fieldValue);
    }

    public static void setField(Class<?> classWithStaticField, Object fieldValue) {
        Utilities.setField(classWithStaticField, null, null, fieldValue);
    }

    public static <T> T invoke(Object objectWithMethod, String methodName, Object ... nonNullArgs) {
        Class<?> theClass = objectWithMethod.getClass();
        return Utilities.invoke(theClass, objectWithMethod, methodName, nonNullArgs);
    }

    public static <T> T invoke(Class<?> classWithStaticMethod, String methodName, Object ... nonNullArgs) {
        return Utilities.invoke(classWithStaticMethod, null, methodName, nonNullArgs);
    }

    public static <T> T invoke(String classWithStaticMethod, String methodName, Object ... nonNullArgs) {
        Class theClass = Utilities.loadClass(classWithStaticMethod);
        return Utilities.invoke(theClass, null, methodName, nonNullArgs);
    }

    public static <T> T newInstance(String className, Class<?>[] parameterTypes, Object ... initArgs) {
        return Utilities.newInstance(className, parameterTypes, initArgs);
    }

    public static <T> T newInstance(Class<? extends T> classToInstantiate, Class<?>[] parameterTypes, Object ... initArgs) {
        return Utilities.newInstance(classToInstantiate, parameterTypes, initArgs);
    }

    public static <T> T newInstance(String className, Object ... nonNullArgs) {
        return Utilities.newInstance(className, nonNullArgs);
    }

    public static <T> T newInstance(Class<? extends T> classToInstantiate, Object ... nonNullArgs) {
        return Utilities.newInstance(classToInstantiate, nonNullArgs);
    }

    public static <T> T newInnerInstance(String innerClassSimpleName, Object outerClassInstance, Object ... nonNullArgs) {
        return Utilities.newInnerInstance(innerClassSimpleName, outerClassInstance, nonNullArgs);
    }

    public static <T> T newInnerInstance(Class<? extends T> innerClassToInstantiate, Object outerClassInstance, Object ... nonNullArgs) {
        return Utilities.newInnerInstance(innerClassToInstantiate, outerClassInstance, nonNullArgs);
    }
}

