/*
 * Decompiled with CFR 0.152.
 */
package mockit;

import java.util.regex.Pattern;
import mockit.external.hamcrest.BaseMatcher;
import mockit.external.hamcrest.Description;
import mockit.external.hamcrest.HamcrestAdapter;
import mockit.external.hamcrest.Matcher;
import mockit.external.hamcrest.core.IsAnything;
import mockit.external.hamcrest.core.IsEqual;
import mockit.external.hamcrest.core.IsInstanceOf;
import mockit.external.hamcrest.core.IsNot;
import mockit.external.hamcrest.core.IsNull;
import mockit.external.hamcrest.core.IsSame;
import mockit.external.hamcrest.core.StringContains;
import mockit.external.hamcrest.core.StringEndsWith;
import mockit.external.hamcrest.core.StringStartsWith;
import mockit.external.hamcrest.number.IsCloseTo;
import mockit.internal.expectations.TestOnlyPhase;
import mockit.internal.startup.Startup;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Invocations {
    protected static final Object any;
    protected static final String anyString;
    protected static final Long anyLong;
    protected static final Integer anyInt;
    protected static final Short anyShort;
    protected static final Byte anyByte;
    protected static final Boolean anyBoolean;
    protected static final Character anyChar;
    protected static final Double anyDouble;
    protected static final Float anyFloat;
    protected static Object forEachInvocation;
    protected static int times;
    protected static int minTimes;
    protected static int maxTimes;
    protected static CharSequence $;

    Invocations() {
    }

    abstract TestOnlyPhase getCurrentPhase();

    protected final <T> T onInstance(T mockedInstance) {
        if (mockedInstance == null) {
            throw new NullPointerException("Missing mocked instance to match");
        }
        this.getCurrentPhase().setNextInstanceToMatch(mockedInstance);
        return mockedInstance;
    }

    protected final <T> T with(T argValue, Object argumentMatcher) {
        this.addMatcher(HamcrestAdapter.create(argumentMatcher));
        return argValue;
    }

    protected final <T> T with(Object argumentMatcher) {
        HamcrestAdapter adapter = HamcrestAdapter.create(argumentMatcher);
        this.addMatcher(adapter);
        Object argValue = adapter.getInnerValue();
        return (T)argValue;
    }

    private void addMatcher(Matcher<?> matcher) {
        this.getCurrentPhase().addArgMatcher(matcher);
    }

    protected final <T> T withAny(T arg) {
        this.addMatcher(new IsAnything());
        return arg;
    }

    protected final <T> T withEqual(T arg) {
        this.addMatcher(new IsEqual<T>(arg));
        return arg;
    }

    protected final double withEqual(double value, double delta) {
        this.addMatcher(new IsCloseTo(value, delta));
        return value;
    }

    protected final float withEqual(float value, double delta) {
        this.addMatcher(new IsCloseTo(value, delta));
        return value;
    }

    protected final <T> T withInstanceLike(T object) {
        this.addMatcher(new IsInstanceOf(object.getClass()));
        return object;
    }

    protected final <T> T withInstanceOf(Class<T> argClass) {
        this.addMatcher(new IsInstanceOf(argClass));
        return null;
    }

    protected final <T> T withNotEqual(T arg) {
        this.addMatcher(new IsNot<T>(new IsEqual<T>(arg)));
        return arg;
    }

    protected final <T> T withNotNull() {
        this.addMatcher(new IsNot(new IsNull()));
        return null;
    }

    protected final <T> T withNull() {
        this.addMatcher(new IsNull());
        return null;
    }

    protected final <T> T withSameInstance(T object) {
        this.addMatcher(new IsSame<T>(object));
        return object;
    }

    protected final <T extends CharSequence> T withSubstring(T text) {
        this.addMatcher(new StringContains(text));
        return text;
    }

    protected final <T extends CharSequence> T withPrefix(T text) {
        this.addMatcher(new StringStartsWith(text));
        return text;
    }

    protected final <T extends CharSequence> T withSuffix(T text) {
        this.addMatcher(new StringEndsWith(text));
        return text;
    }

    protected final <T extends CharSequence> T withMatch(T regex) {
        final Pattern pattern = Pattern.compile(((Object)regex).toString());
        this.addMatcher(new BaseMatcher<T>(){

            @Override
            public boolean matches(Object item) {
                return pattern.matcher((CharSequence)item).matches();
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("a string matching ").appendValue(pattern);
            }
        });
        return regex;
    }

    protected final <T> T newInstance(String className, Class<?>[] parameterTypes, Object ... initArgs) {
        return Utilities.newInstance(className, parameterTypes, initArgs);
    }

    protected final <T> T newInstance(String className, Object ... nonNullInitArgs) {
        return Utilities.newInstance(className, nonNullInitArgs);
    }

    protected final <T> T newInnerInstance(String innerClassSimpleName, Object outerClassInstance, Object ... nonNullInitArgs) {
        return Utilities.newInnerInstance(innerClassSimpleName, outerClassInstance, nonNullInitArgs);
    }

    protected final <T> T invoke(Object objectWithMethod, String methodName, Object ... methodArgs) {
        return Utilities.invoke(objectWithMethod.getClass(), objectWithMethod, methodName, methodArgs);
    }

    protected final <T> T invoke(Class<?> methodOwner, String methodName, Object ... methodArgs) {
        return Utilities.invoke(methodOwner, null, methodName, methodArgs);
    }

    protected final <T> T getField(Object fieldOwner, String fieldName) {
        return (T)Utilities.getField(fieldOwner.getClass(), fieldName, fieldOwner);
    }

    protected final <T> T getField(Object fieldOwner, Class<T> fieldType) {
        return Utilities.getField(fieldOwner.getClass(), fieldType, fieldOwner);
    }

    protected final <T> T getField(Class<?> fieldOwner, String fieldName) {
        return (T)Utilities.getField(fieldOwner, fieldName, null);
    }

    protected final <T> T getField(Class<?> fieldOwner, Class<T> fieldType) {
        return Utilities.getField(fieldOwner, fieldType, null);
    }

    protected final void setField(Object fieldOwner, String fieldName, Object fieldValue) {
        Utilities.setField(fieldOwner.getClass(), fieldOwner, fieldName, fieldValue);
    }

    protected final void setField(Object fieldOwner, Object fieldValue) {
        Utilities.setField(fieldOwner.getClass(), fieldOwner, null, fieldValue);
    }

    protected final void setField(Class<?> fieldOwner, String fieldName, Object fieldValue) {
        Utilities.setField(fieldOwner, null, fieldName, fieldValue);
    }

    protected final void setField(Class<?> fieldOwner, Object fieldValue) {
        Utilities.setField(fieldOwner, null, null, fieldValue);
    }

    static {
        Startup.verifyInitialization();
        any = null;
        anyString = new String();
        anyLong = 0L;
        anyInt = 0;
        anyShort = 0;
        anyByte = 0;
        anyBoolean = false;
        anyChar = Character.valueOf('\u0000');
        anyDouble = 0.0;
        anyFloat = Float.valueOf(0.0f);
    }
}

