/*
 * Decompiled with CFR 0.152.
 */
package mockit;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import mockit.internal.util.DefaultValues;

final class MockInvocationHandler
implements InvocationHandler {
    static final InvocationHandler INSTANCE = new MockInvocationHandler();

    MockInvocationHandler() {
    }

    public Object invoke(Object proxy, Method method, Object[] args) {
        Class<?> declaringClass = method.getDeclaringClass();
        String methodName = method.getName();
        if (declaringClass == Object.class) {
            if ("equals".equals(methodName)) {
                return proxy == args[0];
            }
            if ("hashCode".equals(methodName)) {
                return System.identityHashCode(proxy);
            }
            if ("toString".equals(methodName)) {
                return proxy.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(proxy));
            }
        } else if (declaringClass == Annotation.class) {
            return proxy.getClass().getInterfaces()[0];
        }
        Class<?> retType = method.getReturnType();
        return DefaultValues.computeForType(retType);
    }
}

