/*
 * Decompiled with CFR 0.152.
 */
package mockit;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import mockit.Mockit;
import mockit.internal.RedefinitionEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MockUp<T> {
    private final T mockInstance;

    protected MockUp() {
        Type typeToMock = this.getTypeToMock();
        this.mockInstance = typeToMock instanceof Class ? this.redefineClass((Class)typeToMock) : (typeToMock instanceof ParameterizedType ? this.redefineClass((Class)((ParameterizedType)typeToMock).getRawType()) : this.createMockInstanceForMultipleInterfaces(typeToMock));
    }

    private Type getTypeToMock() {
        Type genericSuperclass = this.getClass().getGenericSuperclass();
        if (!(genericSuperclass instanceof ParameterizedType)) {
            throw new IllegalArgumentException("No type to be mocked");
        }
        return ((ParameterizedType)genericSuperclass).getActualTypeArguments()[0];
    }

    private T redefineClass(Class<?> classToMock) {
        Object proxy = classToMock.isInterface() ? (Object)Mockit.newEmptyProxy(classToMock) : null;
        Class<?> realClass = proxy == null ? classToMock : proxy.getClass();
        this.redefineMethods(realClass);
        return (T)proxy;
    }

    private void redefineMethods(Class<?> realClass) {
        new RedefinitionEngine(realClass, this, this.getClass()).redefineMethods();
    }

    private T createMockInstanceForMultipleInterfaces(Type typeToMock) {
        Object proxy = Mockit.newEmptyProxy(typeToMock);
        this.redefineMethods(proxy.getClass());
        return (T)proxy;
    }

    protected MockUp(Class<?> classToMock) {
        this.mockInstance = this.redefineClass(classToMock);
    }

    public final T getMockInstance() {
        return this.mockInstance;
    }
}

