/*
 * Decompiled with CFR 0.152.
 */
package mockit;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mockit.MockInvocationHandler;
import mockit.internal.EmptyProxy;
import mockit.internal.RedefinitionEngine;
import mockit.internal.startup.Startup;
import mockit.internal.state.MockFixture;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Mockit {
    private Mockit() {
    }

    public static void stubOut(Class<?> ... realClasses) {
        for (Class<?> realClass : realClasses) {
            new RedefinitionEngine(realClass).stubOut();
        }
    }

    public static void stubOutClass(Class<?> realClass, String ... filters) {
        new RedefinitionEngine(realClass, true, filters).stubOut();
    }

    public static void stubOutClass(Class<?> realClass, boolean inverse, String ... filters) {
        new RedefinitionEngine(realClass, !inverse, filters).stubOut();
    }

    public static void stubOutClass(String realClassName, String ... filters) {
        Class realClass = Utilities.loadClass(realClassName);
        new RedefinitionEngine(realClass, true, filters).stubOut();
    }

    public static void stubOutClass(String realClassName, boolean inverse, String ... filters) {
        Class realClass = Utilities.loadClass(realClassName);
        new RedefinitionEngine(realClass, !inverse, filters).stubOut();
    }

    public static void setUpMocksAndStubs(Class<?> ... mockAndRealClasses) {
        for (Class<?> mockOrRealClass : mockAndRealClasses) {
            RedefinitionEngine redefinition = new RedefinitionEngine(mockOrRealClass);
            if (redefinition.isWithMockClass()) {
                redefinition.redefineMethods();
                continue;
            }
            redefinition.stubOut();
        }
    }

    public static void setUpMocks(Object ... mockClassesOrInstances) {
        for (Object mockClassOrInstance : mockClassesOrInstances) {
            Object mock;
            Class<?> mockClass;
            if (mockClassOrInstance instanceof Class) {
                mockClass = (Class<?>)mockClassOrInstance;
                mock = null;
            } else {
                mockClass = mockClassOrInstance.getClass();
                mock = mockClassOrInstance;
            }
            new RedefinitionEngine(mock, mockClass).redefineMethods();
        }
    }

    public static void setUpStartupMocks(Object ... mockClassesOrInstances) {
        for (Object mockClassOrInstance : mockClassesOrInstances) {
            Object mock;
            Class<?> mockClass;
            if (mockClassOrInstance instanceof Class) {
                mockClass = (Class<?>)mockClassOrInstance;
                mock = null;
            } else {
                mockClass = mockClassOrInstance.getClass();
                mock = mockClassOrInstance;
            }
            new RedefinitionEngine(mock, mockClass).setUpStartupMock();
        }
    }

    public static void setUpMock(Class<?> realClass, Object mock) {
        Class<?> mockClass = mock.getClass();
        new RedefinitionEngine(realClass, mock, mockClass).redefineMethods();
    }

    public static void setUpMock(String realClassName, Object mock) {
        Class realClass = Utilities.loadClass(realClassName);
        Mockit.setUpMock(realClass, mock);
    }

    public static void setUpMock(Class<?> realClass, Class<?> mockClass) {
        new RedefinitionEngine(realClass, null, mockClass).redefineMethods();
    }

    public static void setUpMock(String realClassName, Class<?> mockClass) {
        Class realClass = Utilities.loadClass(realClassName);
        Mockit.setUpMock(realClass, mockClass);
    }

    public static <T> T setUpMock(Object mockClassOrInstance) {
        Object mock;
        Class<?> mockClass;
        if (mockClassOrInstance instanceof Class) {
            mockClass = (Class<?>)mockClassOrInstance;
            mock = null;
        } else {
            mockClass = mockClassOrInstance.getClass();
            mock = mockClassOrInstance;
        }
        RedefinitionEngine redefinition = new RedefinitionEngine(mock, mockClass);
        Class<?> realClass = redefinition.getRealClass();
        Object proxy = null;
        if (realClass.isInterface()) {
            proxy = Mockit.newEmptyProxy(mockClass.getClassLoader(), realClass);
            redefinition.setRealClass(proxy.getClass());
        }
        redefinition.redefineMethods();
        return (T)proxy;
    }

    public static void tearDownMocks() {
        MockFixture mockFixture = TestRun.mockFixture();
        Set<Class<?>> redefinedClasses = mockFixture.getRedefinedClasses();
        mockFixture.restoreAndRemoveRedefinedClasses(redefinedClasses);
        assert (mockFixture.getRedefinedClassCount() == 0);
        TestRun.getMockClasses().getRegularMocks().discardInstances();
    }

    public static void tearDownMocks(Class<?> ... realClasses) {
        HashSet classesToRestore = new HashSet();
        Collections.addAll(classesToRestore, realClasses);
        TestRun.mockFixture().restoreAndRemoveRedefinedClasses(classesToRestore);
    }

    public static <E> E newEmptyProxy(Class<E> interfaceToBeProxied) {
        return Mockit.newEmptyProxy(interfaceToBeProxied.getClassLoader(), interfaceToBeProxied);
    }

    public static <E> E newEmptyProxy(ClassLoader loader, Class<E> interfaceToBeProxied) {
        Class[] classArray;
        if (loader == null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = interfaceToBeProxied;
        } else {
            Class[] classArray3 = new Class[2];
            classArray3[0] = interfaceToBeProxied;
            classArray = classArray3;
            classArray3[1] = EmptyProxy.class;
        }
        Class[] interfaces = classArray;
        return (E)Proxy.newProxyInstance(loader, interfaces, MockInvocationHandler.INSTANCE);
    }

    public static <E> E newEmptyProxy(Type ... interfacesToBeProxied) {
        ArrayList interfaces = new ArrayList();
        for (Type type : interfacesToBeProxied) {
            Mockit.addInterface(interfaces, type);
        }
        ClassLoader loader = ((Class)interfaces.get(0)).getClassLoader();
        if (loader == EmptyProxy.class.getClassLoader()) {
            interfaces.add(EmptyProxy.class);
        }
        Class[] interfacesArray = interfaces.toArray(new Class[interfaces.size()]);
        return (E)Proxy.newProxyInstance(loader, interfacesArray, MockInvocationHandler.INSTANCE);
    }

    private static void addInterface(List<Class<?>> interfaces, Type type) {
        if (type instanceof Class) {
            interfaces.add((Class)type);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            interfaces.add((Class)paramType.getRawType());
        } else if (type instanceof TypeVariable) {
            TypeVariable typeVar = (TypeVariable)type;
            Mockit.addBoundInterfaces(interfaces, typeVar.getBounds());
        }
    }

    private static void addBoundInterfaces(List<Class<?>> interfaces, Type[] bounds) {
        for (Type bound : bounds) {
            Mockit.addInterface(interfaces, bound);
        }
    }

    static {
        Startup.verifyInitialization();
    }
}

