/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration;

import java.lang.reflect.Method;
import mockit.Capturing;
import mockit.Mockit;
import mockit.UsingMocksAndStubs;
import mockit.internal.capturing.CaptureOfImplementationsForTestClass;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.mocking.ParameterTypeRedefinitions;
import mockit.internal.expectations.mocking.SharedFieldTypeRedefinitions;
import mockit.internal.expectations.mocking.TestedClassInstantiations;
import mockit.internal.state.SavePoint;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRunnerDecorator {
    private static SavePoint savePointForTest;

    protected final void updateTestClassState(Object target, Class<?> testClass) {
        try {
            this.handleSwitchToNewTestClassIfApplicable(testClass);
            if (target != null) {
                this.handleMockFieldsForWholeTestClass(target);
            }
        }
        catch (Error e) {
            try {
                SavePoint.rollbackForTestClass();
            }
            catch (Error err) {
                Utilities.filterStackTrace(err);
                throw err;
            }
            throw e;
        }
        catch (RuntimeException e) {
            SavePoint.rollbackForTestClass();
            Utilities.filterStackTrace(e);
            throw e;
        }
    }

    private void handleSwitchToNewTestClassIfApplicable(Class<?> testClass) {
        Class<?> currentTestClass = TestRun.getCurrentTestClass();
        if (testClass != currentTestClass) {
            if (currentTestClass == null) {
                SavePoint.registerNewActiveSavePoint();
            } else if (!currentTestClass.isAssignableFrom(testClass)) {
                TestRunnerDecorator.cleanUpMocksFromPreviousTestClass();
                SavePoint.registerNewActiveSavePoint();
            }
            this.applyClassLevelMockingIfSpecifiedForTestClass(testClass);
            TestRun.setCurrentTestClass(testClass);
        }
    }

    public static void cleanUpMocksFromPreviousTestClass() {
        SharedFieldTypeRedefinitions redefinitions;
        if (savePointForTest != null) {
            savePointForTest.rollback();
            savePointForTest = null;
        }
        SavePoint.rollbackForTestClass();
        CaptureOfImplementationsForTestClass capture = TestRun.getCaptureOfSubtypes();
        if (capture != null) {
            capture.cleanUp();
            TestRun.setCaptureOfSubtypes(null);
        }
        if ((redefinitions = TestRun.getSharedFieldTypeRedefinitions()) != null) {
            redefinitions.cleanUp();
            TestRun.setSharedFieldTypeRedefinitions(null);
        }
    }

    private void applyClassLevelMockingIfSpecifiedForTestClass(Class<?> testClass) {
        this.setUpClassLevelMocksAndStubs(testClass);
        this.setUpClassLevelCapturing(testClass);
    }

    protected final void setUpClassLevelMocksAndStubs(Class<?> testClass) {
        UsingMocksAndStubs mocksAndStubs = testClass.getAnnotation(UsingMocksAndStubs.class);
        if (mocksAndStubs != null) {
            Mockit.setUpMocksAndStubs(mocksAndStubs.value());
        }
    }

    private void setUpClassLevelCapturing(Class<?> testClass) {
        Capturing capturingType = testClass.getAnnotation(Capturing.class);
        if (capturingType != null) {
            CaptureOfImplementationsForTestClass capture = new CaptureOfImplementationsForTestClass();
            capture.makeSureAllSubtypesAreModified(capturingType);
            TestRun.setCaptureOfSubtypes(capture);
        }
    }

    protected final void prepareForNextTest() {
        if (savePointForTest != null) {
            savePointForTest.rollback();
        }
        savePointForTest = new SavePoint();
        TestRun.prepareForNextTest();
    }

    private void handleMockFieldsForWholeTestClass(Object target) {
        SharedFieldTypeRedefinitions sharedRedefinitions = TestRun.getSharedFieldTypeRedefinitions();
        if (sharedRedefinitions == null) {
            sharedRedefinitions = new SharedFieldTypeRedefinitions(target);
            sharedRedefinitions.redefineTypesForTestClass();
            TestRun.setSharedFieldTypeRedefinitions(sharedRedefinitions);
        }
        if (target != TestRun.getCurrentTestInstance()) {
            sharedRedefinitions.assignNewInstancesToMockFields(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void createInstancesForTestedFields(Object target) {
        TestedClassInstantiations testedClasses;
        SharedFieldTypeRedefinitions sharedRedefinitions = TestRun.getSharedFieldTypeRedefinitions();
        if (sharedRedefinitions != null && (testedClasses = sharedRedefinitions.getTestedClassInstantiations()) != null) {
            TestRun.enterNoMockingZone();
            try {
                testedClasses.assignNewInstancesToTestedFields(target);
            }
            finally {
                TestRun.exitNoMockingZone();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object[] createInstancesForMockParameters(Object target, Method testMethod) {
        if (testMethod.getParameterTypes().length == 0) {
            return null;
        }
        TestRun.enterNoMockingZone();
        try {
            ParameterTypeRedefinitions redefinitions = new ParameterTypeRedefinitions(target, testMethod);
            TestRun.getExecutingTest().setParameterTypeRedefinitions(redefinitions);
            Object[] objectArray = redefinitions.getParameterValues();
            return objectArray;
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void concludeTestMethodExecution(SavePoint savePoint) {
        TestRun.enterNoMockingZone();
        AssertionError expectationsFailure = RecordAndReplayExecution.endCurrentReplayIfAny();
        try {
            if (expectationsFailure == null) {
                TestRun.verifyExpectationsOnAnnotatedMocks();
            }
        }
        finally {
            TestRun.resetExpectationsOnAnnotatedMocks();
            savePoint.rollback();
            TestRun.exitNoMockingZone();
        }
        if (expectationsFailure != null) {
            throw expectationsFailure;
        }
    }
}

