/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration.junit3.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.TestCase;
import mockit.Instantiation;
import mockit.Mock;
import mockit.MockClass;
import mockit.integration.TestRunnerDecorator;
import mockit.internal.state.SavePoint;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;

@MockClass(realClass=TestCase.class, instantiation=Instantiation.PerMockedInstance)
public final class JUnitTestCaseDecorator
extends TestRunnerDecorator {
    private static final Method setUpMethod;
    private static final Method tearDownMethod;
    private static final Method runTestMethod;
    private static final Field fName;
    public TestCase it;

    @Mock
    public void runBare() throws Throwable {
        this.updateTestClassState(this.it, this.it.getClass());
        this.prepareForNextTest();
        TestRun.setRunningIndividualTest(this.it);
        try {
            this.originalRunBare();
        }
        catch (Throwable t) {
            Utilities.filterStackTrace(t);
            throw t;
        }
        finally {
            TestRun.setRunningIndividualTest(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void originalRunBare() throws Throwable {
        setUpMethod.invoke((Object)this.it, new Object[0]);
        Throwable exception = null;
        try {
            this.executeCurrentTestMethod();
        }
        catch (Throwable running) {
            exception = running;
        }
        finally {
            TestRun.finishCurrentTestExecution(true);
            exception = this.performTearDown(exception);
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void executeCurrentTestMethod() throws Throwable {
        Method testMethod = this.findTestMethod();
        TestRun.setRunningTestMethod(testMethod);
        this.executeTestMethod(testMethod);
    }

    private Method findTestMethod() throws IllegalAccessException {
        String testMethodName = (String)fName.get(this.it);
        for (Method publicMethod : this.it.getClass().getMethods()) {
            if (!publicMethod.getName().equals(testMethodName)) continue;
            return publicMethod;
        }
        return runTestMethod;
    }

    private void executeTestMethod(Method testMethod) throws Throwable {
        SavePoint savePoint = new SavePoint();
        try {
            this.createInstancesForTestedFields(this.it);
            Object[] mockParameters = this.createInstancesForMockParameters(this.it, testMethod);
            if (mockParameters == null) {
                runTestMethod.invoke((Object)this.it, new Object[0]);
            } else {
                testMethod.invoke((Object)this.it, mockParameters);
            }
        }
        catch (InvocationTargetException e) {
            e.fillInStackTrace();
            throw e.getTargetException();
        }
        catch (IllegalAccessException e) {
            e.fillInStackTrace();
            throw e;
        }
        finally {
            this.concludeTestMethodExecution(savePoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Throwable performTearDown(Throwable thrownByTestMethod) {
        try {
            tearDownMethod.invoke((Object)this.it, new Object[0]);
            Throwable throwable = thrownByTestMethod;
            return throwable;
        }
        catch (Throwable tearingDown) {
            Throwable throwable = thrownByTestMethod == null ? tearingDown : thrownByTestMethod;
            return throwable;
        }
        finally {
            TestRun.getExecutingTest().setRecordAndReplay(null);
        }
    }

    static {
        try {
            setUpMethod = TestCase.class.getDeclaredMethod("setUp", new Class[0]);
            tearDownMethod = TestCase.class.getDeclaredMethod("tearDown", new Class[0]);
            runTestMethod = TestCase.class.getDeclaredMethod("runTest", new Class[0]);
            fName = TestCase.class.getDeclaredField("fName");
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        setUpMethod.setAccessible(true);
        tearDownMethod.setAccessible(true);
        runTestMethod.setAccessible(true);
        fName.setAccessible(true);
    }
}

